/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Constants {
    public static final String ATTR_HOST = "host";
    public static final String INT = "int";
    public static final String NUMBER = "number";
    public static final String STRING = "string";
    public static final String INT64 = "int64";
    public static final String INT32 = "int32";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String HTTP_PAYLOAD = "http:Payload";
    public static final String HTTP_SERVICE_CONFIG = "http:ServiceConfig";
    public static final String OPENAPI = "openapi";
    public static final String HTTP = "http";
    public static final String JSON_DATA = "data.jsondata";
    public static final String NAME_CONFIG = "NameConfig";
    public static final String NAME = "name";
    public static final String BALLERINA = "ballerina";
    public static final String EMPTY = "";
    public static final String HTTP_SERVICE_CONTRACT_INFO = "ServiceContractInformation";
    public static final String OPENAPI_DEFINITION = "openApiDefinition";
    public static final String HTTP_SERVICE_CONTRACT = "ServiceContract";
    public static final String INTERCEPTABLE_SERVICE = "InterceptableService";
    public static final String NEXT_SERVICE = "NextService";
    public static final String INTERCEPTOR = "Interceptor";
    public static final String RESPONSE = "Response";
    public static final String STATUS_CODE_RESPONSE = "StatusCodeResponse";
    public static final String ERROR_PAYLOAD = "ErrorPayload";
    public static final String TREAT_NILABLE_AS_OPTIONAL = "treatNilableAsOptional";
    public static final String HTTP_HEADER = "http:Header";
    public static final String HTTP_QUERY = "http:Query";
    public static final String BYTE = "byte";
    public static final String XML = "xml";
    public static final String JSON = "json";
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PATCH = "PATCH";
    public static final String DELETE = "DELETE";
    public static final String PUT = "PUT";
    public static final String OPTIONS = "OPTIONS";
    public static final String HEAD = "HEAD";
    public static final String OPENAPI_SUFFIX = "_openapi";
    public static final String SERVER = "server";
    public static final String PORT = "port";
    public static final String HTTP_REQUEST = "http:Request";
    public static final String DEFAULT = "default";
    public static final String DEFAULT_STATUS_CODE_RESPONSE = "DefaultStatusCodeResponse";
    public static final String WILD_CARD_CONTENT_KEY = "*/*";
    public static final String WILD_CARD_SUMMARY = "Any type of entity body";
    public static final String MEDIA_TYPE = "mediaType";
    public static final String REGEX_INTERPOLATION_PATTERN = "^(?!.*\\$\\{).+$";
    public static final String DATE_CONSTRAINT_ANNOTATION = "constraint:Date";
    public static final String PATH = "path";
    public static final String QUERY = "query";
    public static final String HEADER = "header";
    public static final String HTTP_PAYLOAD_TYPE = "HttpPayload";
    public static final String HTTP_QUERY_TYPE = "HttpQuery";
    public static final String HTTP_HEADER_TYPE = "HttpHeader";
    public static final String EXAMPLE = "example";
    public static final String REQUEST = "request";
    public static final String DEFAULT_LISTENER_FUNCTION_NAME = "getDefaultListener";
    public static final Map<String, String> HTTP_CODES;
    public static final Map<String, String> HTTP_STATUS_CODE_ERRORS;
    public static final Map<String, String> HTTP_CODE_DESCRIPTIONS;
    public static final String HTTP_200 = "200";
    public static final String HTTP_201 = "201";
    public static final String HTTP_202 = "202";
    public static final String ACCEPTED = "Accepted";
    public static final String HTTP_400 = "400";
    public static final String HTTP_500 = "500";
    public static final String SPECIAL_CHAR_REGEX = "([\\[\\]\\\\?!<>@#&~`*\\-=^+();:\\/\\_{}\\s|.$])";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String ETAG = "ETag";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String MUST_REVALIDATE = "must-revalidate";
    public static final String NO_CACHE = "no-cache";
    public static final String NO_STORE = "no-store";
    public static final String NO_TRANSFORM = "no-transform";
    public static final String PRIVATE = "private";
    public static final String PUBLIC = "public";
    public static final String PROXY_REVALIDATE = "proxy-revalidate";
    public static final String MAX_AGE = "max-age";
    public static final String S_MAX_AGE = "s-maxage";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String SLASH = "/";
    public static final String HYPHEN = "-";
    public static final String CONTRACT = "contract";
    public static final String VERSION = "version";
    public static final String TITLE = "title";
    public static final String EMAIL = "email";
    public static final String DESCRIPTION = "description";
    public static final String CONTACT_NAME = "contactName";
    public static final String CONTACT_URL = "contactURL";
    public static final String LICENSE_NAME = "licenseName";
    public static final String LICENSE_URL = "licenseURL";
    public static final String TERMS_OF_SERVICE = "termsOfService";
    public static final String OPENAPI_ANNOTATION = "openapi:ServiceInfo";
    public static final String YAML_EXTENSION = ".yaml";
    public static final String JSON_EXTENSION = ".json";
    public static final String YML_EXTENSION = ".yml";
    public static final String UNDERSCORE = "_";
    public static final String OPENAPI_RESOURCE_INFO = "openapi:ResourceInfo";
    public static final String TAGS = "tags";
    public static final String SUMMARY = "summary";
    public static final String EXAMPLES = "examples";
    public static final String OPERATION_ID = "operationId";
    public static final String RESPONSE_ATTRIBUTE = "response";
    public static final String REQUEST_BODY_ATTRIBUTE = "requestBody";
    public static final String VALUE = "value";
    public static final String FILE_PATH = "filePath";

    private Constants() {
    }

    static {
        HashMap<String, String> httpCodeMap = new HashMap<String, String>();
        httpCodeMap.put("Continue", "100");
        httpCodeMap.put("SwitchingProtocols", "101");
        httpCodeMap.put("Processing", "102");
        httpCodeMap.put("EarlyHints", "103");
        httpCodeMap.put("Ok", HTTP_200);
        httpCodeMap.put("Created", HTTP_201);
        httpCodeMap.put(ACCEPTED, HTTP_202);
        httpCodeMap.put("NonAuthoritativeInformation", "203");
        httpCodeMap.put("NoContent", "204");
        httpCodeMap.put("ResetContent", "205");
        httpCodeMap.put("PartialContent", "206");
        httpCodeMap.put("MultiStatus", "207");
        httpCodeMap.put("AlreadyReported", "208");
        httpCodeMap.put("IMUsed", "226");
        httpCodeMap.put("MultipleChoices", "300");
        httpCodeMap.put("MovedPermanently", "301");
        httpCodeMap.put("Found", "302");
        httpCodeMap.put("SeeOther", "303");
        httpCodeMap.put("NotModified", "304");
        httpCodeMap.put("UseProxy", "305");
        httpCodeMap.put("TemporaryRedirect", "307");
        httpCodeMap.put("PermanentRedirect", "308");
        httpCodeMap.put("BadRequest", HTTP_400);
        httpCodeMap.put("Unauthorized", "401");
        httpCodeMap.put("PaymentRequired", "402");
        httpCodeMap.put("Forbidden", "403");
        httpCodeMap.put("NotFound", "404");
        httpCodeMap.put("MethodNotAllowed", "405");
        httpCodeMap.put("NotAcceptable", "406");
        httpCodeMap.put("ProxyAuthenticationRequired", "407");
        httpCodeMap.put("RequestTimeout", "408");
        httpCodeMap.put("Conflict", "409");
        httpCodeMap.put("Gone", "410");
        httpCodeMap.put("LengthRequired", "411");
        httpCodeMap.put("PreconditionFailed", "412");
        httpCodeMap.put("PayloadTooLarge", "413");
        httpCodeMap.put("UriTooLong", "414");
        httpCodeMap.put("UnsupportedMediaType", "415");
        httpCodeMap.put("RangeNotSatisfiable", "416");
        httpCodeMap.put("ExpectationFailed", "417");
        httpCodeMap.put("MisdirectedRequest", "421");
        httpCodeMap.put("UnprocessableEntity", "422");
        httpCodeMap.put("Locked", "423");
        httpCodeMap.put("FailedDependency", "424");
        httpCodeMap.put("TooEarly", "425");
        httpCodeMap.put("UpgradeRequired", "426");
        httpCodeMap.put("PreconditionRequired", "428");
        httpCodeMap.put("TooManyRequests", "429");
        httpCodeMap.put("RequestHeaderFieldsTooLarge", "431");
        httpCodeMap.put("UnavailableDueToLegalReasons", "451");
        httpCodeMap.put("InternalServerError", HTTP_500);
        httpCodeMap.put("NotImplemented", "501");
        httpCodeMap.put("BadGateway", "502");
        httpCodeMap.put("ServiceUnavailable", "503");
        httpCodeMap.put("GatewayTimeout", "504");
        httpCodeMap.put("HttpVersionNotSupported", "505");
        httpCodeMap.put("VariantAlsoNegotiates", "506");
        httpCodeMap.put("InsufficientStorage", "507");
        httpCodeMap.put("LoopDetected", "508");
        httpCodeMap.put("NotExtended", "510");
        httpCodeMap.put("NetworkAuthenticationRequired", "511");
        httpCodeMap.put("NetworkAuthorizationRequired", "511");
        HTTP_CODES = Collections.unmodifiableMap(httpCodeMap);
        HashMap<String, String> httpErrorCodeMap = new HashMap<String, String>();
        httpErrorCodeMap.put("DefaultStatusCodeError", DEFAULT);
        httpErrorCodeMap.put("BadRequestError", HTTP_400);
        httpErrorCodeMap.put("UnauthorizedError", "401");
        httpErrorCodeMap.put("PaymentRequiredError", "402");
        httpErrorCodeMap.put("ForbiddenError", "403");
        httpErrorCodeMap.put("NotFoundError", "404");
        httpErrorCodeMap.put("MethodNotAllowedError", "405");
        httpErrorCodeMap.put("NotAcceptableError", "406");
        httpErrorCodeMap.put("ProxyAuthenticationRequiredError", "407");
        httpErrorCodeMap.put("RequestTimeoutError", "408");
        httpErrorCodeMap.put("ConflictError", "409");
        httpErrorCodeMap.put("GoneError", "410");
        httpErrorCodeMap.put("LengthRequiredError", "411");
        httpErrorCodeMap.put("PreconditionFailedError", "412");
        httpErrorCodeMap.put("PayloadTooLargeError", "413");
        httpErrorCodeMap.put("URITooLongError", "414");
        httpErrorCodeMap.put("UnsupportedMediaTypeError", "415");
        httpErrorCodeMap.put("RangeNotSatisfiableError", "416");
        httpErrorCodeMap.put("ExpectationFailedError", "417");
        httpErrorCodeMap.put("MisdirectedRequestError", "421");
        httpErrorCodeMap.put("UnprocessableEntityError", "422");
        httpErrorCodeMap.put("LockedError", "423");
        httpErrorCodeMap.put("FailedDependencyError", "424");
        httpErrorCodeMap.put("TooEarlyError", "425");
        httpErrorCodeMap.put("UpgradeRequiredError", "426");
        httpErrorCodeMap.put("PreconditionRequiredError", "428");
        httpErrorCodeMap.put("TooManyRequestsError", "429");
        httpErrorCodeMap.put("RequestHeaderFieldsTooLargeError", "431");
        httpErrorCodeMap.put("UnavailableDueToLegalReasonsError", "451");
        httpErrorCodeMap.put("InternalServerErrorError", HTTP_500);
        httpErrorCodeMap.put("NotImplementedError", "501");
        httpErrorCodeMap.put("BadGatewayError", "502");
        httpErrorCodeMap.put("ServiceUnavailableError", "503");
        httpErrorCodeMap.put("GatewayTimeoutError", "504");
        httpErrorCodeMap.put("HTTPVersionNotSupportedError", "505");
        httpErrorCodeMap.put("VariantAlsoNegotiatesError", "506");
        httpErrorCodeMap.put("InsufficientStorageError", "507");
        httpErrorCodeMap.put("LoopDetectedError", "508");
        httpErrorCodeMap.put("NotExtendedError", "510");
        httpErrorCodeMap.put("NetworkAuthenticationRequiredError", "511");
        HTTP_STATUS_CODE_ERRORS = Collections.unmodifiableMap(httpErrorCodeMap);
        HashMap<String, String> httpCodeDescriptionMap = new HashMap<String, String>();
        httpCodeDescriptionMap.put("100", "Continue");
        httpCodeDescriptionMap.put("101", "SwitchingProtocols");
        httpCodeDescriptionMap.put("102", "Processing");
        httpCodeDescriptionMap.put("103", "EarlyHints");
        httpCodeDescriptionMap.put(HTTP_200, "Ok");
        httpCodeDescriptionMap.put(HTTP_201, "Created");
        httpCodeDescriptionMap.put(HTTP_202, ACCEPTED);
        httpCodeDescriptionMap.put("203", "NonAuthoritativeInformation");
        httpCodeDescriptionMap.put("204", "NoContent");
        httpCodeDescriptionMap.put("205", "ResetContent");
        httpCodeDescriptionMap.put("206", "PartialContent");
        httpCodeDescriptionMap.put("207", "MultiStatus");
        httpCodeDescriptionMap.put("208", "AlreadyReported");
        httpCodeDescriptionMap.put("226", "IMUsed");
        httpCodeDescriptionMap.put("300", "MultipleChoices");
        httpCodeDescriptionMap.put("301", "MovedPermanently");
        httpCodeDescriptionMap.put("302", "Found");
        httpCodeDescriptionMap.put("303", "SeeOther");
        httpCodeDescriptionMap.put("304", "NotModified");
        httpCodeDescriptionMap.put("305", "UseProxy");
        httpCodeDescriptionMap.put("307", "TemporaryRedirect");
        httpCodeDescriptionMap.put("308", "PermanentRedirect");
        httpCodeDescriptionMap.put(HTTP_400, "BadRequest");
        httpCodeDescriptionMap.put("401", "Unauthorized");
        httpCodeDescriptionMap.put("402", "PaymentRequired");
        httpCodeDescriptionMap.put("403", "Forbidden");
        httpCodeDescriptionMap.put("404", "NotFound");
        httpCodeDescriptionMap.put("405", "MethodNotAllowed");
        httpCodeDescriptionMap.put("406", "NotAcceptable");
        httpCodeDescriptionMap.put("407", "ProxyAuthenticationRequired");
        httpCodeDescriptionMap.put("408", "RequestTimeout");
        httpCodeDescriptionMap.put("409", "Conflict");
        httpCodeDescriptionMap.put("410", "Gone");
        httpCodeDescriptionMap.put("411", "LengthRequired");
        httpCodeDescriptionMap.put("412", "PreconditionFailed");
        httpCodeDescriptionMap.put("413", "PayloadTooLarge");
        httpCodeDescriptionMap.put("414", "UriTooLong");
        httpCodeDescriptionMap.put("415", "UnsupportedMediaType");
        httpCodeDescriptionMap.put("416", "RangeNotSatisfiable");
        httpCodeDescriptionMap.put("417", "ExpectationFailed");
        httpCodeDescriptionMap.put("421", "MisdirectedRequest");
        httpCodeDescriptionMap.put("422", "UnprocessableEntity");
        httpCodeDescriptionMap.put("423", "Locked");
        httpCodeDescriptionMap.put("424", "FailedDependency");
        httpCodeDescriptionMap.put("425", "TooEarly");
        httpCodeDescriptionMap.put("426", "UpgradeRequired");
        httpCodeDescriptionMap.put("428", "PreconditionRequired");
        httpCodeDescriptionMap.put("429", "TooManyRequests");
        httpCodeDescriptionMap.put("431", "RequestHeaderFieldsTooLarge");
        httpCodeDescriptionMap.put("451", "UnavailableDueToLegalReasons");
        httpCodeDescriptionMap.put(HTTP_500, "InternalServerError");
        httpCodeDescriptionMap.put("501", "NotImplemented");
        httpCodeDescriptionMap.put("502", "BadGateway");
        httpCodeDescriptionMap.put("503", "ServiceUnavailable");
        httpCodeDescriptionMap.put("504", "GatewayTimeout");
        httpCodeDescriptionMap.put("505", "HttpVersionNotSupported");
        httpCodeDescriptionMap.put("506", "VariantAlsoNegotiates");
        httpCodeDescriptionMap.put("507", "InsufficientStorage");
        httpCodeDescriptionMap.put("508", "LoopDetected");
        httpCodeDescriptionMap.put("510", "NotExtended");
        httpCodeDescriptionMap.put("511", "NetworkAuthenticationRequired");
        httpCodeDescriptionMap.put(DEFAULT, "Default response");
        HTTP_CODE_DESCRIPTIONS = Collections.unmodifiableMap(httpCodeDescriptionMap);
    }

    public static enum OpenAPIType {
        INTEGER("integer"),
        STRING("string"),
        NUMBER("number"),
        BOOLEAN("boolean"),
        RECORD("object"),
        ARRAY("array");

        private final String name;

        private OpenAPIType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum BallerinaType {
        INT("int"),
        STRING("string"),
        DECIMAL("decimal"),
        BOOLEAN("boolean"),
        RECORD("record"),
        ARRAY("array");

        private final String name;

        private BallerinaType(String name) {
            this.name = name;
        }

        public String typeName() {
            return this.name;
        }
    }
}

