/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper;

import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.openapi.service.mapper.ServersMapper;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.model.ModuleMemberVisitor;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ServersMapperImpl
implements ServersMapper {
    final OpenAPI openAPI;
    final Set<ListenerDeclarationNode> endpoints;
    final ServiceNode service;
    final ModuleMemberVisitor moduleMemberVisitor;
    final List<OpenAPIMapperDiagnostic> diagnostics;

    @Deprecated(forRemoval=true, since="2.3.3")
    public ServersMapperImpl(OpenAPI openAPI, Set<ListenerDeclarationNode> endpoints, ServiceNode service) {
        this.openAPI = openAPI;
        this.endpoints = endpoints;
        this.service = service;
        this.moduleMemberVisitor = null;
        this.diagnostics = new ArrayList<OpenAPIMapperDiagnostic>();
    }

    public ServersMapperImpl(OpenAPI openAPI, AdditionalData additionalData, Set<ListenerDeclarationNode> endpoints, ServiceNode service) {
        this.openAPI = openAPI;
        this.endpoints = endpoints;
        this.service = service;
        this.moduleMemberVisitor = additionalData.moduleMemberVisitor();
        this.diagnostics = additionalData.diagnostics();
    }

    @Override
    public void setServers() {
        if (this.service.kind().equals((Object)ServiceNode.Kind.SERVICE_OBJECT_TYPE)) {
            Server defaultServer = ServersMapperImpl.getDefaultServerWithBasePath(this.service.absoluteResourcePath());
            this.openAPI.setServers(Collections.singletonList(defaultServer));
            return;
        }
        this.extractServerForExpressionNode();
        List servers = this.openAPI.getServers();
        if (!this.endpoints.isEmpty()) {
            for (ListenerDeclarationNode ep : this.endpoints) {
                SeparatedNodeList<ExpressionNode> exprNodes = this.service.expressions();
                for (ExpressionNode node : exprNodes) {
                    this.updateServerDetails(servers, ep, node);
                }
            }
        }
        if (this.hasEmptyServer()) {
            this.diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_141, new String[0]));
            this.openAPI.setServers(null);
            return;
        }
        if (servers.size() > 1) {
            Server mainServer = ServersMapperImpl.addEnumValues(servers);
            this.openAPI.setServers(Collections.singletonList(mainServer));
        }
    }

    private boolean hasEmptyServer() {
        return this.openAPI.getServers().isEmpty() || this.openAPI.getServers().stream().allMatch(server -> Objects.isNull(server.getUrl()) && (Objects.isNull(server.getVariables()) || server.getVariables().isEmpty()));
    }

    private void updateServerDetails(List<Server> servers, ListenerDeclarationNode endPoint, ExpressionNode expNode) {
        if (expNode instanceof QualifiedNameReferenceNode) {
            QualifiedNameReferenceNode refNode = (QualifiedNameReferenceNode)expNode;
            if (refNode.identifier().text().trim().equals(endPoint.variableName().text().trim())) {
                String serviceBasePath = this.service.absoluteResourcePath();
                Server server = this.extractServer(endPoint, serviceBasePath);
                servers.add(server);
            }
        } else if (expNode.toString().trim().equals(endPoint.variableName().text().trim())) {
            String serviceBasePath = this.service.absoluteResourcePath();
            Server server = this.extractServer(endPoint, serviceBasePath);
            servers.add(server);
        }
    }

    private static Server addEnumValues(List<Server> servers) {
        Server mainServer = servers.get(0);
        ArrayList<Server> rotated = new ArrayList<Server>(servers);
        ServerVariables mainVariable = mainServer.getVariables();
        ServerVariable hostVariable = (ServerVariable)mainVariable.get((Object)"server");
        ServerVariable portVariable = (ServerVariable)mainVariable.get((Object)"port");
        if (servers.size() > 1) {
            Collections.rotate(rotated, servers.size() - 1);
            for (Server server : rotated) {
                ServerVariables variables = server.getVariables();
                if (variables.get((Object)"server") != null) {
                    hostVariable.addEnumItem(((ServerVariable)variables.get((Object)"server")).getDefault());
                }
                if (variables.get((Object)"port") == null) continue;
                portVariable.addEnumItem(((ServerVariable)variables.get((Object)"port")).getDefault());
            }
        }
        return mainServer;
    }

    private Server extractServer(ListenerDeclarationNode ep, String serviceBasePath) {
        Object expression = ep.initializer().kind() == SyntaxKind.CHECK_EXPRESSION ? ((CheckExpressionNode)ep.initializer()).expression() : ep.initializer();
        if (ServersMapperImpl.isHttpDefaultListener(expression)) {
            return ServersMapperImpl.getDefaultServerWithBasePath(serviceBasePath);
        }
        Optional<ParenthesizedArgList> list = ServersMapperImpl.extractListenerNodeType(expression);
        return this.generateServer(serviceBasePath, list);
    }

    private static Optional<ParenthesizedArgList> extractListenerNodeType(Node expression) {
        Optional list = Optional.empty();
        if (expression instanceof ExplicitNewExpressionNode) {
            ExplicitNewExpressionNode newExpression = (ExplicitNewExpressionNode)expression;
            list = Optional.ofNullable(newExpression.parenthesizedArgList());
        } else if (expression instanceof ImplicitNewExpressionNode) {
            ImplicitNewExpressionNode newExpression = (ImplicitNewExpressionNode)expression;
            list = newExpression.parenthesizedArgList();
        }
        return list;
    }

    private static boolean isHttpDefaultListener(Node expression) {
        QualifiedNameReferenceNode qualifiedName;
        if (expression.kind() != SyntaxKind.FUNCTION_CALL) {
            return false;
        }
        FunctionCallExpressionNode functionCall = (FunctionCallExpressionNode)expression;
        NameReferenceNode functionName = functionCall.functionName();
        return functionName instanceof QualifiedNameReferenceNode && "http".equals((qualifiedName = (QualifiedNameReferenceNode)functionName).modulePrefix().text()) && "getDefaultListener".equals(qualifiedName.identifier().text());
    }

    private void extractServerForExpressionNode() {
        SeparatedNodeList<ExpressionNode> bTypeExplicit = this.service.expressions();
        String serviceBasePath = this.service.absoluteResourcePath();
        ArrayList<Server> servers = new ArrayList<Server>();
        for (ExpressionNode expressionNode : bTypeExplicit) {
            if (!expressionNode.kind().equals((Object)SyntaxKind.EXPLICIT_NEW_EXPRESSION)) continue;
            ExplicitNewExpressionNode explicit = (ExplicitNewExpressionNode)expressionNode;
            Optional<ParenthesizedArgList> list = Optional.ofNullable(explicit.parenthesizedArgList());
            Server server = this.generateServer(serviceBasePath, list);
            servers.add(server);
        }
        this.openAPI.setServers(servers);
    }

    private Server generateServer(String serviceBasePath, Optional<ParenthesizedArgList> list) {
        String port = null;
        String host = null;
        ServerVariables serverVariables = new ServerVariables();
        Server server = new Server();
        if (list.isPresent()) {
            FunctionArgumentNode arg;
            int index;
            SeparatedNodeList arguments = list.get().arguments();
            for (index = 0; index < arguments.size() && !((arg = (FunctionArgumentNode)arguments.get(index)) instanceof NamedArgumentNode); ++index) {
                MappingConstructorExpressionNode config;
                PositionalArgumentNode posArg;
                PositionalArgumentNode portArgument;
                if (index == 0) {
                    portArgument = (PositionalArgumentNode)arg;
                    port = this.getPortValue(portArgument.expression()).orElse(null);
                    continue;
                }
                if (index != 1 || !(arg instanceof PositionalArgumentNode) || !((portArgument = (posArg = (PositionalArgumentNode)arg).expression()) instanceof MappingConstructorExpressionNode) || !ServersMapperImpl.hasHostField(config = (MappingConstructorExpressionNode)portArgument)) continue;
                host = ServersMapperImpl.extractHost(config);
            }
            while (index < arguments.size()) {
                arg = (FunctionArgumentNode)arguments.get(index);
                if (arg instanceof NamedArgumentNode) {
                    NamedArgumentNode namedArg = (NamedArgumentNode)arg;
                    String name = namedArg.argumentName().toString().trim();
                    ExpressionNode expr = namedArg.expression();
                    switch (name) {
                        case "port": {
                            port = this.getPortValue(expr).orElse(null);
                            break;
                        }
                        case "host": {
                            host = expr.toString().replaceAll("^\"|\"$", "");
                            break;
                        }
                        case "config": {
                            MappingConstructorExpressionNode config;
                            if (!(expr instanceof MappingConstructorExpressionNode) || !ServersMapperImpl.hasHostField(config = (MappingConstructorExpressionNode)expr)) break;
                            host = ServersMapperImpl.extractHost(config);
                            break;
                        }
                    }
                }
                ++index;
            }
        }
        ServersMapperImpl.setServerVariableValues(serviceBasePath, port, host, serverVariables, server);
        return server;
    }

    private Optional<String> getPortValue(ExpressionNode expression) {
        return this.getPortValue(expression, false);
    }

    private Optional<String> getPortValue(ExpressionNode expression, boolean parentIsConfigurable) {
        if (expression.kind().equals((Object)SyntaxKind.NUMERIC_LITERAL)) {
            BasicLiteralNode literal = (BasicLiteralNode)expression;
            return Optional.of(literal.literalToken().text());
        }
        if (!expression.kind().equals((Object)SyntaxKind.SIMPLE_NAME_REFERENCE)) {
            if (expression.kind().equals((Object)SyntaxKind.QUALIFIED_NAME_REFERENCE)) {
                this.diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_142, (Location)expression.location(), new String[0]));
                return Optional.empty();
            }
            this.diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_143, (Location)expression.location(), new String[0]));
            return Optional.empty();
        }
        SimpleNameReferenceNode simpleName = (SimpleNameReferenceNode)expression;
        String portVariableName = simpleName.name().text();
        if (this.moduleMemberVisitor == null) {
            return Optional.empty();
        }
        if (!this.moduleMemberVisitor.hasVariableDeclaration(portVariableName)) {
            this.diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_144, (Location)expression.location(), new String[0]));
            return Optional.empty();
        }
        ModuleMemberVisitor.VariableDeclaredValue variableDeclaredValue = this.moduleMemberVisitor.getVariableDeclaredValue(portVariableName);
        ExpressionNode portValue = variableDeclaredValue.value();
        if (portValue.kind().equals((Object)SyntaxKind.REQUIRED_EXPRESSION)) {
            this.diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_146, (Location)portValue.location(), new String[0]));
            return Optional.empty();
        }
        if (portValue.kind().equals((Object)SyntaxKind.NUMERIC_LITERAL)) {
            if (parentIsConfigurable || variableDeclaredValue.isConfigurable()) {
                this.diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_145, (Location)portValue.location(), new String[0]));
            }
            BasicLiteralNode literal = (BasicLiteralNode)portValue;
            return Optional.of(literal.literalToken().text());
        }
        return this.getPortValue(portValue, variableDeclaredValue.isConfigurable());
    }

    private static boolean hasHostField(MappingConstructorExpressionNode config) {
        return config.fields().stream().anyMatch(field -> {
            SpecificFieldNode specific;
            return field instanceof SpecificFieldNode && "host".equals((specific = (SpecificFieldNode)field).fieldName().toString().trim());
        });
    }

    private static void setServerVariableValues(String serviceBasePath, String port, String host, ServerVariables serverVariables, Server server) {
        Object serverUrl;
        if (port == null) {
            return;
        }
        ServerVariable serverUrlVariable = new ServerVariable();
        if (host != null) {
            serverUrlVariable._default(host);
            ServerVariable portVariable = new ServerVariable();
            portVariable._default(port);
            serverVariables.addServerVariable("server", serverUrlVariable);
            serverVariables.addServerVariable("port", portVariable);
            serverUrl = String.format("{server}:{port}%s", serviceBasePath);
        } else {
            if (port.equals("443")) {
                serverUrlVariable._default("https://localhost");
                ServerVariable portVariable = new ServerVariable();
                portVariable._default("443");
                serverVariables.addServerVariable("server", serverUrlVariable);
                serverVariables.addServerVariable("port", portVariable);
            } else {
                serverUrlVariable._default("http://localhost");
                ServerVariable portVariable = new ServerVariable();
                portVariable._default(port);
                serverVariables.addServerVariable("server", serverUrlVariable);
                serverVariables.addServerVariable("port", portVariable);
            }
            serverUrl = "{server}:{port}" + serviceBasePath;
        }
        server.setUrl((String)serverUrl);
        server.setVariables(serverVariables);
    }

    private static String extractHost(MappingConstructorExpressionNode bLangRecordLiteral) {
        String host = "";
        if (bLangRecordLiteral.fields() != null && !bLangRecordLiteral.fields().isEmpty()) {
            SeparatedNodeList recordFields = bLangRecordLiteral.fields();
            host = ServersMapperImpl.concatenateServerURL(host, (SeparatedNodeList<MappingFieldNode>)recordFields);
        }
        if (!host.isEmpty()) {
            host = host.replaceAll("\"", "");
        }
        return host;
    }

    private static String concatenateServerURL(String host, SeparatedNodeList<MappingFieldNode> recordFields) {
        for (MappingFieldNode filed : recordFields) {
            Node fieldName;
            if (!(filed instanceof SpecificFieldNode) || !(fieldName = ((SpecificFieldNode)filed).fieldName()).toString().equals("host") || !((SpecificFieldNode)filed).valueExpr().isPresent()) continue;
            host = ((ExpressionNode)((SpecificFieldNode)filed).valueExpr().get()).toString();
        }
        return host;
    }

    private static Server getDefaultServerWithBasePath(String serviceBasePath) {
        String serverUrl = String.format("http://{server}:{port}%s", serviceBasePath);
        ServerVariables serverVariables = new ServerVariables();
        ServerVariable serverUrlVariable = new ServerVariable();
        serverUrlVariable._default("localhost");
        serverVariables.addServerVariable("server", serverUrlVariable);
        ServerVariable portVariable = new ServerVariable();
        portVariable._default("9090");
        serverVariables.addServerVariable("port", portVariable);
        Server server = new Server();
        server.setUrl(serverUrl);
        server.setVariables(serverVariables);
        return server;
    }
}

