/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.example;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.values.ConstantValue;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.example.ExampleAnnotationMapper;
import io.ballerina.openapi.service.mapper.example.field.RecordFieldExampleMapper;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;

public final class CommonUtils {
    private static final String EXAMPLE_VALUES = "ExampleValues";
    private static final String EXAMPLE_VALUE = "ExampleValue";
    private static final String VALUE = "value";
    private static final String QUOTE = "\"";
    private static final String COMMA = ",";
    private static final String BRACKET_START = "[";
    private static final String BRACKET_END = "]";
    private static final String COLON = ":";
    private static final String BRACE_START = "{";
    private static final String BRACE_END = "}";
    public static final String INLINE_REC = "<inline-record>";

    private CommonUtils() {
    }

    public static Optional<Object> extractOpenApiExampleValue(List<AnnotationAttachmentSymbol> annotations, SemanticModel semanticModel) throws JsonProcessingException {
        Optional<AnnotationAttachmentSymbol> openAPIExample = annotations.stream().filter(annotAttachment -> CommonUtils.isOpenAPIExampleAnnotation(annotAttachment, semanticModel)).findFirst();
        if (openAPIExample.isEmpty() || !openAPIExample.get().isConstAnnotation() || openAPIExample.get().attachmentValue().isEmpty()) {
            return Optional.empty();
        }
        Object exampleValue = ((ConstantValue)openAPIExample.get().attachmentValue().get()).value();
        return CommonUtils.getExampleFromValue(exampleValue);
    }

    private static Optional<Object> getExampleFromValue(Object exampleValue) throws JsonProcessingException {
        if (exampleValue instanceof ConstantValue) {
            ConstantValue constantExampleValue = (ConstantValue)exampleValue;
            exampleValue = constantExampleValue.value();
        } else if (exampleValue instanceof BLangConstantValue) {
            BLangConstantValue constantExampleValue = (BLangConstantValue)exampleValue;
            exampleValue = constantExampleValue.value;
        }
        if (!(exampleValue instanceof HashMap)) {
            return Optional.empty();
        }
        HashMap exampleMap = (HashMap)exampleValue;
        Object value = exampleMap.get(VALUE);
        if (Objects.isNull(value) || !(value instanceof ConstantValue)) {
            return Optional.empty();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        return Optional.of(objectMapper.readValue(CommonUtils.getJsonString(value), Object.class));
    }

    public static boolean isOpenAPIExampleAnnotation(AnnotationAttachmentSymbol annotAttachment, SemanticModel semanticModel) {
        return CommonUtils.isOpenAPIAnnotation(annotAttachment, EXAMPLE_VALUE, semanticModel);
    }

    public static Optional<Map<String, Example>> extractOpenApiExampleValues(List<AnnotationAttachmentSymbol> annotations, SemanticModel semanticModel) throws JsonProcessingException {
        Optional<AnnotationAttachmentSymbol> openAPIExamples = annotations.stream().filter(annotAttachment -> CommonUtils.isOpenAPIExamplesAnnotation(annotAttachment, semanticModel)).findFirst();
        if (openAPIExamples.isEmpty() || !openAPIExamples.get().isConstAnnotation() || openAPIExamples.get().attachmentValue().isEmpty()) {
            return Optional.empty();
        }
        Object exampleValues = ((ConstantValue)openAPIExamples.get().attachmentValue().get()).value();
        if (!(exampleValues instanceof HashMap)) {
            return Optional.empty();
        }
        HashMap exampleValuesMap = (HashMap)exampleValues;
        HashMap<String, Example> examplesMap = new HashMap<String, Example>();
        for (Map.Entry entry : exampleValuesMap.entrySet()) {
            Optional<Object> exampleValue = CommonUtils.getExampleFromValue(entry.getValue());
            if (exampleValue.isEmpty()) continue;
            Example example = new Example();
            example.setValue(exampleValue.get());
            examplesMap.put(entry.getKey().toString(), example);
        }
        return Optional.of(examplesMap);
    }

    public static boolean isOpenAPIExamplesAnnotation(AnnotationAttachmentSymbol annotAttachment, SemanticModel semanticModel) {
        return CommonUtils.isOpenAPIAnnotation(annotAttachment, EXAMPLE_VALUES, semanticModel);
    }

    private static boolean isOpenAPIAnnotation(AnnotationAttachmentSymbol annotAttachment, String annotationName, SemanticModel semanticModel) {
        Object t;
        if (annotAttachment.typeDescriptor().typeDescriptor().isEmpty()) {
            return false;
        }
        Optional exampleValueSymbol = semanticModel.types().getTypeByName("ballerina", "openapi", "", annotationName);
        if (exampleValueSymbol.isEmpty() || !((t = exampleValueSymbol.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol serviceContractInfoType = (TypeDefinitionSymbol)t;
        return ((TypeSymbol)annotAttachment.typeDescriptor().typeDescriptor().get()).subtypeOf(serviceContractInfoType.typeDescriptor());
    }

    public static String getJsonString(Object value) {
        if (value instanceof ConstantValue) {
            ConstantValue constantValue = (ConstantValue)value;
            return CommonUtils.getJsonString(constantValue.value());
        }
        if (value instanceof BLangConstantValue) {
            BLangConstantValue constantValue = (BLangConstantValue)value;
            return CommonUtils.getJsonString(constantValue.value);
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return QUOTE + stringValue + QUOTE;
        }
        if (value instanceof ArrayList) {
            ArrayList objects = (ArrayList)value;
            return objects.stream().map(CommonUtils::getJsonString).collect(Collectors.joining(COMMA, BRACKET_START, BRACKET_END));
        }
        if (value instanceof HashMap) {
            HashMap hashMap = (HashMap)value;
            return hashMap.entrySet().stream().map(entry -> CommonUtils.getJsonString(entry.getKey()) + COLON + CommonUtils.getJsonString(entry.getValue())).collect(Collectors.joining(COMMA, BRACE_START, BRACE_END));
        }
        return value.toString();
    }

    public static void setExampleForInlineRecordFields(TypeSymbol type, Schema schema, SemanticModel semanticModel, List<OpenAPIMapperDiagnostic> diagnostics) {
        if (type instanceof RecordTypeSymbol) {
            RecordTypeSymbol recordType = (RecordTypeSymbol)type;
            if (Objects.nonNull(schema) && schema instanceof ObjectSchema) {
                ObjectSchema objectSchema = (ObjectSchema)schema;
                RecordFieldExampleMapper recordExampleMapper = new RecordFieldExampleMapper(INLINE_REC, recordType, objectSchema, semanticModel, diagnostics);
                ((ExampleAnnotationMapper)recordExampleMapper).setExample();
            }
        }
    }
}

