/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.example.field;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.example.CommonUtils;
import io.ballerina.openapi.service.mapper.example.ExampleAnnotationMapper;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RecordFieldExampleMapper
extends ExampleAnnotationMapper {
    String recordName;
    RecordTypeSymbol recordTypeSymbol;
    ObjectSchema schema;
    List<OpenAPIMapperDiagnostic> diagnostics;
    Location location;

    public RecordFieldExampleMapper(String recordName, RecordTypeSymbol recordTypeSymbol, ObjectSchema schema, SemanticModel semanticModel, List<OpenAPIMapperDiagnostic> diagnostics) {
        super(semanticModel);
        this.recordName = recordName;
        this.recordTypeSymbol = recordTypeSymbol;
        this.schema = schema;
        this.diagnostics = diagnostics;
        this.location = recordTypeSymbol.getLocation().orElse(null);
    }

    @Override
    public void setExample() {
        Map recordFields = this.recordTypeSymbol.fieldDescriptors();
        if (Objects.isNull(recordFields) || recordFields.isEmpty()) {
            return;
        }
        recordFields.forEach((fieldName, fieldSymbol) -> {
            this.setPropertyExample((String)fieldName, (RecordFieldSymbol)fieldSymbol);
            this.setExampleForInlineRecord((String)fieldName, (RecordFieldSymbol)fieldSymbol);
        });
    }

    private void setPropertyExample(String fieldName, RecordFieldSymbol fieldSymbol) {
        List annotations = fieldSymbol.annotAttachments();
        try {
            Optional<Object> example = this.extractExample(annotations);
            if (example.isEmpty()) {
                return;
            }
            ((Schema)this.schema.getProperties().get(MapperCommonUtils.unescapeIdentifier(fieldName.trim()))).setExample(example.get());
        }
        catch (JsonProcessingException exp) {
            this.diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_133, this.location, this.recordName, fieldName));
        }
    }

    private void setExampleForInlineRecord(String fieldName, RecordFieldSymbol fieldSymbol) {
        TypeSymbol fieldType = fieldSymbol.typeDescriptor();
        if (Objects.isNull(this.schema.getProperties())) {
            return;
        }
        Schema fieldSchema = (Schema)this.schema.getProperties().get(MapperCommonUtils.unescapeIdentifier(fieldName.trim()));
        CommonUtils.setExampleForInlineRecordFields(fieldType, fieldSchema, this.getSemanticModel(), this.diagnostics);
    }
}

