/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.example.parameter;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.example.CommonUtils;
import io.ballerina.openapi.service.mapper.example.ExamplesAnnotationMapper;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class RequestExampleMapper
extends ExamplesAnnotationMapper {
    RequestBody requestBody;
    List<OpenAPIMapperDiagnostic> diagnostics;
    List<AnnotationAttachmentSymbol> annotations;
    String paramName;
    Location location;
    TypeSymbol paramType;
    Content validatedContent;

    public RequestExampleMapper(ParameterSymbol parameterSymbol, RequestBody requestBody, SemanticModel semanticModel, List<OpenAPIMapperDiagnostic> diagnostics) {
        super(semanticModel);
        this.annotations = parameterSymbol.annotAttachments();
        this.requestBody = requestBody;
        this.diagnostics = diagnostics;
        this.paramName = parameterSymbol.getName().orElse("");
        this.location = parameterSymbol.getLocation().orElse(null);
        this.paramType = parameterSymbol.typeDescriptor();
        this.validatedContent = this.getValidatedContent();
    }

    @Override
    public void setExample() {
        try {
            if (Objects.isNull(this.validatedContent)) {
                return;
            }
            Set mediaTypes = this.validatedContent.keySet();
            String mediaType = (String)mediaTypes.stream().findFirst().get();
            MediaType mediaTypeObject = (MediaType)this.validatedContent.get((Object)mediaType);
            this.setExampleForInlineRecordFields(mediaTypeObject);
            Optional<Object> exampleValue = this.extractExample(this.annotations);
            if (exampleValue.isEmpty()) {
                return;
            }
            mediaTypeObject.setExample(exampleValue.get());
        }
        catch (JsonProcessingException exception) {
            this.diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_134, this.location, "example", "request", this.paramName));
        }
    }

    private void setExampleForInlineRecordFields(MediaType mediaTypeObject) {
        Schema schema = mediaTypeObject.getSchema();
        CommonUtils.setExampleForInlineRecordFields(this.paramType, schema, this.getSemanticModel(), this.diagnostics);
    }

    private Content getValidatedContent() {
        if (Objects.isNull(this.requestBody)) {
            return null;
        }
        Content content = this.requestBody.getContent();
        if (Objects.isNull(content)) {
            return null;
        }
        int mediaTypesSize = content.size();
        if (mediaTypesSize != 1) {
            this.diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_135, this.location, this.paramName));
            return null;
        }
        return content;
    }

    @Override
    public void setExamples() {
        try {
            Optional<Map<String, Example>> exampleValues = this.extractExamples(this.annotations);
            if (exampleValues.isEmpty()) {
                return;
            }
            if (Objects.isNull(this.validatedContent)) {
                return;
            }
            this.validatedContent.forEach((mediaType, mediaTypeObject) -> mediaTypeObject.setExamples((Map)exampleValues.get()));
        }
        catch (JsonProcessingException exception) {
            this.diagnostics.add(new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_134, this.location, "examples", "request", this.paramName));
        }
    }
}

