/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.resource;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.interceptor.resource.PathSegmentNode;

public class PathParameterSegmentNode
extends PathSegmentNode {
    private TypeSymbol parameterType;

    public PathParameterSegmentNode(TypeSymbol parameterType) {
        this.parameterType = parameterType;
    }

    @Override
    public PathSegmentNode.Type getType() {
        return PathSegmentNode.Type.PARAMETER_SEGMENT;
    }

    @Override
    public boolean matches(PathSegmentNode refPathSegmentNode, SemanticModel semanticModel) {
        return switch (refPathSegmentNode.getType()) {
            default -> throw new MatchException(null, null);
            case PathSegmentNode.Type.DOT_SEGMENT, PathSegmentNode.Type.NAMED_SEGMENT -> false;
            case PathSegmentNode.Type.PARAMETER_SEGMENT -> {
                TypeSymbol refParameterType = ((PathParameterSegmentNode)refPathSegmentNode).getParameterType();
                if (semanticModel.types().STRING.subtypeOf(refParameterType) || this.parameterType.subtypeOf(refParameterType)) {
                    yield true;
                }
                yield false;
            }
        };
    }

    public TypeSymbol getParameterType() {
        return this.parameterType;
    }
}

