/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.types;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.openapi.service.mapper.interceptor.InterceptorMapperException;
import io.ballerina.openapi.service.mapper.interceptor.resource.ResourceMatcher;
import io.ballerina.openapi.service.mapper.interceptor.types.Interceptor;
import io.ballerina.openapi.service.mapper.interceptor.types.TargetResource;
import io.ballerina.openapi.service.mapper.model.ModuleMemberVisitor;
import java.util.Map;
import java.util.Optional;

public class RequestInterceptor
extends Interceptor {
    public RequestInterceptor(TypeReferenceTypeSymbol typeSymbol, SemanticModel semanticModel, ModuleMemberVisitor moduleMemberVisitor) throws InterceptorMapperException {
        super(typeSymbol, semanticModel, moduleMemberVisitor);
    }

    @Override
    protected void extractInterceptorDetails(SemanticModel semanticModel) {
        Map serviceMethods = this.serviceClass.methods();
        Optional<ResourceMethodSymbol> resourceMethodOpt = serviceMethods.values().stream().filter(methodSymbol -> methodSymbol instanceof ResourceMethodSymbol).map(methodSymbol -> (ResourceMethodSymbol)methodSymbol).findFirst();
        if (resourceMethodOpt.isEmpty()) {
            return;
        }
        ResourceMethodSymbol resourceMethod = resourceMethodOpt.get();
        Optional optReturnType = resourceMethod.typeDescriptor().returnTypeDescriptor();
        this.resourceMethod = resourceMethod;
        optReturnType.ifPresent(this::setReturnType);
    }

    @Override
    public Interceptor.InterceptorType getType() {
        return Interceptor.InterceptorType.REQUEST;
    }

    @Override
    public boolean isInvokable(TargetResource targetResource) {
        return ResourceMatcher.match(this.resourceMethod, targetResource.getResourceMethodSymbol(), this.semanticModel);
    }

    @Override
    protected FunctionDefinitionNode getFunctionDefinitionNode() {
        return this.serviceClassNode.members().stream().filter(node -> node.kind().equals((Object)SyntaxKind.RESOURCE_ACCESSOR_DEFINITION)).findFirst().orElse(null);
    }
}

