/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.types;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.openapi.service.mapper.interceptor.InterceptorMapperException;
import io.ballerina.openapi.service.mapper.interceptor.types.Interceptor;
import io.ballerina.openapi.service.mapper.interceptor.types.TargetResource;
import io.ballerina.openapi.service.mapper.model.ModuleMemberVisitor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResponseInterceptor
extends Interceptor {
    public ResponseInterceptor(TypeReferenceTypeSymbol typeSymbol, SemanticModel semanticModel, ModuleMemberVisitor moduleMemberVisitor) throws InterceptorMapperException {
        super(typeSymbol, semanticModel, moduleMemberVisitor);
    }

    @Override
    protected void extractInterceptorDetails(SemanticModel semanticModel) {
        Map serviceMethods = this.serviceClass.methods();
        MethodSymbol remoteMethod = (MethodSymbol)serviceMethods.get(this.getRemoteMethodName());
        if (Objects.isNull(remoteMethod)) {
            return;
        }
        Optional optReturnType = remoteMethod.typeDescriptor().returnTypeDescriptor();
        optReturnType.ifPresent(this::setReturnType);
    }

    @Override
    public boolean isInvokable(TargetResource targetResource) {
        return true;
    }

    @Override
    public Interceptor.InterceptorType getType() {
        return Interceptor.InterceptorType.RESPONSE;
    }

    protected String getRemoteMethodName() {
        return "interceptResponse";
    }

    @Override
    public void setNextInReqPath(Interceptor nextInReqPath) {
        super.setNextInReqPath(null);
    }

    @Override
    protected FunctionDefinitionNode getFunctionDefinitionNode() {
        return this.serviceClassNode.members().stream().filter(node -> {
            FunctionDefinitionNode functionNode;
            return node instanceof FunctionDefinitionNode && (functionNode = (FunctionDefinitionNode)node).functionName().toString().equals(this.getRemoteMethodName());
        }).findFirst().orElse(null);
    }

    @Override
    public Iterable<ParameterNode> getParameterNodes() {
        return List.of();
    }

    @Override
    public boolean hasDataBinding() {
        return false;
    }
}

