/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.response.utils;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.Constants;
import io.ballerina.openapi.service.mapper.response.model.ResponseInfo;
import io.ballerina.openapi.service.mapper.response.utils.StatusCodeTypeUtils;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.swagger.v3.oas.models.headers.Header;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class StatusCodeErrorUtils
extends StatusCodeTypeUtils {
    private StatusCodeErrorUtils() {
    }

    public static boolean isSubTypeOfHttpStatusCodeError(TypeSymbol typeSymbol, SemanticModel semanticModel) {
        return StatusCodeErrorUtils.isSubTypeOfBallerinaModuleType("StatusCodeError", "http.httpscerr", typeSymbol, semanticModel);
    }

    public static ResponseInfo extractResponseInfo(TypeSymbol statusCodeErrorType, TypeMapper typeMapper, SemanticModel semanticModel) {
        String statusCode = StatusCodeErrorUtils.getResponseCode(statusCodeErrorType, semanticModel);
        Optional<RecordTypeSymbol> errorDetailRecordType = StatusCodeErrorUtils.getErrorDetailTypeSymbol(statusCodeErrorType, typeMapper);
        if (errorDetailRecordType.isEmpty()) {
            return new ResponseInfo(statusCode, semanticModel.types().ANYDATA, new HashMap<String, Header>());
        }
        TypeSymbol bodyType = StatusCodeErrorUtils.getBodyType(errorDetailRecordType.get(), semanticModel);
        Map<String, Header> headers = StatusCodeErrorUtils.getHeaders(errorDetailRecordType.get(), typeMapper);
        return new ResponseInfo(statusCode, bodyType, headers);
    }

    private static Optional<RecordTypeSymbol> getErrorDetailTypeSymbol(TypeSymbol typeSymbol, TypeMapper typeMapper) {
        TypeSymbol typeSymbol2;
        IntersectionTypeSymbol errorIntersectionType = typeMapper.getReferredIntersectionType(typeSymbol);
        if (Objects.isNull(errorIntersectionType) || !((typeSymbol2 = errorIntersectionType.effectiveTypeDescriptor()) instanceof ErrorTypeSymbol)) {
            return Optional.empty();
        }
        ErrorTypeSymbol errorTypeSymbol = (ErrorTypeSymbol)typeSymbol2;
        return StatusCodeErrorUtils.getRecordTypeSymbol(errorTypeSymbol.detailTypeDescriptor(), typeMapper);
    }

    private static String getResponseCode(TypeSymbol typeSymbol, SemanticModel semanticModel) {
        for (Map.Entry<String, String> entry : Constants.HTTP_STATUS_CODE_ERRORS.entrySet()) {
            if (!StatusCodeErrorUtils.isSubTypeOfBallerinaModuleType(entry.getKey(), "http.httpscerr", typeSymbol, semanticModel)) continue;
            return entry.getValue();
        }
        return "500";
    }
}

