/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.type;

import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.type.extension.BallerinaTypeExtensioner;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractTypeMapper {
    final String name;
    final TypeReferenceTypeSymbol typeSymbol;
    final String description;
    final AdditionalData additionalData;

    public AbstractTypeMapper(TypeReferenceTypeSymbol typeSymbol, AdditionalData additionalData) {
        this.name = MapperCommonUtils.getTypeName((TypeSymbol)typeSymbol);
        this.typeSymbol = typeSymbol;
        this.description = MapperCommonUtils.getTypeDescription(typeSymbol);
        this.additionalData = additionalData;
    }

    abstract Schema getReferenceSchema(Components var1);

    public void addToComponents(Components components) {
        Map schemas = components.getSchemas();
        if (schemas.containsKey(this.name) && Objects.nonNull(schemas.get(this.name))) {
            return;
        }
        Schema schema = this.getReferenceSchema(components);
        if (Objects.isNull(schema)) {
            return;
        }
        if (this.additionalData.enableBallerinaExt()) {
            BallerinaTypeExtensioner.addExtension(schema, (TypeSymbol)this.typeSymbol);
        }
        components.addSchemas(this.name, schema);
    }

    static boolean hasMapping(Components components, TypeSymbol typeSymbol) {
        Map schemas = components.getSchemas();
        return schemas.containsKey(MapperCommonUtils.getTypeName(typeSymbol));
    }

    static boolean hasFullMapping(Components components, TypeSymbol typeSymbol) {
        Map schemas = components.getSchemas();
        return schemas.containsKey(MapperCommonUtils.getTypeName(typeSymbol)) && Objects.nonNull(schemas.get(MapperCommonUtils.getTypeName(typeSymbol)));
    }
}

