/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.type;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.openapi.service.mapper.ServiceToOpenAPIMapper;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.model.ModuleMemberVisitor;
import io.ballerina.openapi.service.mapper.type.AbstractTypeMapper;
import io.ballerina.openapi.service.mapper.type.ArrayTypeMapper;
import io.ballerina.openapi.service.mapper.type.ErrorTypeMapper;
import io.ballerina.openapi.service.mapper.type.MapTypeMapper;
import io.ballerina.openapi.service.mapper.type.ReadOnlyTypeMapper;
import io.ballerina.openapi.service.mapper.type.RecordTypeMapper;
import io.ballerina.openapi.service.mapper.type.ReferenceTypeMapper;
import io.ballerina.openapi.service.mapper.type.SchemaResult;
import io.ballerina.openapi.service.mapper.type.SimpleTypeMapper;
import io.ballerina.openapi.service.mapper.type.TableTypeMapper;
import io.ballerina.openapi.service.mapper.type.TupleTypeMapper;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.ballerina.openapi.service.mapper.type.UnionTypeMapper;
import io.ballerina.openapi.service.mapper.type.extension.BallerinaTypeExtensioner;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.projects.Project;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.OpenAPISchema2JsonSchema;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TypeMapperImpl
implements TypeMapper {
    public static final String COMPONENTS_SCHEMAS = "#/components/schemas/";
    public static final String DEFINITIONS = "#/definitions/";
    public static final String DEFINITIONS_FIELD = "definitions";
    public static final String JSON_SCHEMA_FIELD = "$schema";
    public static final String JSON_SCHEMA_VERSION = "http://json-schema.org/draft-04/schema#";
    private final Components components;
    private final AdditionalData componentMapperData;
    private final OpenAPISchema2JsonSchema converter = new OpenAPISchema2JsonSchema();

    public TypeMapperImpl(Components components, AdditionalData componentMapperData) {
        this.components = components;
        this.componentMapperData = componentMapperData;
    }

    public TypeMapperImpl(SyntaxNodeAnalysisContext context) {
        this.components = new Components().schemas(new HashMap());
        SemanticModel semanticModel = context.semanticModel();
        Project project = context.currentPackage().project();
        ModuleMemberVisitor moduleMemberVisitor = ServiceToOpenAPIMapper.extractNodesFromProject(project, semanticModel);
        this.componentMapperData = new AdditionalData(semanticModel, moduleMemberVisitor);
    }

    @Override
    public Schema getSchema(TypeSymbol typeSymbol) throws UnsupportedOperationException {
        return this.getSchema(typeSymbol, true).schema();
    }

    @Override
    public SchemaResult getSchema(TypeSymbol typeSymbol, boolean enableExpansion) throws UnsupportedOperationException {
        if (!this.isAnydata(typeSymbol)) {
            throw new UnsupportedOperationException("Only 'anydata' type is supported for JSON schema generation.");
        }
        Components localComponents = new Components().schemas(new HashMap());
        AdditionalData additionalData = this.cloneComponentMapperData(enableExpansion);
        Schema schema = TypeMapperImpl.getTypeSchema(typeSymbol, localComponents, additionalData);
        if (additionalData.enableExpansion() && additionalData.diagnostics().stream().anyMatch(diagnostic -> diagnostic.getCode().equals("OAS_CONVERTOR_140"))) {
            throw new UnsupportedOperationException("Recursive references are not supported for JSON schema generation with reference expansion.");
        }
        BallerinaTypeExtensioner.removeExtensionFromSchema(schema);
        return new SchemaResult(schema, localComponents);
    }

    @Override
    public String getJsonSchemaString(TypeSymbol typeSymbol) throws UnsupportedOperationException {
        return this.getJsonSchemaString(typeSymbol, false);
    }

    @Override
    public String getJsonSchemaString(TypeSymbol typeSymbol, boolean enableExpansion) throws UnsupportedOperationException {
        SchemaResult result = this.getSchema(typeSymbol, enableExpansion);
        this.converter.process(result.schema());
        Map jsonSchema = result.schema().getJsonSchema();
        jsonSchema.put(JSON_SCHEMA_FIELD, JSON_SCHEMA_VERSION);
        if (this.componentMapperData.enableExpansion()) {
            return TypeMapperImpl.getJsonString(jsonSchema);
        }
        this.populateDefinitions(result.components(), jsonSchema);
        return TypeMapperImpl.getJsonString(jsonSchema);
    }

    private void populateDefinitions(Components components, Map<String, Object> jsonSchema) {
        HashMap definitions = new HashMap();
        Map schemas = components.getSchemas();
        BallerinaTypeExtensioner.removeExtensionFromComponents(components);
        if (Objects.nonNull(schemas)) {
            schemas.forEach((key, value) -> {
                if (Objects.nonNull(value)) {
                    this.converter.process(value);
                    definitions.put(key, value.getJsonSchema());
                }
            });
        }
        if (!definitions.isEmpty()) {
            jsonSchema.put(DEFINITIONS_FIELD, definitions);
        }
    }

    private static String getJsonString(Map<String, Object> jsonSchema) {
        String jsonSchemaString = Json.pretty(jsonSchema);
        return jsonSchemaString.replace(COMPONENTS_SCHEMAS, DEFINITIONS);
    }

    private AdditionalData cloneComponentMapperData(boolean enableExpansion) {
        return new AdditionalData(this.componentMapperData.semanticModel(), this.componentMapperData.moduleMemberVisitor(), new ArrayList<OpenAPIMapperDiagnostic>(), false, enableExpansion);
    }

    private boolean isAnydata(TypeSymbol typeSymbol) {
        return typeSymbol.subtypeOf(this.componentMapperData.semanticModel().types().ANYDATA);
    }

    @Override
    public Schema getTypeSchema(TypeSymbol typeSymbol) {
        return TypeMapperImpl.getTypeSchema(typeSymbol, this.components, this.componentMapperData, false);
    }

    public static Schema getTypeSchema(TypeSymbol typeSymbol, Components components, AdditionalData componentMapperData) {
        return TypeMapperImpl.getTypeSchema(typeSymbol, components, componentMapperData, false);
    }

    public static Schema getTypeSchema(TypeSymbol typeSymbol, Components components, AdditionalData componentMapperData, boolean skipNilType) {
        Schema schema;
        String typeName;
        String string = typeName = typeSymbol.typeKind().equals((Object)TypeDescKind.TYPE_REFERENCE) ? MapperCommonUtils.getTypeName(typeSymbol) : "";
        if (componentMapperData.enableExpansion()) {
            TypeSymbol referredType;
            if (componentMapperData.visitedTypes().contains(MapperCommonUtils.getTypeName(typeSymbol))) {
                ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_140, new String[0]);
                componentMapperData.diagnostics().add(error);
                return null;
            }
            if (!typeName.isEmpty()) {
                componentMapperData.visitedTypes().add(typeName);
            }
            if (Objects.nonNull(referredType = ReferenceTypeMapper.getReferredType(typeSymbol))) {
                typeSymbol = referredType;
            }
        }
        switch (typeSymbol.typeKind()) {
            case MAP: {
                Schema schema2 = MapTypeMapper.getSchema((MapTypeSymbol)typeSymbol, components, componentMapperData);
                break;
            }
            case ARRAY: {
                Schema schema2 = ArrayTypeMapper.getSchema((ArrayTypeSymbol)typeSymbol, components, componentMapperData);
                break;
            }
            case TYPE_REFERENCE: {
                Schema schema2 = ReferenceTypeMapper.getSchema((TypeReferenceTypeSymbol)typeSymbol, components, componentMapperData);
                break;
            }
            case RECORD: {
                Schema schema2 = RecordTypeMapper.getSchema((RecordTypeSymbol)typeSymbol, components, null, componentMapperData);
                break;
            }
            case INTERSECTION: {
                Schema schema2 = ReadOnlyTypeMapper.getSchema((IntersectionTypeSymbol)typeSymbol, components, componentMapperData);
                break;
            }
            case UNION: {
                Schema schema2 = UnionTypeMapper.getSchema((UnionTypeSymbol)typeSymbol, components, componentMapperData, skipNilType);
                break;
            }
            case TABLE: {
                Schema schema2 = TableTypeMapper.getSchema((TableTypeSymbol)typeSymbol, components, componentMapperData);
                break;
            }
            case TUPLE: {
                Schema schema2 = TupleTypeMapper.getSchema((TupleTypeSymbol)typeSymbol, components, componentMapperData);
                break;
            }
            case ERROR: {
                Schema schema2 = ErrorTypeMapper.getSchema((ErrorTypeSymbol)typeSymbol, components, componentMapperData);
                break;
            }
            default: {
                Schema schema2 = schema = SimpleTypeMapper.getTypeSchema(typeSymbol, componentMapperData);
            }
        }
        if (componentMapperData.enableExpansion() && !typeName.isEmpty()) {
            componentMapperData.visitedTypes().remove(typeName);
        }
        return schema;
    }

    protected static void createComponentMapping(TypeReferenceTypeSymbol typeSymbol, Components components, AdditionalData componentMapperData) {
        Map schemas = components.getSchemas();
        if (schemas.containsKey(MapperCommonUtils.getTypeName((TypeSymbol)typeSymbol))) {
            return;
        }
        TypeSymbol referredType = typeSymbol.typeDescriptor();
        AbstractTypeMapper mapper = switch (referredType.typeKind()) {
            case TypeDescKind.TYPE_REFERENCE -> new ReferenceTypeMapper(typeSymbol, componentMapperData);
            case TypeDescKind.MAP -> new MapTypeMapper(typeSymbol, componentMapperData);
            case TypeDescKind.RECORD -> new RecordTypeMapper(typeSymbol, componentMapperData);
            case TypeDescKind.INTERSECTION -> new ReadOnlyTypeMapper(typeSymbol, componentMapperData);
            case TypeDescKind.ARRAY -> new ArrayTypeMapper(typeSymbol, componentMapperData);
            case TypeDescKind.UNION -> new UnionTypeMapper(typeSymbol, componentMapperData);
            case TypeDescKind.TABLE -> new TableTypeMapper(typeSymbol, componentMapperData);
            case TypeDescKind.TUPLE -> new TupleTypeMapper(typeSymbol, componentMapperData);
            case TypeDescKind.ERROR -> new ErrorTypeMapper(typeSymbol, componentMapperData);
            default -> new SimpleTypeMapper(typeSymbol, componentMapperData);
        };
        components.addSchemas(MapperCommonUtils.getTypeName((TypeSymbol)typeSymbol), null);
        mapper.addToComponents(components);
    }

    @Override
    public Map<String, Schema> getSchemaForRecordFields(Map<String, RecordFieldSymbol> recordFieldMap, Set<String> requiredFields, String recordName, boolean treatNilableAsOptional) {
        RecordTypeMapper.RecordFieldMappingContext context = new RecordTypeMapper.RecordFieldMappingContext(recordFieldMap, this.components, requiredFields, recordName, treatNilableAsOptional, false, this.componentMapperData, new HashSet<String>());
        return RecordTypeMapper.mapRecordFields(context);
    }

    @Override
    public TypeSymbol getReferredType(TypeSymbol typeSymbol) {
        return ReferenceTypeMapper.getReferredType(typeSymbol);
    }

    @Override
    public IntersectionTypeSymbol getReferredIntersectionType(TypeSymbol typeSymbol) {
        return ReferenceTypeMapper.getReferredIntersectionType(typeSymbol);
    }
}

