/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.map;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.utils.MapUtils;
import java.util.Collection;
import org.ballerinalang.langlib.map.util.MapLibUtils;

public final class ToArray {
    private ToArray() {
    }

    public static BArray toArray(BMap<?, ?> m) {
        Type mapType = TypeUtils.getImpliedType((Type)m.getType());
        Type arrElemType = switch (mapType.getTag()) {
            case 27 -> ((MapType)mapType).getConstrainedType();
            case 24 -> MapLibUtils.getCommonTypeForRecordField((RecordType)mapType);
            default -> throw MapUtils.createOpNotSupportedError((Type)mapType, (String)"toArray()");
        };
        Collection values = m.values();
        int size = values.size();
        int i = 0;
        switch (TypeUtils.getImpliedType((Type)arrElemType).getTag()) {
            case 1: {
                long[] intArr = new long[size];
                for (Object val : values) {
                    intArr[i++] = (Long)val;
                }
                return ValueCreator.createArrayValue((long[])intArr);
            }
            case 3: {
                double[] floatArr = new double[size];
                for (Object val : values) {
                    floatArr[i++] = (Double)val;
                }
                return ValueCreator.createArrayValue((double[])floatArr);
            }
            case 2: {
                byte[] byteArr = new byte[size];
                for (Object val : values) {
                    byteArr[i++] = ((Integer)val).byteValue();
                }
                return ValueCreator.createArrayValue((byte[])byteArr);
            }
            case 6: {
                boolean[] booleanArr = new boolean[size];
                for (Object val : values) {
                    booleanArr[i++] = (Boolean)val;
                }
                return ValueCreator.createArrayValue((boolean[])booleanArr);
            }
            case 5: {
                BString[] stringArr = new BString[size];
                for (Object val : values) {
                    stringArr[i++] = (BString)val;
                }
                return ValueCreator.createArrayValue((BString[])stringArr);
            }
        }
        return ValueCreator.createArrayValue((Object[])values.toArray(), (ArrayType)TypeCreator.createArrayType((Type)arrElemType));
    }
}

