/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.email.util;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.email.util.CommonUtil;
import io.ballerina.stdlib.email.util.EmailConstants;
import io.ballerina.stdlib.email.util.ExcludeCoverageFromGeneratedReport;
import io.ballerina.stdlib.io.channels.base.Channel;
import io.ballerina.stdlib.mime.nativeimpl.MimeDataSourceBuilder;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import io.ballerina.stdlib.mime.util.EntityHeaderHandler;
import io.ballerina.stdlib.mime.util.MimeUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmtpUtil {
    private static final Logger log = LoggerFactory.getLogger(SmtpUtil.class);

    private SmtpUtil() {
    }

    public static Properties getProperties(BMap<BString, Object> smtpConfig, String host) throws IOException, GeneralSecurityException {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", host);
        properties.put("mail.smtp.port", Long.toString(smtpConfig.getIntValue(EmailConstants.PROPS_PORT)));
        properties.put("mail.smtp.auth", "true");
        BString security = smtpConfig.getStringValue(EmailConstants.PROPS_SECURITY);
        if (security != null) {
            String securityType;
            switch (securityType = security.getValue()) {
                case "START_TLS_AUTO": {
                    properties.put("mail.smtp.starttls.enable", "true");
                    properties.put("mail.smtp.ssl.enable", "false");
                    break;
                }
                case "START_TLS_ALWAYS": {
                    properties.put("mail.smtp.starttls.enable", "true");
                    properties.put("mail.smtp.starttls.required", "true");
                    properties.put("mail.smtp.ssl.enable", "false");
                    SmtpUtil.addBasicTransportSecurityProperties(CommonUtil.createDefaultSSLSocketFactory(), properties);
                    break;
                }
                case "START_TLS_NEVER": {
                    properties.put("mail.smtp.starttls.enable", "false");
                    properties.put("mail.smtp.ssl.enable", "false");
                    break;
                }
                default: {
                    SmtpUtil.addBasicTransportSecurityProperties(CommonUtil.createDefaultSSLSocketFactory(), properties);
                    break;
                }
            }
        } else {
            SmtpUtil.addBasicTransportSecurityProperties(CommonUtil.createDefaultSSLSocketFactory(), properties);
        }
        SmtpUtil.addCertificate((BMap<BString, Object>)smtpConfig.getMapValue(EmailConstants.PROPS_SECURE_SOCKET), properties);
        SmtpUtil.printDebugLogs(properties);
        return properties;
    }

    public static MimeMessage generateMessage(Session session, String username, BMap<BString, Object> message) throws MessagingException, IOException {
        Object attachments;
        Address[] toAddressArray = SmtpUtil.extractAddressLists(message, EmailConstants.MESSAGE_TO);
        Address[] ccAddressArray = SmtpUtil.extractAddressLists(message, EmailConstants.MESSAGE_CC);
        Address[] bccAddressArray = SmtpUtil.extractAddressLists(message, EmailConstants.MESSAGE_BCC);
        Address[] replyToAddressArray = SmtpUtil.extractAddressLists(message, EmailConstants.MESSAGE_REPLY_TO);
        String subject = message.getStringValue(EmailConstants.MESSAGE_SUBJECT).getValue();
        String messageBody = SmtpUtil.getNullCheckedString(message.getStringValue(EmailConstants.MESSAGE_MESSAGE_BODY));
        String htmlMessageBody = SmtpUtil.getNullCheckedString(message.getStringValue(EmailConstants.MESSAGE_HTML_MESSAGE_BODY));
        String bodyContentType = SmtpUtil.getNullCheckedString(message.getStringValue(EmailConstants.MESSAGE_BODY_CONTENT_TYPE));
        String fromAddress = SmtpUtil.getNullCheckedString(message.getStringValue(EmailConstants.MESSAGE_FROM));
        if (fromAddress == null || fromAddress.isEmpty()) {
            fromAddress = username;
        }
        String senderAddress = SmtpUtil.getNullCheckedString(message.getStringValue(EmailConstants.MESSAGE_SENDER));
        MimeMessage emailMessage = new MimeMessage(session);
        emailMessage.setRecipients(Message.RecipientType.TO, toAddressArray);
        if (ccAddressArray.length > 0) {
            emailMessage.setRecipients(Message.RecipientType.CC, ccAddressArray);
        }
        if (bccAddressArray.length > 0) {
            emailMessage.setRecipients(Message.RecipientType.BCC, bccAddressArray);
        }
        if (replyToAddressArray.length > 0) {
            emailMessage.setReplyTo(replyToAddressArray);
        }
        emailMessage.setSubject(subject);
        emailMessage.setFrom((Address)new InternetAddress(fromAddress));
        if (!senderAddress.isEmpty()) {
            emailMessage.setSender((Address)new InternetAddress(senderAddress));
        }
        if (Objects.isNull(attachments = message.get((Object)EmailConstants.MESSAGE_ATTACHMENTS))) {
            boolean hasTextBody = !messageBody.isEmpty();
            boolean hasHtmlBody = !htmlMessageBody.isEmpty();
            String contentType = SmtpUtil.retrieveContentType(bodyContentType, hasTextBody, hasHtmlBody);
            if (hasTextBody && !hasHtmlBody) {
                emailMessage.setContent((Object)messageBody, contentType);
            } else if (hasHtmlBody && !hasTextBody) {
                emailMessage.setContent((Object)htmlMessageBody, contentType);
            } else if (hasTextBody) {
                emailMessage.setContent((Multipart)SmtpUtil.getAlternativeContentFromTextAndHtml(messageBody, htmlMessageBody));
            } else {
                emailMessage.setContent((Object)"\r\n", "text/plain");
            }
        } else {
            SmtpUtil.addBodyAndAttachments(emailMessage, messageBody, htmlMessageBody, attachments);
        }
        SmtpUtil.addMessageHeaders(emailMessage, message);
        return emailMessage;
    }

    private static String retrieveContentType(String providedContentType, boolean hasTextBody, boolean hasHtmlBody) {
        if (Objects.nonNull(providedContentType) && !providedContentType.isBlank()) {
            return providedContentType;
        }
        return hasTextBody && !hasHtmlBody ? "text/plain" : (hasHtmlBody && !hasTextBody ? "text/html" : "text/plain");
    }

    protected static void addCertificate(BMap<BString, Object> secureSocket, Properties properties) throws IOException, GeneralSecurityException {
        if (secureSocket != null) {
            BArray ciphers;
            String protocolName = null;
            CharSequence[] protocolVersions = null;
            CharSequence[] supportedCiphers = null;
            BMap protocol = secureSocket.getMapValue(EmailConstants.PROPS_CERT_PROTOCOL);
            if (protocol != null) {
                protocolName = protocol.getStringValue(EmailConstants.PROPS_CERT_PROTOCOL_NAME).getValue();
                BArray versions = protocol.getArrayValue(EmailConstants.PROPS_CERT_PROTOCOL_VERSIONS);
                if (versions != null) {
                    protocolVersions = versions.getStringArray();
                }
            }
            if ((ciphers = secureSocket.getArrayValue(EmailConstants.PROPS_CERT_CIPHERS)) != null) {
                supportedCiphers = ciphers.getStringArray();
            }
            String certificatePath = secureSocket.getStringValue(EmailConstants.PROPS_CERTIFICATE).getValue();
            SSLSocketFactory sslSocketFactory = CommonUtil.createSSLSocketFactory(new File(certificatePath), protocolName);
            SmtpUtil.addBasicTransportSecurityProperties(sslSocketFactory, properties);
            if (protocolVersions != null) {
                properties.put("mail.smtp.ssl.protocols", String.join((CharSequence)" ", protocolVersions));
            }
            if (supportedCiphers != null) {
                properties.put("mail.smtp.ssl.ciphersuites", String.join((CharSequence)" ", supportedCiphers));
            }
            if (secureSocket.containsKey((Object)EmailConstants.PROPS_VERIFY_HOSTNAME)) {
                Boolean verifyHostname = secureSocket.getBooleanValue(EmailConstants.PROPS_VERIFY_HOSTNAME);
                if (verifyHostname.booleanValue()) {
                    properties.put("mail.smtp.ssl.checkserveridentity", "true");
                } else {
                    properties.put("mail.smtp.ssl.checkserveridentity", "false");
                }
            }
        }
    }

    private static void addBasicTransportSecurityProperties(SSLSocketFactory sslSocketFactory, Properties properties) {
        properties.put("mail.smtp.ssl.socketFactory", sslSocketFactory);
        properties.put("mail.smtp.ssl.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        properties.put("mail.smtp.socketFactory.fallback", "false");
        properties.put("mail.smtp.ssl.checkserveridentity", "true");
        properties.put("mail.smtp.ssl.enable", "true");
        properties.put("mail.smtp.starttls.enable", "true");
    }

    private static void addMessageHeaders(MimeMessage emailMessage, BMap<BString, Object> message) throws MessagingException {
        BMap headers = message.getMapValue(EmailConstants.MESSAGE_HEADERS);
        if (headers != null) {
            BString[] headerNames;
            for (BString headerName : headerNames = (BString[])headers.getKeys()) {
                emailMessage.addHeader(headerName.getValue(), headers.getStringValue(headerName).getValue());
            }
        }
    }

    private static void addBodyAndAttachments(MimeMessage emailMessage, String messageBody, String htmlMessageBody, Object attachments) throws MessagingException, IOException {
        MimeMultipart multipart = new MimeMultipart("mixed");
        SmtpUtil.addMultipartChild((Multipart)multipart, SmtpUtil.getAlternativeContentFromTextAndHtml(messageBody, htmlMessageBody));
        if (attachments instanceof BArray) {
            BArray attachmentArray = (BArray)attachments;
            for (int i = 0; i < attachmentArray.size(); ++i) {
                Object attachedEntityOrRecord = attachmentArray.get((long)i);
                SmtpUtil.addAttachment(attachedEntityOrRecord, (Multipart)multipart);
            }
        } else {
            SmtpUtil.addAttachment(attachments, (Multipart)multipart);
        }
        emailMessage.setContent((Multipart)multipart);
    }

    private static void addMultipartChild(Multipart parent, MimeMultipart child) throws MessagingException {
        MimeBodyPart mbp = new MimeBodyPart();
        parent.addBodyPart((BodyPart)mbp);
        mbp.setContent((Multipart)child);
    }

    private static void addAttachment(Object attachedEntityOrRecord, Multipart multipart) throws IOException, MessagingException {
        if (attachedEntityOrRecord instanceof BObject) {
            BObject mimeEntity = (BObject)attachedEntityOrRecord;
            String contentType = MimeUtil.getContentTypeWithParameters((BObject)mimeEntity);
            if (contentType.startsWith("multipart/")) {
                multipart.addBodyPart((BodyPart)SmtpUtil.populateMultipart(mimeEntity));
            } else {
                multipart.addBodyPart((BodyPart)SmtpUtil.buildJavaMailBodyPart(mimeEntity, contentType));
            }
        } else if (attachedEntityOrRecord instanceof BMap) {
            BMap attachedEntity = (BMap)attachedEntityOrRecord;
            String attachmentFilePath = attachedEntity.getStringValue(EmailConstants.ATTACHMENT_FILE_PATH).getValue();
            String attachmentContentType = attachedEntity.getStringValue(EmailConstants.ATTACHMENT_CONTENT_TYPE).getValue();
            File file = new File(attachmentFilePath);
            BObject mimeEntity = ValueCreator.createObjectValue((Module)MimeUtil.getMimePackage(), (String)"Entity", (Object[])new Object[0]);
            MimeUtil.setContentType((BObject)ValueCreator.createObjectValue((Module)MimeUtil.getMimePackage(), (String)"MediaType", (Object[])new Object[0]), (BObject)mimeEntity, (String)"text/plain");
            if (attachmentContentType.startsWith("multipart/")) {
                multipart.addBodyPart((BodyPart)SmtpUtil.populateMultipart(mimeEntity));
            } else {
                multipart.addBodyPart((BodyPart)SmtpUtil.buildJavaMailBodyPart(file));
            }
        }
    }

    private static MimeBodyPart populateMultipart(BObject mimeEntity) throws IOException, MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        BArray multipartMimeEntityArrayValue = EntityBodyHandler.getBodyPartArray((BObject)mimeEntity);
        int entityCount = multipartMimeEntityArrayValue.size();
        for (int i = 0; i < entityCount; ++i) {
            BObject childMimeEntity = (BObject)multipartMimeEntityArrayValue.get((long)i);
            String childContentType = MimeUtil.getContentTypeWithParameters((BObject)childMimeEntity);
            if (childContentType.startsWith("multipart/")) {
                multipart.addBodyPart((BodyPart)SmtpUtil.populateMultipart(childMimeEntity));
                continue;
            }
            multipart.addBodyPart((BodyPart)SmtpUtil.buildJavaMailBodyPart(childMimeEntity, childContentType));
        }
        MimeBodyPart returnMimeBodyPart = new MimeBodyPart();
        returnMimeBodyPart.setContent((Multipart)multipart);
        return returnMimeBodyPart;
    }

    private static MimeBodyPart buildJavaMailBodyPart(BObject mimeEntity, String contentType) throws MessagingException, IOException {
        MimeBodyPart attachmentBodyPart = new MimeBodyPart();
        Channel channel = EntityBodyHandler.getByteChannel((BObject)mimeEntity);
        if (channel != null) {
            InputStream inputStream = channel.getInputStream();
            ByteArrayDataSource ds = new ByteArrayDataSource(inputStream, contentType);
            attachmentBodyPart.setDataHandler(new DataHandler((DataSource)ds));
        } else if (CommonUtil.isTextBased(contentType)) {
            attachmentBodyPart.setText(((BString)MimeDataSourceBuilder.getText((BObject)mimeEntity)).getValue());
        } else {
            BArray binaryContent = (BArray)MimeDataSourceBuilder.getByteArray((BObject)mimeEntity);
            attachmentBodyPart.setContent((Object)binaryContent.getBytes(), "application/octet-stream");
        }
        SmtpUtil.addHeadersToJavaMailBodyPart(mimeEntity, attachmentBodyPart);
        return attachmentBodyPart;
    }

    private static MimeBodyPart buildJavaMailBodyPart(File file) throws MessagingException, IOException {
        MimeBodyPart attachmentBodyPart = new MimeBodyPart();
        if (file != null) {
            attachmentBodyPart.attachFile(file);
        }
        return attachmentBodyPart;
    }

    private static void addHeadersToJavaMailBodyPart(BObject mimeEntity, MimeBodyPart attachmentBodyPart) throws MessagingException {
        BMap entityHeaders = EntityHeaderHandler.getEntityHeaderMap((BObject)mimeEntity);
        for (BString entryKey : (BString[])entityHeaders.getKeys()) {
            BArray entryValues = (BArray)entityHeaders.get((Object)entryKey);
            if (entryValues.size() <= 0) continue;
            String headerName = entryKey.getValue();
            String headerValue = entryValues.getBString(0L).getValue();
            if (!SmtpUtil.isNotEmpty(headerName)) continue;
            log.debug("Added a MIME body part header " + headerName + " with value " + headerValue);
            attachmentBodyPart.setHeader(headerName, headerValue);
        }
    }

    private static Address[] extractAddressLists(BMap<BString, Object> message, BString addressType) throws AddressException {
        String[] address = SmtpUtil.getNullCheckedStringArray(message, addressType);
        int addressArrayLength = address.length;
        Address[] addressArray = new Address[addressArrayLength];
        for (int i = 0; i < addressArrayLength; ++i) {
            addressArray[i] = new InternetAddress(address[i]);
        }
        return addressArray;
    }

    private static String[] getNullCheckedStringArray(BMap<BString, Object> mapValue, BString parameter) {
        if (mapValue != null) {
            Object parameterValue = mapValue.get((Object)parameter);
            if (parameterValue != null) {
                if (parameterValue instanceof BArray) {
                    return ((BArray)parameterValue).getStringArray();
                }
                if (parameterValue instanceof BString) {
                    return new String[]{((BString)parameterValue).getValue()};
                }
                return new String[0];
            }
            return new String[0];
        }
        return new String[0];
    }

    private static MimeMultipart getAlternativeContentFromTextAndHtml(String textContent, String htmlContent) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart("alternative");
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(textContent);
        multipart.addBodyPart((BodyPart)messageBodyPart);
        messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)htmlContent, "text/html");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        return multipart;
    }

    private static String getNullCheckedString(BString string) {
        return string == null ? "" : string.getValue();
    }

    private static boolean isNotEmpty(String string) {
        return string != null && !string.isEmpty();
    }

    @ExcludeCoverageFromGeneratedReport
    private static void printDebugLogs(Properties properties) {
        if (log.isDebugEnabled()) {
            Set<String> propertySet = properties.stringPropertyNames();
            log.debug("SMTP Properties set are as follows.");
            for (String propertyObj : propertySet) {
                log.debug("Property Name: " + String.valueOf(propertyObj) + ", Value: " + properties.get(propertyObj).toString() + " ValueType: " + properties.get(propertyObj).getClass().getName());
            }
        }
    }
}

