/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mqtt.client;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.mqtt.client.ClientThreadFactory;
import io.ballerina.stdlib.mqtt.client.MqttClientCallbackImpl;
import io.ballerina.stdlib.mqtt.utils.ModuleUtils;
import io.ballerina.stdlib.mqtt.utils.MqttConstants;
import io.ballerina.stdlib.mqtt.utils.MqttUtils;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.persist.MemoryPersistence;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.MqttSubscription;

public final class ClientActions {
    private static final ExecutorService publishExecutorService = Executors.newCachedThreadPool(new ClientThreadFactory());

    private ClientActions() {
    }

    public static Object externInit(BObject clientObject, BString serverUri, BString clientId, BMap<BString, Object> clientConfiguration) {
        try {
            MqttClient publisher = new MqttClient(serverUri.getValue(), clientId.getValue(), (MqttClientPersistence)new MemoryPersistence());
            MqttConnectionOptions options = MqttUtils.getMqttConnectOptions(clientConfiguration);
            ClientActions.setWillMessage(clientConfiguration, options);
            publisher.connect(options);
            LinkedBlockingQueue blockingQueue = new LinkedBlockingQueue();
            LinkedBlockingQueue deliveryTokenQueue = new LinkedBlockingQueue();
            clientObject.addNativeData("responseQueue", blockingQueue);
            clientObject.addNativeData("deliveryTokenQueue", deliveryTokenQueue);
            clientObject.addNativeData("mqttClient", (Object)publisher);
            clientObject.addNativeData("clientExecutorServices", new ArrayList());
            publisher.setCallback((MqttCallback)new MqttClientCallbackImpl(blockingQueue, deliveryTokenQueue));
        }
        catch (BError e) {
            return e;
        }
        catch (Exception e) {
            return MqttUtils.createMqttError(e);
        }
        return null;
    }

    public static Object externSubscribe(BObject clientObject, BArray subscriptions) {
        MqttClient publisher = (MqttClient)clientObject.getNativeData("mqttClient");
        MqttSubscription[] mqttSubscriptions = new MqttSubscription[subscriptions.size()];
        for (int i = 0; i < subscriptions.size(); ++i) {
            BMap topicSubscription = (BMap)subscriptions.getValues()[i];
            mqttSubscriptions[i] = new MqttSubscription(topicSubscription.getStringValue(MqttConstants.TOPIC).getValue(), topicSubscription.getIntValue(MqttConstants.BQOS).intValue());
        }
        try {
            publisher.subscribe(mqttSubscriptions);
        }
        catch (MqttException e) {
            return MqttUtils.createMqttError((Exception)((Object)e));
        }
        return null;
    }

    public static Object externPublish(Environment env, BObject clientObject, BString topic, BMap message) {
        MqttClient publisher = (MqttClient)clientObject.getNativeData("mqttClient");
        MqttMessage mqttMessage = MqttUtils.generateMqttMessage(message);
        return env.yieldAndRun(() -> {
            try {
                publisher.publish(topic.getValue(), mqttMessage);
                LinkedBlockingQueue deliveryTokenQueue = (LinkedBlockingQueue)clientObject.getNativeData("deliveryTokenQueue");
                return deliveryTokenQueue.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return MqttUtils.createMqttError(e);
            }
            catch (MqttException e) {
                return MqttUtils.createMqttError((Exception)((Object)e));
            }
        });
    }

    public static Object externReceive(BObject clientObject, BTypedesc bTypedesc) {
        LinkedBlockingQueue blockingQueue = (LinkedBlockingQueue)clientObject.getNativeData("responseQueue");
        ExecutorService responseExecutorService = Executors.newCachedThreadPool(new ClientThreadFactory());
        BObject streamIterator = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"StreamIterator", (Object[])new Object[0]);
        streamIterator.addNativeData("responseQueue", (Object)blockingQueue);
        streamIterator.addNativeData("responseExecutorService", (Object)responseExecutorService);
        ((ArrayList)clientObject.getNativeData("clientExecutorServices")).add(responseExecutorService);
        StreamType streamType = (StreamType)bTypedesc.getDescribingType();
        BStream bStream = ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)streamType.getConstrainedType(), (Type)streamType.getCompletionType()), (BObject)streamIterator);
        return bStream;
    }

    public static Object externClose(BObject clientObject) {
        MqttClient publisher = (MqttClient)clientObject.getNativeData("mqttClient");
        ((ArrayList)clientObject.getNativeData("clientExecutorServices")).forEach(ExecutorService::shutdown);
        try {
            publisher.close();
        }
        catch (MqttException e) {
            return MqttUtils.createMqttError((Exception)((Object)e));
        }
        return null;
    }

    public static Object externIsConnected(BObject clientObject) {
        MqttClient publisher = (MqttClient)clientObject.getNativeData("mqttClient");
        return publisher.isConnected();
    }

    public static Object externDisconnect(BObject clientObject) {
        MqttClient publisher = (MqttClient)clientObject.getNativeData("mqttClient");
        try {
            publisher.disconnect();
        }
        catch (MqttException e) {
            return MqttUtils.createMqttError((Exception)((Object)e));
        }
        return null;
    }

    public static Object externReconnect(BObject clientObject) {
        MqttClient publisher = (MqttClient)clientObject.getNativeData("mqttClient");
        try {
            publisher.reconnect();
        }
        catch (MqttException e) {
            return MqttUtils.createMqttError((Exception)((Object)e));
        }
        return null;
    }

    public static Object nextResult(Environment env, BObject streamIterator) {
        BlockingQueue messageQueue = (BlockingQueue)streamIterator.getNativeData("responseQueue");
        return env.yieldAndRun(() -> {
            try {
                BMap message = (BMap)messageQueue.take();
                return message;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return MqttUtils.createMqttError(e);
            }
        });
    }

    public static void closeStream(BObject streamIterator) {
        BlockingQueue messageQueue = (BlockingQueue)streamIterator.getNativeData("responseQueue");
        ExecutorService executor = (ExecutorService)streamIterator.getNativeData("responseExecutorService");
        messageQueue.clear();
        executor.shutdown();
        streamIterator.addNativeData("responseQueue", null);
    }

    private static void setWillMessage(BMap<BString, Object> clientConfiguration, MqttConnectionOptions options) {
        if (clientConfiguration.containsKey((Object)MqttConstants.WILL_DETAILS)) {
            BMap willDetails = (BMap)clientConfiguration.get((Object)MqttConstants.WILL_DETAILS);
            String destinationTopic = willDetails.getStringValue(MqttConstants.DESTINATION_TOPIC).getValue();
            MqttMessage willMessage = MqttUtils.generateMqttMessage(willDetails.getMapValue(MqttConstants.WILL_MESSAGE));
            options.setWill(destinationTopic, willMessage);
        }
    }
}

