/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.mqtt.listener;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.RemoteMethodType;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.mqtt.utils.ModuleUtils;
import io.ballerina.stdlib.mqtt.utils.MqttConstants;
import io.ballerina.stdlib.mqtt.utils.MqttUtils;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttDisconnectResponse;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;

public class MqttListenerCallbackImpl
implements MqttCallback {
    private final Runtime runtime;
    private final BObject service;
    private final MqttClient subscriber;

    public MqttListenerCallbackImpl(Environment environment, BObject service, MqttClient subscriber) {
        this.runtime = environment.getRuntime();
        this.service = service;
        this.subscriber = subscriber;
    }

    public void disconnected(MqttDisconnectResponse disconnectResponse) {
        BError mqttError = MqttUtils.createMqttError((Exception)((Object)disconnectResponse.getException()));
        this.invokeOnError(mqttError);
    }

    public void mqttErrorOccurred(MqttException exception) {
        BError mqttError = MqttUtils.createMqttError((Exception)((Object)exception));
        this.invokeOnError(mqttError);
    }

    public void messageArrived(String topic, MqttMessage message) {
        this.invokeOnMessage(message, topic);
    }

    public void connectComplete(boolean reconnect, String serverURI) {
    }

    public void authPacketArrived(int reasonCode, MqttProperties properties) {
    }

    public void deliveryComplete(IMqttToken token) {
        this.invokeOnComplete(token);
    }

    private void invokeOnMessage(MqttMessage message, String topic) {
        BMap<BString, Object> bMqttMessage = MqttUtils.getBMqttMessage(message, topic);
        boolean callerExists = this.isCallerAvailable();
        if (!this.isMethodImplemented("onMessage")) {
            this.invokeOnError(MqttUtils.createMqttError(new NoSuchMethodException("method onMessage not found")));
            return;
        }
        if (callerExists) {
            BObject callerObject = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"Caller", (Object[])new Object[0]);
            callerObject.addNativeData("subscriber", (Object)this.subscriber);
            callerObject.addNativeData("messageId", (Object)message.getId());
            callerObject.addNativeData("qos", (Object)message.getQos());
            if (Objects.nonNull(message.getProperties().getResponseTopic())) {
                callerObject.addNativeData(MqttConstants.RESPONSE_TOPIC.getValue(), (Object)message.getProperties().getResponseTopic());
            }
            if (Objects.nonNull(message.getProperties().getCorrelationData())) {
                callerObject.addNativeData("correlationData", (Object)message.getProperties().getCorrelationData());
            }
            try {
                Object result = this.runtime.callMethod(this.service, "onMessage", null, new Object[]{bMqttMessage, callerObject});
                if (result instanceof BError) {
                    BError error = (BError)((Object)result);
                    error.printStackTrace();
                }
            }
            catch (BError bError) {
                bError.printStackTrace();
            }
        } else {
            try {
                Object result = this.runtime.callMethod(this.service, "onMessage", null, new Object[]{bMqttMessage});
                if (result instanceof BError) {
                    BError error = (BError)((Object)result);
                    error.printStackTrace();
                }
            }
            catch (BError bError) {
                bError.printStackTrace();
            }
        }
    }

    private void invokeOnError(BError bError) {
        if (!this.isMethodImplemented("onError")) {
            bError.printStackTrace();
            return;
        }
        try {
            Object result = this.runtime.callMethod(this.service, "onError", null, new Object[]{bError});
            if (result instanceof BError) {
                BError error = (BError)((Object)result);
                error.printStackTrace();
            }
        }
        catch (BError error) {
            bError.printStackTrace();
        }
    }

    private void invokeOnComplete(IMqttToken token) {
        if (!this.isMethodImplemented("onComplete")) {
            return;
        }
        BMap<BString, Object> bMqttToken = MqttUtils.getMqttDeliveryToken(token);
        try {
            Object result = this.runtime.callMethod(this.service, "onComplete", null, new Object[]{bMqttToken});
            if (result instanceof BError) {
                BError error = (BError)((Object)result);
                error.printStackTrace();
            }
        }
        catch (BError bError) {
            bError.printStackTrace();
        }
    }

    private boolean isMethodImplemented(String methodName) {
        Optional<RemoteMethodType> methodType = this.getRemoteMethodType(methodName);
        return methodType.isPresent();
    }

    private boolean isCallerAvailable() {
        Optional<RemoteMethodType> onMessageMethodType = this.getRemoteMethodType("onMessage");
        return onMessageMethodType.isPresent() && onMessageMethodType.get().getType().getParameters().length == 2;
    }

    private Optional<RemoteMethodType> getRemoteMethodType(String methodName) {
        RemoteMethodType[] methodTypes;
        for (RemoteMethodType methodType : methodTypes = ((ServiceType)this.service.getOriginalType()).getRemoteMethods()) {
            if (!methodType.getName().equals(methodName)) continue;
            return Optional.of(methodType);
        }
        return Optional.empty();
    }
}

