/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.modelgenerator.commons;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.ballerina.modelgenerator.commons.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.ballerinalang.langserver.BallerinaLanguageServer;
import org.ballerinalang.langserver.util.TestUtil;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class AbstractLSTest {
    protected static Logger log;
    protected static Path resDir;
    protected static Path sourceDir;
    protected static Path configDir;
    protected final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected Endpoint serviceEndpoint;
    protected BallerinaLanguageServer languageServer;
    protected static final List<String> UNDEFINED_DIAGNOSTICS_CODES;

    @BeforeClass
    public final void init() {
        resDir = Paths.get("src/test/resources", new String[0]).resolve(this.getResourceDir()).toAbsolutePath();
        configDir = resDir.resolve("config");
        if (!Files.isDirectory(configDir, new LinkOption[0])) {
            configDir = resDir;
        }
        if (!Files.isDirectory(sourceDir = resDir.resolve("source"), new LinkOption[0])) {
            sourceDir = resDir;
        }
        log = LoggerFactory.getLogger(this.clazz());
        this.languageServer = new BallerinaLanguageServer();
        TestUtil.LanguageServerBuilder builder = TestUtil.newLanguageServer().withLanguageServer(this.languageServer);
        this.serviceEndpoint = builder.build();
    }

    @Test(dataProvider="data-provider")
    public abstract void test(Path var1) throws IOException;

    @DataProvider(name="data-provider")
    protected Object[] getConfigsList() {
        Object[] objectArray;
        block8: {
            List<String> skippedTests = Arrays.stream(this.skipList()).toList();
            Stream<Path> stream = Files.walk(configDir, new FileVisitOption[0]);
            try {
                objectArray = stream.filter(path -> {
                    File file = path.toFile();
                    return file.isFile() && !file.getName().startsWith(".") && file.getName().endsWith(".json") && !skippedTests.contains(file.getName());
                }).toArray(Path[]::new);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Assert.fail((String)"Unable to load test config", (Throwable)e);
                    return new Object[0][];
                }
            }
            stream.close();
        }
        return objectArray;
    }

    protected String[] skipList() {
        return new String[0];
    }

    protected void updateConfig(Path configJsonPath, Object updatedConfig) throws IOException {
        String objStr = this.gson.toJson(updatedConfig).concat(System.lineSeparator());
        Files.writeString(configJsonPath, (CharSequence)objStr, new OpenOption[0]);
    }

    protected JsonObject getResponse(Endpoint endpoint, Object request) throws IOException {
        Endpoint tempEndPoint = this.serviceEndpoint;
        this.serviceEndpoint = endpoint;
        JsonObject response = this.getResponse(request);
        this.serviceEndpoint = tempEndPoint;
        return response;
    }

    protected JsonObject getResponse(Object request) throws IOException {
        return this.getResponse(request, this.getServiceName() + "/" + this.getApiName());
    }

    protected JsonObject getResponseAndCloseFile(Object request, String source) throws IOException {
        JsonObject response = this.getResponse(request);
        String fileUri = sourceDir.resolve(source).toAbsolutePath().toUri().toString();
        this.serviceEndpoint.notify("textDocument/didClose", (Object)new DidCloseTextDocumentParams(new TextDocumentIdentifier(fileUri)));
        return response;
    }

    protected JsonObject getResponse(Object request, String api) {
        CompletableFuture result = this.serviceEndpoint.request(api, request);
        String response = TestUtil.getResponseString((CompletableFuture)result);
        JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject().getAsJsonObject("result");
        JsonPrimitive errorMsg = jsonObject.getAsJsonPrimitive("errorMsg");
        if (errorMsg != null) {
            log.error("Stacktrace: {}", (Object)jsonObject.getAsJsonPrimitive("stacktrace").getAsString());
            Assert.fail((String)("Error occurred: " + errorMsg.getAsString()));
        }
        return jsonObject;
    }

    protected void sendNotification(String api, Object request) {
        this.serviceEndpoint.notify(api, request);
    }

    protected void notifyDidOpen(String sourcePath) throws IOException {
        TextDocumentItem textDocumentItem = this.getDocumentIdentifier(sourcePath, CommonUtils.getExprUri(sourcePath));
        this.sendNotification("textDocument/didOpen", new DidOpenTextDocumentParams(textDocumentItem));
    }

    protected TextDocumentItem getDocumentIdentifier(String sourcePath, String fileUri) {
        TextDocumentItem textDocumentItem = new TextDocumentItem();
        textDocumentItem.setUri(fileUri);
        textDocumentItem.setText(this.getText(sourcePath));
        textDocumentItem.setLanguageId("ballerina");
        textDocumentItem.setVersion(1);
        return textDocumentItem;
    }

    protected String getText(String sourcePath) {
        String string;
        FileInputStream fis = new FileInputStream(sourcePath);
        try {
            string = new String(fis.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                return "";
            }
        }
        fis.close();
        return string;
    }

    protected void notifyDidClose(String sourcePath) {
        TextDocumentIdentifier textDocumentIdentifier = new TextDocumentIdentifier();
        textDocumentIdentifier.setUri(CommonUtils.getExprUri(sourcePath));
        this.sendNotification("textDocument/didClose", new DidCloseTextDocumentParams(textDocumentIdentifier));
    }

    protected final boolean assertArray(String property, List<?> actualNodes, List<?> expectedNodes) {
        boolean hasRelevantTextEdits;
        int expectedTextEditsSize;
        boolean hasCountMatch;
        ArrayList unmatchedExpectedNodes = new ArrayList(expectedNodes);
        ArrayList mismatchedAvailableNodes = new ArrayList();
        int actualTextEditsSize = actualNodes.size();
        boolean bl = hasCountMatch = actualTextEditsSize == (expectedTextEditsSize = expectedNodes.size());
        if (!hasCountMatch) {
            log.error(String.format("Mismatched %s count. Expected: %d, Found: %d", property, expectedTextEditsSize, actualTextEditsSize));
        }
        for (Object actualNode : actualNodes) {
            if (expectedNodes.contains(actualNode)) {
                unmatchedExpectedNodes.remove(actualNode);
                continue;
            }
            mismatchedAvailableNodes.add(actualNode);
        }
        boolean hasAllExpectedTextEdits = unmatchedExpectedNodes.isEmpty();
        if (!hasAllExpectedTextEdits) {
            log.error(String.format("Found in expected %s but not in actual %s: ", property, property) + String.valueOf(unmatchedExpectedNodes));
        }
        if (!(hasRelevantTextEdits = mismatchedAvailableNodes.isEmpty())) {
            log.error(String.format("Found in actual %s but not in expected %s: ", property, property) + String.valueOf(mismatchedAvailableNodes));
        }
        return hasCountMatch && hasAllExpectedTextEdits && hasRelevantTextEdits;
    }

    protected void compareJsonElements(JsonElement actualJson, JsonElement expectedJson) {
        log.info("Differences in JSON elements:");
        this.compareJsonElementsRecursive(actualJson, expectedJson, "");
    }

    private void compareJsonElementsRecursive(JsonElement actualJson, JsonElement expectedJson, String path) {
        if (actualJson.isJsonObject() && expectedJson.isJsonObject()) {
            this.compareJsonObjects(actualJson.getAsJsonObject(), expectedJson.getAsJsonObject(), path);
        } else if (actualJson.isJsonArray() && expectedJson.isJsonArray()) {
            this.compareJsonArrays(actualJson.getAsJsonArray(), expectedJson.getAsJsonArray(), path);
        } else if (!actualJson.equals(expectedJson)) {
            log.info("- Value mismatch at '" + path + "'\n  actual: " + String.valueOf(actualJson) + "\n  expected: " + String.valueOf(expectedJson));
        }
    }

    private void compareJsonObjects(JsonObject actualJson, JsonObject expectedJson, String path) {
        String currentPath;
        String key;
        Set entrySet1 = actualJson.entrySet();
        Set entrySet2 = expectedJson.entrySet();
        for (Map.Entry entry : entrySet1) {
            key = (String)entry.getKey();
            String string = currentPath = path.isEmpty() ? key : path + "." + key;
            if (!expectedJson.has(key)) {
                log.info("- Key '" + currentPath + "' is missing in the expected JSON");
                continue;
            }
            this.compareJsonElementsRecursive((JsonElement)entry.getValue(), expectedJson.get(key), currentPath);
        }
        for (Map.Entry entry : entrySet2) {
            key = (String)entry.getKey();
            String string = currentPath = path.isEmpty() ? key : path + "." + key;
            if (actualJson.has(key)) continue;
            log.info("- Key '" + currentPath + "' is missing in the actual JSON");
        }
    }

    private void compareJsonArrays(JsonArray actualArray, JsonArray expectedArray, String path) {
        block4: {
            int i;
            int size2;
            int size1;
            block3: {
                size1 = actualArray.size();
                size2 = expectedArray.size();
                int minSize = Math.min(size1, size2);
                for (i = 0; i < minSize; ++i) {
                    this.compareJsonElementsRecursive(actualArray.get(i), expectedArray.get(i), path + "[" + i + "]");
                }
                if (size1 <= size2) break block3;
                for (i = size2; i < size1; ++i) {
                    log.info("- Extra element in actual JSON at '" + path + "[" + i + "]': " + String.valueOf(actualArray.get(i)));
                }
                break block4;
            }
            if (size2 <= size1) break block4;
            for (i = size1; i < size2; ++i) {
                log.info("- Extra element in expected JSON at '" + path + "[" + i + "]': " + String.valueOf(expectedArray.get(i)));
            }
        }
    }

    protected String getSourcePath(String source) {
        return sourceDir.resolve(source).toAbsolutePath().toString();
    }

    protected abstract String getResourceDir();

    protected abstract Class<? extends AbstractLSTest> clazz();

    protected abstract String getApiName();

    protected String getServiceName() {
        return "flowDesignService";
    }

    protected void startLanguageServer() {
        if (this.serviceEndpoint != null && this.languageServer != null) {
            return;
        }
        this.languageServer = new BallerinaLanguageServer();
        TestUtil.LanguageServerBuilder builder = TestUtil.newLanguageServer().withLanguageServer(this.languageServer);
        this.serviceEndpoint = builder.build();
    }

    @AfterClass
    public void shutDownLanguageServer() {
        if (this.serviceEndpoint == null) {
            return;
        }
        TestUtil.shutdownLanguageServer((Endpoint)this.serviceEndpoint);
        this.languageServer = null;
        this.serviceEndpoint = null;
    }

    static {
        UNDEFINED_DIAGNOSTICS_CODES = List.of("BCE2000", "BCE2011");
    }
}

