/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.modelgenerator.commons;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ExternalFunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FutureTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeDescTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ChildNodeList;
import io.ballerina.compiler.syntax.tree.DoStatementNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class CommonUtils {
    private static final String CENTRAL_ICON_URL = "https://bcentral-packageicons.azureedge.net/images/%s_%s_%s.png";
    private static final Pattern FULLY_QUALIFIED_MODULE_ID_PATTERN = Pattern.compile("(\\w+)/([\\w.]+):([^:]+):(\\w+)[|]?");
    public static final String BALLERINA_ORG_NAME = "ballerina";
    public static final String BALLERINAX_ORG_NAME = "ballerinax";
    public static final String LANG_LIB_PREFIX = "lang.";
    private static final String NATURAL_FUNCTION = "NaturalFunction";
    private static final String CALL_LLM = "callLlm";
    private static final String UNKNOWN_TYPE = "Unknown Type";

    public static String removeQuotes(String inputString) {
        return inputString.replaceAll("^\"|\"$", "");
    }

    public static String getProjectName(Document document) {
        return document.module().descriptor().packageName().value();
    }

    public static String getTypeSignature(SemanticModel semanticModel, TypeSymbol typeSymbol, boolean ignoreError, ModuleInfo moduleInfo) {
        return switch (typeSymbol.typeKind()) {
            case TypeDescKind.COMPILATION_ERROR -> UNKNOWN_TYPE;
            case TypeDescKind.UNION -> {
                UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
                yield unionTypeSymbol.memberTypeDescriptors().stream().filter(memberType -> !ignoreError || !memberType.subtypeOf(semanticModel.types().ERROR)).map(type -> CommonUtils.getTypeSignature(semanticModel, type, ignoreError, moduleInfo)).reduce((s1, s2) -> s1 + "|" + s2).orElse(CommonUtils.getTypeSignature((TypeSymbol)unionTypeSymbol, moduleInfo));
            }
            case TypeDescKind.TYPEDESC -> {
                TypeDescTypeSymbol typeDescTypeSymbol = (TypeDescTypeSymbol)typeSymbol;
                yield typeDescTypeSymbol.typeParameter().map(typeParameter -> CommonUtils.getTypeSignature(semanticModel, typeParameter, ignoreError, null)).orElse(CommonUtils.getTypeSignature((TypeSymbol)typeDescTypeSymbol, moduleInfo));
            }
            default -> CommonUtils.getTypeSignature(typeSymbol, moduleInfo);
        };
    }

    public static String getTypeSignature(SemanticModel semanticModel, TypeSymbol typeSymbol, boolean ignoreError) {
        return CommonUtils.getTypeSignature(semanticModel, typeSymbol, ignoreError, null);
    }

    public static String getTypeSignature(TypeSymbol typeSymbol, ModuleInfo moduleInfo) {
        String text = typeSymbol.signature();
        StringBuilder newText = new StringBuilder();
        Matcher matcher = FULLY_QUALIFIED_MODULE_ID_PATTERN.matcher(text);
        int nextStart = 0;
        while (matcher.find()) {
            newText.append(text, nextStart, matcher.start(1));
            String modPart = matcher.group(2);
            int last = modPart.lastIndexOf(".");
            if (last != -1) {
                modPart = modPart.substring(last + 1);
            }
            String typeName = matcher.group(4);
            if (moduleInfo == null || !modPart.equals(moduleInfo.packageName())) {
                newText.append(modPart);
                newText.append(":");
            }
            newText.append(typeName);
            nextStart = matcher.end(4);
        }
        if (nextStart != 0 && nextStart < text.length()) {
            newText.append(text.substring(nextStart));
        }
        return !newText.isEmpty() ? newText.toString() : text;
    }

    public static String getModuleName(Symbol symbol) {
        return symbol.getModule().flatMap(Symbol::getName).orElse("");
    }

    public static String getOrgName(Symbol symbol) {
        return symbol.getModule().map(module -> module.id().orgName()).orElse("");
    }

    public static NonTerminalNode getExpressionWithCheck(NonTerminalNode expressionNode) {
        NonTerminalNode parentNode = expressionNode.parent();
        return parentNode.kind() == SyntaxKind.CHECK_EXPRESSION ? parentNode : expressionNode;
    }

    public static NonTerminalNode getNode(SyntaxTree syntaxTree, TextRange textRange) {
        ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
        return modulePartNode.findNode(textRange, true);
    }

    public static Range toRange(LineRange lineRange) {
        return new Range(CommonUtils.toPosition(lineRange.startLine()), CommonUtils.toPosition(lineRange.endLine()));
    }

    public static Range toRange(LinePosition position) {
        return new Range(CommonUtils.toPosition(position), CommonUtils.toPosition(position));
    }

    public static Position toPosition(LinePosition linePosition) {
        return new Position(linePosition.line(), linePosition.offset());
    }

    public static Optional<TypeSymbol> getTypeSymbol(SemanticModel semanticModel, Node node) {
        if (node.kind() == SyntaxKind.TYPED_BINDING_PATTERN) {
            TypedBindingPatternNode typedBindingPatternNode = (TypedBindingPatternNode)node;
            BindingPatternNode bindingPatternNode = typedBindingPatternNode.bindingPattern();
            Optional typeDescriptorSymbol = semanticModel.symbol((Node)typedBindingPatternNode.typeDescriptor());
            if (typeDescriptorSymbol.isPresent() && ((Symbol)typeDescriptorSymbol.get()).kind() == SymbolKind.TYPE) {
                return Optional.of((TypeSymbol)typeDescriptorSymbol.get());
            }
            Optional bindingPatternSymbol = semanticModel.symbol((Node)bindingPatternNode);
            if (bindingPatternSymbol.isPresent() && ((Symbol)bindingPatternSymbol.get()).kind() == SymbolKind.VARIABLE) {
                return Optional.ofNullable(((VariableSymbol)bindingPatternSymbol.get()).typeDescriptor());
            }
        }
        return semanticModel.typeOf(node);
    }

    public static String getVariableName(Node node) {
        if (node.kind() == SyntaxKind.TYPED_BINDING_PATTERN) {
            return ((TypedBindingPatternNode)node).bindingPattern().toString().strip();
        }
        if (node instanceof BuiltinSimpleNameReferenceNode) {
            BuiltinSimpleNameReferenceNode builtinSimpleNameReferenceNode = (BuiltinSimpleNameReferenceNode)node;
            return builtinSimpleNameReferenceNode.name().text();
        }
        if (node instanceof SimpleNameReferenceNode) {
            SimpleNameReferenceNode simpleNameReferenceNode = (SimpleNameReferenceNode)node;
            return simpleNameReferenceNode.name().text();
        }
        return node.toString().strip();
    }

    public static String getDefaultValueForType(String type) {
        if (type == null) {
            return "";
        }
        return switch (type) {
            case "inclusion", "record" -> "{}";
            case "string" -> "\"\"";
            default -> "";
        };
    }

    public static boolean hasNoKeyword(Map<String, String> queryMap, String keyName) {
        return queryMap == null || queryMap.isEmpty() || !queryMap.containsKey(keyName) || queryMap.get(keyName).isEmpty();
    }

    public static TypeSymbol getRawType(TypeSymbol typeDescriptor) {
        if (typeDescriptor.typeKind() == TypeDescKind.INTERSECTION) {
            return CommonUtils.getRawType(((IntersectionTypeSymbol)typeDescriptor).effectiveTypeDescriptor());
        }
        if (typeDescriptor.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            TypeReferenceTypeSymbol typeRef = (TypeReferenceTypeSymbol)typeDescriptor;
            if (typeRef.typeDescriptor().typeKind() == TypeDescKind.INTERSECTION) {
                return CommonUtils.getRawType(((IntersectionTypeSymbol)typeRef.typeDescriptor()).effectiveTypeDescriptor());
            }
            TypeSymbol rawType = typeRef.typeDescriptor();
            if (rawType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                return CommonUtils.getRawType(rawType);
            }
            return rawType;
        }
        return typeDescriptor;
    }

    public static Document getDocument(Project project, Location location) {
        DocumentId documentId = project.documentId(project.kind() == ProjectKind.SINGLE_FILE_PROJECT ? project.sourceRoot() : project.sourceRoot().resolve(location.lineRange().fileName()));
        return project.currentPackage().getDefaultModule().document(documentId);
    }

    public static boolean withinDoClause(WorkspaceManager workspaceManager, Path filePath, LineRange lineRange) {
        try {
            workspaceManager.loadProject(filePath);
            Document document = (Document)workspaceManager.document(filePath).orElseThrow();
            int startPos = document.textDocument().textPositionFrom(lineRange.startLine());
            int endPos = document.textDocument().textPositionFrom(lineRange.endLine());
            ModulePartNode node = (ModulePartNode)document.syntaxTree().rootNode();
            NonTerminalNode currentNode = node.findNode(TextRange.from((int)startPos, (int)(endPos - startPos)), true);
            return CommonUtils.withinDoClause(currentNode);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean withinDoClause(NonTerminalNode node) {
        while (node != null) {
            if (node.kind() == SyntaxKind.DO_STATEMENT) {
                return ((DoStatementNode)node).onFailClause().isPresent();
            }
            node = node.parent();
        }
        return false;
    }

    public static String generateIcon(String orgName, String packageName, String versionName) {
        return String.format(CENTRAL_ICON_URL, orgName, packageName, versionName);
    }

    public static boolean subTypeOf(TypeSymbol source, TypeSymbol target) {
        TypeSymbol sourceRawType = CommonUtils.getRawType(source);
        switch (sourceRawType.typeKind()) {
            case UNION: {
                UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)sourceRawType;
                return unionTypeSymbol.memberTypeDescriptors().stream().anyMatch(type -> CommonUtils.subTypeOf(type, target));
            }
            case TYPEDESC: {
                break;
            }
            case INTERSECTION: {
                IntersectionTypeSymbol intersectionTypeSymbol = (IntersectionTypeSymbol)sourceRawType;
                return intersectionTypeSymbol.memberTypeDescriptors().stream().anyMatch(t -> CommonUtils.subTypeOf(t, target));
            }
            case TYPE_REFERENCE: {
                return CommonUtils.subTypeOf(sourceRawType, target);
            }
            default: {
                return sourceRawType.subtypeOf(target);
            }
        }
        return sourceRawType.subtypeOf(target);
    }

    public static Diagnostic transformBallerinaDiagnostic(io.ballerina.tools.diagnostics.Diagnostic diag) {
        DiagnosticInfo diagnosticInfo = diag.diagnosticInfo();
        return CommonUtils.createDiagnostic(diag.message(), diag.location().lineRange(), diagnosticInfo.code(), diagnosticInfo.severity());
    }

    public static Diagnostic createDiagnostic(String message, LineRange lineRange, DiagnosticErrorCode errorCode) {
        return CommonUtils.createDiagnostic(message, lineRange, errorCode.diagnosticId(), errorCode.severity());
    }

    public static Diagnostic createDiagnostic(String message, LineRange lineRange, String code, io.ballerina.tools.diagnostics.DiagnosticSeverity severity) {
        int startLine = lineRange.startLine().line();
        int startChar = lineRange.startLine().offset();
        int endLine = lineRange.endLine().line();
        int endChar = lineRange.endLine().offset();
        endLine = endLine <= 0 ? startLine : endLine;
        endChar = endChar <= 0 ? startChar + 1 : endChar;
        Range range = new Range(new Position(startLine, startChar), new Position(endLine, endChar));
        Diagnostic diagnostic = new Diagnostic(range, message, null, null, code);
        switch (severity) {
            case ERROR: {
                diagnostic.setSeverity(DiagnosticSeverity.Error);
                break;
            }
            case WARNING: {
                diagnostic.setSeverity(DiagnosticSeverity.Warning);
                break;
            }
            case HINT: {
                diagnostic.setSeverity(DiagnosticSeverity.Hint);
                break;
            }
            case INFO: {
                diagnostic.setSeverity(DiagnosticSeverity.Information);
                break;
            }
        }
        return diagnostic;
    }

    public static LineRange getLineRangeOfBlockNode(NonTerminalNode node) {
        ChildNodeList children = node.children();
        int size = children.size();
        if (size < 2) {
            return node.lineRange();
        }
        Node startToken = children.get(0);
        Node endToken = children.get(size - 1);
        if (startToken.kind() == SyntaxKind.OPEN_BRACE_TOKEN && endToken.kind() == SyntaxKind.CLOSE_BRACE_TOKEN) {
            return LineRange.from((String)node.lineRange().fileName(), (LinePosition)startToken.lineRange().endLine(), (LinePosition)endToken.lineRange().startLine());
        }
        return node.lineRange();
    }

    public static boolean isDefaultPackage(Symbol symbol, ModuleInfo moduleInfo) {
        Optional<ModuleID> moduleId = symbol.getModule().map(ModuleSymbol::id);
        return moduleId.filter(moduleID -> CommonUtils.isDefaultPackage(moduleID.orgName(), moduleID.moduleName(), moduleInfo)).isPresent();
    }

    public static boolean isDefaultPackage(String orgName, String packageName, ModuleInfo moduleInfo) {
        return orgName.equals(moduleInfo.org()) && packageName.equals(moduleInfo.packageName());
    }

    public static boolean isLinePositionAfter(LinePosition position, LinePosition other) {
        return position.line() > other.line() || position.line() == other.line() && position.offset() > other.offset();
    }

    public static boolean hasReturn(String typeName) {
        return !typeName.equals("()");
    }

    public static String getExprUri(String sourcePath) {
        String exprUriString = "expr" + Paths.get(sourcePath, new String[0]).toUri().toString().substring(4);
        return URI.create(exprUriString).toString();
    }

    public static Optional<String> getImportStatements(TypeSymbol typeSymbol, ModuleInfo moduleInfo) {
        HashSet<String> imports = new HashSet<String>();
        CommonUtils.analyzeTypeSymbolForImports(imports, typeSymbol, moduleInfo);
        if (imports.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)",", imports));
    }

    private static void analyzeTypeSymbolForImports(Set<String> imports, TypeSymbol typeSymbol, ModuleInfo moduleInfo) {
        switch (typeSymbol.typeKind()) {
            case UNION: {
                UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
                unionTypeSymbol.memberTypeDescriptors().forEach(memberType -> CommonUtils.analyzeTypeSymbolForImports(imports, memberType, moduleInfo));
                break;
            }
            case INTERSECTION: {
                IntersectionTypeSymbol intersectionTypeSymbol = (IntersectionTypeSymbol)typeSymbol;
                intersectionTypeSymbol.memberTypeDescriptors().forEach(memberType -> CommonUtils.analyzeTypeSymbolForImports(imports, memberType, moduleInfo));
                break;
            }
            case TABLE: {
                TableTypeSymbol tableTypeSymbol = (TableTypeSymbol)typeSymbol;
                CommonUtils.analyzeTypeSymbolForImports(imports, tableTypeSymbol.rowTypeParameter(), moduleInfo);
                tableTypeSymbol.keyConstraintTypeParameter().ifPresent(keyType -> CommonUtils.analyzeTypeSymbolForImports(imports, keyType, moduleInfo));
                break;
            }
            case TUPLE: {
                TupleTypeSymbol tupleTypeSymbol = (TupleTypeSymbol)typeSymbol;
                tupleTypeSymbol.memberTypeDescriptors().forEach(memberType -> CommonUtils.analyzeTypeSymbolForImports(imports, memberType, moduleInfo));
                break;
            }
            case STREAM: {
                StreamTypeSymbol streamTypeSymbol = (StreamTypeSymbol)typeSymbol;
                CommonUtils.analyzeTypeSymbolForImports(imports, streamTypeSymbol.typeParameter(), moduleInfo);
                CommonUtils.analyzeTypeSymbolForImports(imports, streamTypeSymbol.completionValueTypeParameter(), moduleInfo);
                break;
            }
            case FUTURE: {
                FutureTypeSymbol futureTypeSymbol = (FutureTypeSymbol)typeSymbol;
                futureTypeSymbol.typeParameter().ifPresent(typeParam -> CommonUtils.analyzeTypeSymbolForImports(imports, typeParam, moduleInfo));
                break;
            }
            case TYPEDESC: {
                TypeDescTypeSymbol typeDescTypeSymbol = (TypeDescTypeSymbol)typeSymbol;
                typeDescTypeSymbol.typeParameter().ifPresent(typeParam -> CommonUtils.analyzeTypeSymbolForImports(imports, typeParam, moduleInfo));
                break;
            }
            case ARRAY: {
                ArrayTypeSymbol arrayTypeSymbol = (ArrayTypeSymbol)typeSymbol;
                CommonUtils.analyzeTypeSymbolForImports(imports, arrayTypeSymbol.memberTypeDescriptor(), moduleInfo);
                break;
            }
            case MAP: {
                MapTypeSymbol memberTypeSymbol = (MapTypeSymbol)typeSymbol;
                CommonUtils.analyzeTypeSymbolForImports(imports, memberTypeSymbol.typeParam(), moduleInfo);
                break;
            }
            default: {
                Optional moduleSymbol = typeSymbol.getModule();
                if (moduleSymbol.isEmpty()) {
                    return;
                }
                ModuleID moduleId = ((ModuleSymbol)moduleSymbol.get()).id();
                String orgName = moduleId.orgName();
                String packageName = moduleId.packageName();
                String moduleName = moduleId.moduleName();
                String modulePrefix = moduleId.modulePrefix();
                if (CommonUtils.isPredefinedLangLib(orgName, packageName) || CommonUtils.isAnnotationLangLib(orgName, packageName) || CommonUtils.isWithinCurrentModule(moduleInfo, orgName, packageName, moduleName)) {
                    return;
                }
                if (orgName.equals(moduleInfo.org()) && modulePrefix.equals(moduleInfo.moduleName())) {
                    imports.add(CommonUtils.getImportStatement("", packageName, modulePrefix));
                    break;
                }
                imports.add(CommonUtils.getImportStatement(orgName, packageName, moduleName));
            }
        }
    }

    private static boolean isAnnotationLangLib(String orgName, String packageName) {
        return orgName.equals(BALLERINA_ORG_NAME) && packageName.equals("lang.annotations");
    }

    public static String getImportStatement(String orgName, String packageName, String moduleName) {
        StringBuilder importStatement = new StringBuilder();
        if (!orgName.isEmpty()) {
            importStatement.append(orgName).append("/");
        }
        if (moduleName != null && moduleName.startsWith(packageName + ".")) {
            importStatement.append(moduleName);
        } else if (moduleName != null && !packageName.equals(moduleName)) {
            importStatement.append(packageName).append(".").append(moduleName);
        } else {
            importStatement.append(packageName);
        }
        return importStatement.toString();
    }

    public static boolean isPredefinedLangLib(String orgName, String packageName) {
        return orgName.equals(BALLERINA_ORG_NAME) && CommonUtil.PRE_DECLARED_LANG_LIBS.contains(packageName);
    }

    private static boolean isWithinCurrentModule(ModuleInfo defaultModuleInfo, String orgName, String packageName, String moduleName) {
        return orgName.equals(defaultModuleInfo.org()) && packageName.equals(defaultModuleInfo.packageName()) && moduleName.equals(defaultModuleInfo.moduleName());
    }

    public static boolean isWithinPackage(Symbol symbol, ModuleInfo moduleInfo) {
        if (symbol.getModule().isEmpty()) {
            return false;
        }
        ModuleID moduleID = ((ModuleSymbol)symbol.getModule().get()).id();
        return moduleID.orgName().equals(moduleInfo.org()) && moduleID.packageName().equals(moduleInfo.packageName());
    }

    public static String convertToBalDocs(String text) {
        String[] lines = text.split("\n");
        StringBuilder formattedComment = new StringBuilder();
        for (String line : lines) {
            formattedComment.append("# ").append(line).append("\n");
        }
        return formattedComment.toString();
    }

    public static boolean isValueLangLibFunction(FunctionSymbol functionSymbol) {
        Optional module = functionSymbol.getModule();
        if (module.isEmpty()) {
            return false;
        }
        ModuleID id = ((ModuleSymbol)module.get()).id();
        return id.orgName().equals(BALLERINA_ORG_NAME) && id.packageName().startsWith(LANG_LIB_PREFIX);
    }

    public static boolean isHttpModule(Symbol symbol) {
        Optional module = symbol.getModule();
        if (module.isEmpty()) {
            return false;
        }
        ModuleID moduleId = ((ModuleSymbol)module.get()).id();
        return moduleId.orgName().equals(BALLERINA_ORG_NAME) && moduleId.packageName().equals("http");
    }

    public static boolean isNpModule(Symbol symbol) {
        Optional module = symbol.getModule();
        if (module.isEmpty()) {
            return false;
        }
        ModuleID moduleId = ((ModuleSymbol)module.get()).id();
        return moduleId.orgName().equals(BALLERINAX_ORG_NAME) && moduleId.packageName().equals("np");
    }

    public static boolean isNpFunction(FunctionSymbol functionSymbol) {
        if (CommonUtils.isNpModule((Symbol)functionSymbol) && functionSymbol.getName().isPresent() && ((String)functionSymbol.getName().get()).equals(CALL_LLM)) {
            return true;
        }
        if (!functionSymbol.external()) {
            return false;
        }
        List annotAttachments = ((ExternalFunctionSymbol)functionSymbol).annotAttachmentsOnExternal();
        return annotAttachments.stream().anyMatch(annot -> CommonUtils.isNpModule((Symbol)annot.typeDescriptor()) && annot.typeDescriptor().nameEquals(NATURAL_FUNCTION));
    }

    public static String getClassType(String packageName, String clientName) {
        String importPrefix = packageName.substring(packageName.lastIndexOf(46) + 1);
        return String.format("%s:%s", importPrefix, clientName);
    }

    public static LinePosition getPosition(LinePosition position, Document document) {
        if (position != null) {
            return position;
        }
        TextDocument textDocument = document.textDocument();
        int textPosition = textDocument.toCharArray().length;
        return textDocument.linePositionFrom(textPosition);
    }

    public static String getDefaultModulePrefix(String packageName) {
        String[] parts = packageName.split("\\.");
        return parts.length > 0 ? parts[parts.length - 1] : packageName;
    }

    public static String constructModuleId(ModuleDescriptor descriptor) {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(descriptor.org().value()).append('/');
        idBuilder.append(descriptor.name().packageName().value());
        String moduleNamePart = descriptor.name().moduleNamePart();
        if (moduleNamePart != null && !moduleNamePart.isEmpty()) {
            idBuilder.append('.').append(moduleNamePart);
        }
        idBuilder.append(':').append(descriptor.version());
        return idBuilder.toString();
    }

    public static boolean importExists(ModulePartNode node, String org, String module) {
        return node.imports().stream().anyMatch(importDeclarationNode -> {
            String moduleName = importDeclarationNode.moduleName().stream().map(Token::text).collect(Collectors.joining("."));
            return importDeclarationNode.orgName().isPresent() && org.equals(((ImportOrgNameNode)importDeclarationNode.orgName().get()).orgName().text()) && module.equals(moduleName);
        });
    }
}

