/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.modelgenerator.commons;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.PackageDescriptor;

public record ModuleInfo(String org, String packageName, String moduleName, String version) {
    public static ModuleInfo from(ModuleID moduleId) {
        return new ModuleInfo(moduleId.orgName(), moduleId.packageName(), moduleId.moduleName(), moduleId.version());
    }

    public static ModuleInfo from(ModuleDescriptor moduleDescriptor) {
        return new ModuleInfo(moduleDescriptor.org().value(), moduleDescriptor.packageName().value(), moduleDescriptor.name().toString(), moduleDescriptor.version().value().toString());
    }

    public static ModuleInfo from(PackageDescriptor packageDescriptor) {
        String packageName = packageDescriptor.name().value();
        return new ModuleInfo(packageDescriptor.org().value(), packageName, packageName, packageDescriptor.version().value().toString());
    }

    public static ModuleInfo from(String moduleId) {
        String[] parts = moduleId.split(":");
        String version = parts.length != 2 ? null : parts[1];
        String[] packagePath = parts[0].split("/");
        String org = packagePath.length != 2 ? null : packagePath[0];
        String packageName = packagePath[1];
        return new ModuleInfo(org, packageName, packageName, version);
    }

    public boolean isComplete() {
        return this.org != null && this.packageName != null && this.moduleName != null && this.version != null;
    }
}

