/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.modelgenerator.commons;

import io.ballerina.compiler.api.symbols.AnnotationAttachPoint;
import io.ballerina.modelgenerator.commons.Annotation;
import io.ballerina.modelgenerator.commons.AnnotationAttachment;
import io.ballerina.modelgenerator.commons.FunctionData;
import io.ballerina.modelgenerator.commons.ParameterData;
import io.ballerina.modelgenerator.commons.ParameterMemberTypeData;
import io.ballerina.modelgenerator.commons.ServiceDeclaration;
import io.ballerina.modelgenerator.commons.ServiceTypeFunction;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

public class ServiceDatabaseManager {
    private static final String INDEX_FILE_NAME = "service-index.sqlite";
    private static final Logger LOGGER = Logger.getLogger(ServiceDatabaseManager.class.getName());
    private final String dbPath;

    public static ServiceDatabaseManager getInstance() {
        return Holder.INSTANCE;
    }

    private ServiceDatabaseManager() {
        Path tempDir;
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load SQLite JDBC driver", e);
        }
        try {
            tempDir = Files.createTempDirectory("service-index", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create a temporary directory", e);
        }
        URL dbUrl = this.getClass().getClassLoader().getResource(INDEX_FILE_NAME);
        if (dbUrl == null) {
            throw new RuntimeException("Database resource not found: service-index.sqlite");
        }
        Path tempFile = tempDir.resolve(INDEX_FILE_NAME);
        try {
            Files.copy(dbUrl.openStream(), tempFile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy the database file to the temporary directory", e);
        }
        this.dbPath = "jdbc:sqlite:" + tempFile.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<FunctionData> getListener(String module) {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append("l.listener_id, ");
        sql.append("l.name AS listener_name, ");
        sql.append("l.description AS listener_description, ");
        sql.append("l.return_error, ");
        sql.append("p.package_id, ");
        sql.append("p.name AS package_name, ");
        sql.append("p.org, ");
        sql.append("p.version ");
        sql.append("FROM Listener l ");
        sql.append("JOIN Package p ON l.package_id = p.package_id ");
        sql.append("WHERE p.name = ? ");
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            Optional<FunctionData> optional;
            block18: {
                PreparedStatement stmt;
                block16: {
                    Optional<FunctionData> optional2;
                    block17: {
                        stmt = conn.prepareStatement(sql.toString());
                        try {
                            stmt.setString(1, module);
                            ResultSet rs = stmt.executeQuery();
                            if (!rs.next()) break block16;
                            FunctionData functionData = new FunctionData(rs.getInt("listener_id"), rs.getString("listener_name"), rs.getString("listener_description"), null, rs.getString("package_name"), rs.getString("package_name"), rs.getString("org"), rs.getString("version"), null, null, rs.getBoolean("return_error"), false, null);
                            functionData.setPackageId(rs.getString("package_id"));
                            conn.close();
                            optional2 = Optional.of(functionData);
                            if (stmt == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (stmt == null) break block18;
                stmt.close();
            }
            return optional;
        }
        catch (SQLException e) {
            Logger.getGlobal().severe("Error executing query: " + e.getMessage());
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public LinkedHashMap<String, ParameterData> getFunctionParametersAsMap(int listenerId) {
        String sql = "SELECT p.parameter_id, p.name, p.type, p.kind, p.optional, p.default_value, p.description, p.import_statements, pmt.type AS member_type, pmt.kind AS member_kind, pmt.package AS member_package FROM Parameter p LEFT JOIN ParameterMemberType pmt ON p.parameter_id = pmt.parameter_id WHERE p.listener_id = ?;";
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            LinkedHashMap<String, ParameterData> linkedHashMap;
            block17: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setInt(1, listenerId);
                    ResultSet rs = stmt.executeQuery();
                    LinkedHashMap<String, ParameterDataBuilder> builders = new LinkedHashMap<String, ParameterDataBuilder>();
                    while (rs.next()) {
                        String paramName = rs.getString("name");
                        int parameterId = rs.getInt("parameter_id");
                        String type = rs.getString("type");
                        ParameterData.Kind kind = ParameterData.Kind.valueOf(rs.getString("kind"));
                        String defaultValue = rs.getString("default_value");
                        String description = rs.getString("description");
                        boolean optional = rs.getBoolean("optional");
                        String importStatements = rs.getString("import_statements");
                        String memberType = rs.getString("member_type");
                        String memberKind = rs.getString("member_kind");
                        String memberPackage = rs.getString("member_package");
                        ParameterDataBuilder builder = (ParameterDataBuilder)builders.get(paramName);
                        if (builder == null) {
                            builder = new ParameterDataBuilder();
                            builder.parameterId = parameterId;
                            builder.name = paramName;
                            builder.type = type;
                            builder.kind = kind;
                            builder.defaultValue = defaultValue;
                            builder.description = description;
                            builder.optional = optional;
                            builder.importStatements = importStatements;
                            builders.put(paramName, builder);
                        }
                        if (memberType == null) continue;
                        ParameterMemberTypeData memberData = new ParameterMemberTypeData(memberType, memberKind, memberPackage, memberPackage);
                        builder.typeMembers.add(memberData);
                    }
                    LinkedHashMap<String, ParameterData> parameterResults = new LinkedHashMap<String, ParameterData>();
                    for (ParameterDataBuilder builder : builders.values()) {
                        parameterResults.put(builder.name, builder.build());
                    }
                    conn.close();
                    linkedHashMap = parameterResults;
                    if (stmt == null) break block17;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return linkedHashMap;
        }
        catch (SQLException e) {
            Logger.getGlobal().severe("Error executing query: " + e.getMessage());
            return new LinkedHashMap<String, ParameterData>();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Optional<ServiceDeclaration> getServiceDeclaration(String moduleName) {
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append("s.display_name, ");
        sql.append("s.optional_type_descriptor, ");
        sql.append("s.type_descriptor_label, ");
        sql.append("s.type_descriptor_description, ");
        sql.append("s.type_descriptor_default_value, ");
        sql.append("s.add_default_type_descriptor, ");
        sql.append("s.optional_absolute_resource_path, ");
        sql.append("s.absolute_resource_path_label, ");
        sql.append("s.absolute_resource_path_description, ");
        sql.append("s.absolute_resource_path_default_value, ");
        sql.append("s.optional_string_literal, ");
        sql.append("s.string_literal_label, ");
        sql.append("s.string_literal_description, ");
        sql.append("s.string_literal_default_value, ");
        sql.append("s.listener_kind, ");
        sql.append("s.kind, ");
        sql.append("p.package_id, ");
        sql.append("p.org, ");
        sql.append("p.name AS package_name, ");
        sql.append("p.version ");
        sql.append("FROM ServiceDeclaration s ");
        sql.append("JOIN Package p ON s.package_id = p.package_id ");
        sql.append("WHERE p.name = ?");
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            Optional<ServiceDeclaration> optional;
            block18: {
                PreparedStatement stmt;
                block16: {
                    Optional<ServiceDeclaration> optional2;
                    block17: {
                        stmt = conn.prepareStatement(sql.toString());
                        try {
                            stmt.setString(1, moduleName);
                            ResultSet rs = stmt.executeQuery();
                            if (!rs.next()) break block16;
                            ServiceDeclaration.Package packageInfo = new ServiceDeclaration.Package(rs.getInt("package_id"), rs.getString("org"), rs.getString("package_name"), rs.getString("version"));
                            ServiceDeclaration serviceDeclaration = new ServiceDeclaration(packageInfo, rs.getString("display_name"), rs.getInt("optional_type_descriptor"), rs.getString("type_descriptor_label"), rs.getString("type_descriptor_description"), rs.getString("type_descriptor_default_value"), rs.getInt("add_default_type_descriptor"), rs.getInt("optional_absolute_resource_path"), rs.getString("absolute_resource_path_label"), rs.getString("absolute_resource_path_description"), rs.getString("absolute_resource_path_default_value"), rs.getInt("optional_string_literal"), rs.getString("string_literal_label"), rs.getString("string_literal_description"), rs.getString("string_literal_default_value"), rs.getString("listener_kind"), rs.getString("kind"));
                            conn.close();
                            optional2 = Optional.of(serviceDeclaration);
                            if (stmt == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return optional2;
                }
                conn.close();
                optional = Optional.empty();
                if (stmt == null) break block18;
                stmt.close();
            }
            return optional;
        }
        catch (SQLException e) {
            Logger.getGlobal().severe("Error executing query: " + e.getMessage());
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<String> getServiceTypes(int packageId) {
        String sql = "SELECT DISTINCT name FROM ServiceType WHERE package_id = ?";
        ArrayList<String> serviceTypes = new ArrayList<String>();
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            ArrayList<String> arrayList;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setInt(1, packageId);
                    ResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        serviceTypes.add(rs.getString("name"));
                    }
                    conn.close();
                    arrayList = serviceTypes;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            Logger.getGlobal().severe("Error executing query: " + e.getMessage());
            return List.of();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<AnnotationAttachment> getAnnotationAttachments(int packageId) {
        String sql = "SELECT a.annotation_id, a.annot_name, a.attachment_points, a.display_name, a.description, a.type_constrain, a.package FROM Annotation a JOIN Package p ON a.package_id = p.package_id WHERE a.package_id = ?";
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            ArrayList<AnnotationAttachment> arrayList;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setInt(1, packageId);
                    ResultSet rs = stmt.executeQuery();
                    ArrayList<AnnotationAttachment> annotations = new ArrayList<AnnotationAttachment>();
                    while (rs.next()) {
                        annotations.add(new AnnotationAttachment(rs.getString("annot_name"), Arrays.stream(rs.getString("attachment_points").split(",")).map(AnnotationAttachPoint::valueOf).toList(), rs.getString("display_name"), rs.getString("description"), rs.getString("type_constrain"), rs.getString("package")));
                    }
                    conn.close();
                    arrayList = annotations;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            Logger.getGlobal().severe("Error executing query: " + e.getMessage());
            return List.of();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<ServiceTypeFunction> getMatchingServiceTypeFunctions(int packageId, String serviceType) {
        String sql = "SELECT f.function_id, f.name, f.description, f.accessor, f.kind, f.return_type, f.return_error, f.return_type_editable, f.import_statements, f.enable FROM ServiceTypeFunction f JOIN ServiceType st ON f.service_type_id = st.service_type_id WHERE st.package_id = ? AND st.name = ?";
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            ArrayList<ServiceTypeFunction> arrayList;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setInt(1, packageId);
                    stmt.setString(2, serviceType);
                    ResultSet rs = stmt.executeQuery();
                    ArrayList<ServiceTypeFunction> functions = new ArrayList<ServiceTypeFunction>();
                    while (rs.next()) {
                        int functionId = rs.getInt("function_id");
                        List<ServiceTypeFunction.ServiceTypeFunctionParameter> params = this.getServiceFunctionParams(functionId);
                        functions.add(new ServiceTypeFunction(rs.getInt("function_id"), rs.getString("name"), rs.getString("description"), rs.getString("accessor"), rs.getString("kind"), rs.getString("return_type"), rs.getInt("return_error"), rs.getInt("return_type_editable"), rs.getString("import_statements"), rs.getInt("enable"), params));
                    }
                    conn.close();
                    arrayList = functions;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            Logger.getGlobal().severe("Error executing query: " + e.getMessage());
            return List.of();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<ServiceTypeFunction.ServiceTypeFunctionParameter> getServiceFunctionParams(int functionId) {
        String sql = "SELECT parameter_id, name, label, description, kind, type, default_value, import_statements, editable_name, editable_type FROM ServiceTypeFunctionParameter WHERE function_id = ?";
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            ArrayList<ServiceTypeFunction.ServiceTypeFunctionParameter> arrayList;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setInt(1, functionId);
                    ResultSet rs = stmt.executeQuery();
                    ArrayList<ServiceTypeFunction.ServiceTypeFunctionParameter> parameters = new ArrayList<ServiceTypeFunction.ServiceTypeFunctionParameter>();
                    while (rs.next()) {
                        parameters.add(new ServiceTypeFunction.ServiceTypeFunctionParameter(rs.getInt("parameter_id"), rs.getString("name"), rs.getString("label"), rs.getString("description"), rs.getString("kind"), rs.getString("type"), rs.getString("default_value"), rs.getString("import_statements"), rs.getInt("editable_name"), rs.getInt("editable_type")));
                    }
                    conn.close();
                    arrayList = parameters;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            Logger.getGlobal().severe("Error executing query: " + e.getMessage());
            return List.of();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Annotation> getAnnotationAttachments(String org, String packageName, String attachPoint) {
        String sql = "SELECT a.annot_name, a.display_name, a.description, a.type_constrain, a.package FROM Annotation a JOIN Package p ON a.package_id = p.package_id WHERE p.name = ? AND p.org = ? AND a.attachment_points LIKE ?";
        try (Connection conn = DriverManager.getConnection(this.dbPath);){
            ArrayList<Annotation> arrayList;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, packageName);
                    stmt.setString(2, org);
                    stmt.setString(3, "%" + attachPoint + "%");
                    ResultSet rs = stmt.executeQuery();
                    ArrayList<Annotation> annotations = new ArrayList<Annotation>();
                    while (rs.next()) {
                        annotations.add(new Annotation(rs.getString("annot_name"), rs.getString("display_name"), rs.getString("description"), rs.getString("type_constrain"), rs.getString("package"), org, packageName));
                    }
                    conn.close();
                    arrayList = annotations;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            Logger.getGlobal().severe("Error executing query: " + e.getMessage());
            return List.of();
        }
    }

    private static class Holder {
        private static final ServiceDatabaseManager INSTANCE = new ServiceDatabaseManager();

        private Holder() {
        }
    }

    private static class ParameterDataBuilder {
        int parameterId;
        String name;
        String type;
        ParameterData.Kind kind;
        String defaultValue;
        String description;
        boolean optional;
        String importStatements;
        List<ParameterMemberTypeData> typeMembers = new ArrayList<ParameterMemberTypeData>();

        private ParameterDataBuilder() {
        }

        ParameterData build() {
            return new ParameterData(this.parameterId, this.name, this.type, this.kind, this.defaultValue, this.description, null, this.optional, this.importStatements, this.typeMembers);
        }
    }
}

