/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.transaction;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.transactions.TransactionConstants;
import io.ballerina.runtime.transactions.TransactionLocalContext;
import io.ballerina.runtime.transactions.TransactionResourceManager;
import java.nio.charset.Charset;
import java.util.Map;

public class SetTransactionContext {
    public static void setTransactionContext(Environment env, BMap txDataStruct, Object prevAttemptInfo) {
        String globalTransactionId = txDataStruct.get((Object)TransactionConstants.TRANSACTION_ID).toString();
        String transactionBlockId = txDataStruct.get((Object)TransactionConstants.TRANSACTION_BLOCK_ID).toString();
        String url = txDataStruct.get((Object)TransactionConstants.REGISTER_AT_URL).toString();
        String protocol = txDataStruct.get((Object)TransactionConstants.CORDINATION_TYPE).toString();
        long retryNmbr = SetTransactionContext.getRetryNumber(prevAttemptInfo);
        BMap trxContext = ValueCreator.createRecordValue((Module)TransactionConstants.TRANSACTION_PACKAGE_ID, (String)"InfoInternal");
        BObject startTimeObj = ValueCreator.createObjectValue((Module)env.getCurrentModule(), (String)"TimestampImpl", (Object[])new Object[0]);
        startTimeObj.addNativeData("timeValue", (Object)System.currentTimeMillis());
        Object[] trxContextData = new Object[]{ValueCreator.createArrayValue((byte[])globalTransactionId.getBytes(Charset.defaultCharset())), retryNmbr, prevAttemptInfo, startTimeObj};
        BMap infoRecord = ValueCreator.createRecordValue((BMap)trxContext, (Object[])trxContextData);
        infoRecord.freezeDirect();
        TransactionLocalContext trxCtx = TransactionLocalContext.createTransactionParticipantLocalCtx((String)globalTransactionId, (String)url, (String)protocol, (Object)infoRecord);
        trxCtx.beginTransactionBlock(transactionBlockId);
        TransactionResourceManager.getInstance().setCurrentTransactionContext(trxCtx);
    }

    private static long getRetryNumber(Object prevAttemptInfo) {
        if (prevAttemptInfo == null) {
            return 0L;
        }
        Map infoRecord = (Map)prevAttemptInfo;
        Long retryNumber = (Long)infoRecord.get(StringUtils.fromString((String)"retryNumber"));
        return retryNumber + 1L;
    }
}

