/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JEEnvironmentMonitorEntry
extends MonitorEntry {
    @NotNull
    static final String JE_ENVIRONMENT_MONITOR_OC = "ds-je-environment-monitor-entry";
    @NotNull
    private static final String ATTR_ACTIVE_TXNS = "active-transaction-count";
    @NotNull
    private static final String ATTR_AVERAGE_CHECKPOINT_DURATION_MILLIS = "average-checkpoint-duration-millis";
    @NotNull
    private static final String ATTR_BACKEND_ID = "backend-id";
    @NotNull
    private static final String ATTR_CACHE_PCT_FULL = "db-cache-percent-full";
    @NotNull
    private static final String ATTR_CHECKPOINT_IN_PROGRESS = "checkpoint-in-progress";
    @NotNull
    private static final String ATTR_CLEANER_BACKLOG = "cleaner-backlog";
    @NotNull
    private static final String ATTR_CURRENT_CACHE_SIZE = "current-db-cache-size";
    @NotNull
    private static final String ATTR_DB_DIRECTORY = "db-directory";
    @NotNull
    private static final String ATTR_DB_ON_DISK_SIZE = "db-on-disk-size";
    @NotNull
    private static final String ATTR_JE_VERSION = "je-version";
    @NotNull
    private static final String ATTR_LAST_CHECKPOINT_DURATION_MILLIS = "last-checkpoint-duration-millis";
    @NotNull
    private static final String ATTR_LAST_CHECKPOINT_START_TIME = "last-checkpoint-start-time";
    @NotNull
    private static final String ATTR_LAST_CHECKPOINT_STOP_TIME = "last-checkpoint-stop-time";
    @Deprecated
    @NotNull
    private static final String ATTR_LAST_CHECKPOINT_TIME = "last-checkpoint-time";
    @NotNull
    private static final String ATTR_MAX_CACHE_SIZE = "max-db-cache-size";
    @NotNull
    private static final String ATTR_MILLIS_SINCE_LAST_CHECKPOINT = "millis-since-last-checkpoint";
    @NotNull
    private static final String ATTR_NODES_EVICTED = "nodes-evicted";
    @NotNull
    private static final String ATTR_NUM_CHECKPOINTS = "num-checkpoints";
    @NotNull
    private static final String ATTR_NUM_READ_LOCKS = "read-locks-held";
    @NotNull
    private static final String ATTR_TOTAL_CHECKPOINT_DURATION_MILLIS = "total-checkpoint-duration-millis";
    @NotNull
    private static final String ATTR_NUM_WAITING_TXNS = "transactions-waiting-on-locks";
    @NotNull
    private static final String ATTR_NUM_WRITE_LOCKS = "write-locks-held";
    @NotNull
    private static final String ATTR_RANDOM_READS = "random-read-count";
    @NotNull
    private static final String ATTR_RANDOM_WRITES = "random-write-count";
    @NotNull
    private static final String ATTR_SEQUENTIAL_READS = "sequential-read-count";
    @NotNull
    private static final String ATTR_SEQUENTIAL_WRITES = "sequential-write-count";
    @NotNull
    private static final String ATTR_PREFIX_ENV_STAT = "je-env-stat-";
    @NotNull
    private static final String ATTR_PREFIX_LOCK_STAT = "je-lock-stat-";
    @NotNull
    private static final String ATTR_PREFIX_TXN_STAT = "je-txn-stat-";
    @NotNull
    private static final String PROPERTY_ENV_STATS = "je-env-stats";
    @NotNull
    private static final String PROPERTY_LOCK_STATS = "je-lock-stats";
    @NotNull
    private static final String PROPERTY_TXN_STATS = "je-txn-stats";
    private static final long serialVersionUID = 2557783119454069632L;
    @Nullable
    private final Boolean checkpointInProgress;
    @Nullable
    private final Date lastCheckpointStartTime;
    @Nullable
    private final Date lastCheckpointStopTime;
    @Deprecated
    @Nullable
    private final Date lastCheckpointTime;
    @Nullable
    private final Long activeTransactionCount = this.getLong("active-transaction-count");
    @Nullable
    private final Long averageCheckpointDurationMillis;
    @Nullable
    private final Long cleanerBacklog = this.getLong("cleaner-backlog");
    @Nullable
    private final Long currentDBCacheSize = this.getLong("current-db-cache-size");
    @Nullable
    private final Long dbCachePercentFull = this.getLong("db-cache-percent-full");
    @Nullable
    private final Long dbOnDiskSize = this.getLong("db-on-disk-size");
    @Nullable
    private final Long lastCheckpointDurationMillis;
    @Nullable
    private final Long maxDBCacheSize = this.getLong("max-db-cache-size");
    @Nullable
    private final Long millisSinceLastCheckpoint;
    @Nullable
    private final Long nodesEvicted = this.getLong("nodes-evicted");
    @Nullable
    private final Long numCheckpoints;
    @Nullable
    private final Long randomReads = this.getLong("random-read-count");
    @Nullable
    private final Long randomWrites = this.getLong("random-write-count");
    @Nullable
    private final Long readLocksHeld = this.getLong("read-locks-held");
    @Nullable
    private final Long sequentialReads = this.getLong("sequential-read-count");
    @Nullable
    private final Long sequentialWrites = this.getLong("sequential-write-count");
    @Nullable
    private final Long totalCheckpointDurationMillis;
    @Nullable
    private final Long transactionsWaitingOnLocks = this.getLong("transactions-waiting-on-locks");
    @Nullable
    private final Long writeLocksHeld = this.getLong("write-locks-held");
    @NotNull
    private final Map<String, String> envStats;
    @NotNull
    private final Map<String, String> lockStats;
    @NotNull
    private final Map<String, String> txnStats;
    @Nullable
    private final String backendID = this.getString("backend-id");
    @Nullable
    private final String dbDirectory = this.getString("db-directory");
    @Nullable
    private final String jeVersion = this.getString("je-version");

    public JEEnvironmentMonitorEntry(@NotNull Entry entry) {
        super(entry);
        this.checkpointInProgress = this.getBoolean(ATTR_CHECKPOINT_IN_PROGRESS);
        this.lastCheckpointStartTime = this.getDate(ATTR_LAST_CHECKPOINT_START_TIME);
        this.lastCheckpointStopTime = this.getDate(ATTR_LAST_CHECKPOINT_STOP_TIME);
        this.lastCheckpointTime = this.getDate(ATTR_LAST_CHECKPOINT_TIME);
        this.averageCheckpointDurationMillis = this.getLong(ATTR_AVERAGE_CHECKPOINT_DURATION_MILLIS);
        this.lastCheckpointDurationMillis = this.getLong(ATTR_LAST_CHECKPOINT_DURATION_MILLIS);
        this.millisSinceLastCheckpoint = this.getLong(ATTR_MILLIS_SINCE_LAST_CHECKPOINT);
        this.numCheckpoints = this.getLong(ATTR_NUM_CHECKPOINTS);
        this.totalCheckpointDurationMillis = this.getLong(ATTR_TOTAL_CHECKPOINT_DURATION_MILLIS);
        LinkedHashMap<String, String> tmpEnvStats = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(20));
        LinkedHashMap<String, String> tmpLockStats = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(20));
        LinkedHashMap<String, String> tmpTxnStats = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(20));
        for (Attribute a : entry.getAttributes()) {
            String name = StaticUtils.toLowerCase(a.getName());
            if (name.startsWith(ATTR_PREFIX_ENV_STAT)) {
                tmpEnvStats.put(StaticUtils.toLowerCase(name.substring(ATTR_PREFIX_ENV_STAT.length())), a.getValue());
                continue;
            }
            if (name.startsWith(ATTR_PREFIX_LOCK_STAT)) {
                tmpLockStats.put(StaticUtils.toLowerCase(name.substring(ATTR_PREFIX_LOCK_STAT.length())), a.getValue());
                continue;
            }
            if (!name.startsWith(ATTR_PREFIX_TXN_STAT)) continue;
            tmpTxnStats.put(StaticUtils.toLowerCase(name.substring(ATTR_PREFIX_TXN_STAT.length())), a.getValue());
        }
        this.envStats = Collections.unmodifiableMap(tmpEnvStats);
        this.lockStats = Collections.unmodifiableMap(tmpLockStats);
        this.txnStats = Collections.unmodifiableMap(tmpTxnStats);
    }

    @Nullable
    public String getBackendID() {
        return this.backendID;
    }

    @Nullable
    public String getJEVersion() {
        return this.jeVersion;
    }

    @Nullable
    public String getDBDirectory() {
        return this.dbDirectory;
    }

    @Nullable
    public Long getDBOnDiskSize() {
        return this.dbOnDiskSize;
    }

    @Nullable
    public Long getCurrentDBCacheSize() {
        return this.currentDBCacheSize;
    }

    @Nullable
    public Long getMaxDBCacheSize() {
        return this.maxDBCacheSize;
    }

    @Nullable
    public Long getDBCachePercentFull() {
        return this.dbCachePercentFull;
    }

    @Nullable
    public Boolean checkpointInProgress() {
        return this.checkpointInProgress;
    }

    @Nullable
    public Long getNumCheckpoints() {
        return this.numCheckpoints;
    }

    @Nullable
    public Long getTotalCheckpointDurationMillis() {
        return this.totalCheckpointDurationMillis;
    }

    @Nullable
    public Long getAverageCheckpointDurationMillis() {
        return this.averageCheckpointDurationMillis;
    }

    @Nullable
    public Long getLastCheckpointDurationMillis() {
        return this.lastCheckpointDurationMillis;
    }

    @Nullable
    public Date getLastCheckpointStartTime() {
        return this.lastCheckpointStartTime;
    }

    @Nullable
    public Date getLastCheckpointStopTime() {
        return this.lastCheckpointStopTime;
    }

    @Deprecated
    @Nullable
    public Date getLastCheckpointTime() {
        return this.lastCheckpointTime;
    }

    @Nullable
    public Long getMillisSinceLastCheckpoint() {
        return this.millisSinceLastCheckpoint;
    }

    @Nullable
    public Long getCleanerBacklog() {
        return this.cleanerBacklog;
    }

    @Nullable
    public Long getNodesEvicted() {
        return this.nodesEvicted;
    }

    @Nullable
    public Long getRandomReads() {
        return this.randomReads;
    }

    @Nullable
    public Long getRandomWrites() {
        return this.randomWrites;
    }

    @Nullable
    public Long getSequentialReads() {
        return this.sequentialReads;
    }

    @Nullable
    public Long getSequentialWrites() {
        return this.sequentialWrites;
    }

    @Nullable
    public Long getActiveTransactionCount() {
        return this.activeTransactionCount;
    }

    @Nullable
    public Long getReadLocksHeld() {
        return this.readLocksHeld;
    }

    @Nullable
    public Long getWriteLocksHeld() {
        return this.writeLocksHeld;
    }

    @Nullable
    public Long getTransactionsWaitingOnLocks() {
        return this.transactionsWaitingOnLocks;
    }

    @NotNull
    public Map<String, String> getEnvironmentStats() {
        return this.envStats;
    }

    @Nullable
    public String getEnvironmentStat(@NotNull String statName) {
        return this.envStats.get(StaticUtils.toLowerCase(statName));
    }

    @NotNull
    public Map<String, String> getLockStats() {
        return this.lockStats;
    }

    @Nullable
    public String getLockStat(@NotNull String statName) {
        return this.lockStats.get(StaticUtils.toLowerCase(statName));
    }

    @NotNull
    public Map<String, String> getTransactionStats() {
        return this.txnStats;
    }

    @Nullable
    public String getTransactionStat(@NotNull String statName) {
        return this.txnStats.get(StaticUtils.toLowerCase(statName));
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_JE_ENVIRONMENT_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_JE_ENVIRONMENT_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        ArrayList<String> values;
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(20));
        if (this.backendID != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_BACKEND_ID, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_BACKEND_ID.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_BACKEND_ID.get(), this.backendID);
        }
        if (this.jeVersion != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_JE_VERSION, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_JE_VERSION.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_JE_VERSION.get(), this.jeVersion);
        }
        if (this.dbDirectory != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_DB_DIRECTORY, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_DB_DIRECTORY.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_DB_DIRECTORY.get(), this.dbDirectory);
        }
        if (this.dbOnDiskSize != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_DB_ON_DISK_SIZE, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_DB_ON_DISK_SIZE.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_DB_ON_DISK_SIZE.get(), this.dbOnDiskSize);
        }
        if (this.currentDBCacheSize != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_CACHE_SIZE, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_CURRENT_CACHE_SIZE.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_CURRENT_CACHE_SIZE.get(), this.currentDBCacheSize);
        }
        if (this.maxDBCacheSize != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_CACHE_SIZE, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_MAX_CACHE_SIZE.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_MAX_CACHE_SIZE.get(), this.maxDBCacheSize);
        }
        if (this.dbCachePercentFull != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_CACHE_PCT_FULL, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_CACHE_PCT_FULL.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_CACHE_PCT_FULL.get(), this.dbCachePercentFull);
        }
        if (this.checkpointInProgress != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_CHECKPOINT_IN_PROGRESS, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_CP_IN_PROGRESS.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_CP_IN_PROGRESS.get(), this.checkpointInProgress);
        }
        if (this.numCheckpoints != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_CHECKPOINTS, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_NUM_CP.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_NUM_CP.get(), this.numCheckpoints);
        }
        if (this.totalCheckpointDurationMillis != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_CHECKPOINT_DURATION_MILLIS, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_TOTAL_CP_DURATION.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_TOTAL_CP_DURATION.get(), this.totalCheckpointDurationMillis);
        }
        if (this.averageCheckpointDurationMillis != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_AVERAGE_CHECKPOINT_DURATION_MILLIS, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_AVG_CP_DURATION.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_AVG_CP_DURATION.get(), this.averageCheckpointDurationMillis);
        }
        if (this.lastCheckpointDurationMillis != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_LAST_CHECKPOINT_DURATION_MILLIS, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_LAST_CP_DURATION.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_LAST_CP_DURATION.get(), this.lastCheckpointDurationMillis);
        }
        if (this.lastCheckpointStartTime != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_LAST_CHECKPOINT_START_TIME, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_LAST_CP_START_TIME.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_LAST_CP_START_TIME.get(), this.lastCheckpointStartTime);
        }
        if (this.lastCheckpointStopTime != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_LAST_CHECKPOINT_STOP_TIME, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_LAST_CP_STOP_TIME.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_LAST_CP_STOP_TIME.get(), this.lastCheckpointStopTime);
        }
        if (this.millisSinceLastCheckpoint != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_MILLIS_SINCE_LAST_CHECKPOINT, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_MILLIS_SINCE_CP.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_MILLIS_SINCE_CP.get(), this.millisSinceLastCheckpoint);
        }
        if (this.cleanerBacklog != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_CLEANER_BACKLOG, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_CLEANER_BACKLOG.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_CLEANER_BACKLOG.get(), this.cleanerBacklog);
        }
        if (this.nodesEvicted != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_NODES_EVICTED, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_NODES_EVICTED.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_NODES_EVICTED.get(), this.nodesEvicted);
        }
        if (this.randomReads != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_RANDOM_READS, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_RANDOM_READS.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_RANDOM_READS.get(), this.randomReads);
        }
        if (this.randomWrites != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_RANDOM_WRITES, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_RANDOM_WRITES.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_RANDOM_WRITES.get(), this.randomWrites);
        }
        if (this.sequentialReads != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_SEQUENTIAL_READS, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_SEQUENTIAL_READS.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_SEQUENTIAL_READS.get(), this.sequentialReads);
        }
        if (this.sequentialWrites != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_SEQUENTIAL_WRITES, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_SEQUENTIAL_WRITES.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_SEQUENTIAL_WRITES.get(), this.sequentialWrites);
        }
        if (this.activeTransactionCount != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_ACTIVE_TXNS, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_ACTIVE_TXNS.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_ACTIVE_TXNS.get(), this.activeTransactionCount);
        }
        if (this.readLocksHeld != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_READ_LOCKS, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_READ_LOCKS.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_READ_LOCKS.get(), this.readLocksHeld);
        }
        if (this.writeLocksHeld != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_WRITE_LOCKS, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_WRITE_LOCKS.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_WRITE_LOCKS.get(), this.writeLocksHeld);
        }
        if (this.transactionsWaitingOnLocks != null) {
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_WAITING_TXNS, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_TXNS_WAITING_ON_LOCKS.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_TXNS_WAITING_ON_LOCKS.get(), this.transactionsWaitingOnLocks);
        }
        if (!this.envStats.isEmpty()) {
            values = new ArrayList<String>(this.envStats.size());
            for (Map.Entry<String, String> e : this.envStats.entrySet()) {
                values.add(e.getKey() + '=' + e.getValue());
            }
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, PROPERTY_ENV_STATS, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_ENV_STATS.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_ENV_STATS.get(), values);
        }
        if (!this.lockStats.isEmpty()) {
            values = new ArrayList(this.lockStats.size());
            for (Map.Entry<String, String> e : this.lockStats.entrySet()) {
                values.add(e.getKey() + '=' + e.getValue());
            }
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, PROPERTY_LOCK_STATS, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_LOCK_STATS.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_LOCK_STATS.get(), values);
        }
        if (!this.txnStats.isEmpty()) {
            values = new ArrayList(this.txnStats.size());
            for (Map.Entry<String, String> e : this.txnStats.entrySet()) {
                values.add(e.getKey() + '=' + e.getValue());
            }
            JEEnvironmentMonitorEntry.addMonitorAttribute(attrs, PROPERTY_TXN_STATS, MonitorMessages.INFO_JE_ENVIRONMENT_DISPNAME_TXN_STATS.get(), MonitorMessages.INFO_JE_ENVIRONMENT_DESC_TXN_STATS.get(), values);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

