/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.datasource;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import java.util.Map;
import java.util.Objects;

public class PoolKey {
    private final String jdbcUrl;
    private final BMap<BString, ?> options;

    public PoolKey(String jdbcUrl, BMap<BString, ?> options) {
        this.jdbcUrl = jdbcUrl;
        this.options = options;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PoolKey)) {
            return false;
        }
        boolean jdbcUrlEqual = ((PoolKey)obj).jdbcUrl.equals(this.jdbcUrl);
        return jdbcUrlEqual && this.optionsEqual((PoolKey)obj);
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = hashCode * 31 + this.jdbcUrl.hashCode();
        if (this.options != null) {
            hashCode = 31 * hashCode + this.calculateDbOptionsHashCode();
        }
        return hashCode;
    }

    private int calculateDbOptionsHashCode() {
        int hashCode = 17;
        for (Map.Entry entry : this.options.entrySet()) {
            int valueHashCode;
            int keyHashCode = ((BString)entry.getKey()).hashCode();
            Object value = entry.getValue();
            Objects.requireNonNull(value, "type null shouldn't have occurred");
            if (value instanceof BValue || value instanceof Number || value instanceof String || value instanceof Boolean) {
                Type type = TypeUtils.getType(value);
                int typeTag = type.getTag();
                switch (typeTag) {
                    case 4: 
                    case 5: {
                        valueHashCode = value.hashCode();
                        break;
                    }
                    case 1: 
                    case 2: {
                        assert (value instanceof Number);
                        long longValue = (Long)value;
                        valueHashCode = (int)(longValue ^ longValue >>> 32);
                        break;
                    }
                    case 3: {
                        assert (value instanceof Double);
                        long longValueConvertedFromDouble = Double.doubleToLongBits((Double)value);
                        valueHashCode = (int)(longValueConvertedFromDouble ^ longValueConvertedFromDouble >>> 32);
                        break;
                    }
                    case 6: {
                        assert (value instanceof Boolean);
                        valueHashCode = (Boolean)value != false ? 1 : 0;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("type " + type.getName() + " shouldn't have occurred"));
                    }
                }
            } else {
                valueHashCode = value.hashCode();
            }
            hashCode = hashCode + keyHashCode + valueHashCode;
        }
        return hashCode;
    }

    private boolean optionsEqual(PoolKey anotherPoolKey) {
        BMap<BString, ?> anotherDbOptions = anotherPoolKey.options;
        if (this.options == null && anotherDbOptions == null) {
            return true;
        }
        if (this.options == null || anotherDbOptions == null) {
            return false;
        }
        if (this.options.size() != anotherDbOptions.size()) {
            return false;
        }
        for (Map.Entry entry : this.options.entrySet()) {
            if (entry.getValue().equals(anotherDbOptions.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }
}

