/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.nativeimpl;

import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.sql.Constants;
import io.ballerina.stdlib.sql.exception.ApplicationError;
import io.ballerina.stdlib.sql.parameterprocessor.AbstractResultParameterProcessor;
import io.ballerina.stdlib.sql.parameterprocessor.DefaultResultParameterProcessor;
import io.ballerina.stdlib.sql.utils.ErrorGenerator;
import io.ballerina.stdlib.sql.utils.Utils;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.OffsetTime;

public class OutParameterProcessor {
    private OutParameterProcessor() {
    }

    public static Object getOutParameterValue(BObject result, BTypedesc typeDesc) {
        return OutParameterProcessor.get(result, typeDesc, DefaultResultParameterProcessor.getInstance(), "OutParameter");
    }

    public static BStream getOutCursorValue(BObject result, BTypedesc typeDesc) {
        return OutParameterProcessor.get(result, typeDesc, DefaultResultParameterProcessor.getInstance());
    }

    public static Object getInOutParameterValue(BObject result, BTypedesc typeDesc) {
        return OutParameterProcessor.get(result, typeDesc, DefaultResultParameterProcessor.getInstance(), "InOutParameter");
    }

    private static Object populateOutParameter(BObject parameter) throws SQLException, ApplicationError {
        int paramIndex = (Integer)parameter.getNativeData("parameterIndex");
        int sqlType = (Integer)parameter.getNativeData("sqlType");
        CallableStatement statement = (CallableStatement)parameter.getNativeData("Statement");
        BObject procedureCallResult = (BObject)parameter.getNativeData("ProcedureCallResult");
        AbstractResultParameterProcessor resultParameterProcessor = (AbstractResultParameterProcessor)parameter.getNativeData("ResultParameterProcessor");
        Object result = switch (sqlType) {
            case 1 -> resultParameterProcessor.processChar(statement, paramIndex);
            case 12 -> resultParameterProcessor.processVarchar(statement, paramIndex);
            case -1 -> resultParameterProcessor.processLongVarchar(statement, paramIndex);
            case -15 -> resultParameterProcessor.processNChar(statement, paramIndex);
            case -9 -> resultParameterProcessor.processNVarchar(statement, paramIndex);
            case -16 -> resultParameterProcessor.processLongNVarchar(statement, paramIndex);
            case -2 -> resultParameterProcessor.processBinary(statement, paramIndex);
            case -3 -> resultParameterProcessor.processVarBinary(statement, paramIndex);
            case -4 -> resultParameterProcessor.processLongVarBinary(statement, paramIndex);
            case 2004 -> resultParameterProcessor.processBlob(statement, paramIndex);
            case 2005 -> resultParameterProcessor.processClob(statement, paramIndex);
            case 2011 -> resultParameterProcessor.processNClob(statement, paramIndex);
            case 91 -> resultParameterProcessor.processDate(statement, paramIndex);
            case 92 -> resultParameterProcessor.processTime(statement, paramIndex);
            case 2013 -> resultParameterProcessor.processTimeWithTimeZone(statement, paramIndex);
            case 93 -> resultParameterProcessor.processTimestamp(statement, paramIndex);
            case 2014 -> resultParameterProcessor.processTimestampWithTimeZone(statement, paramIndex);
            case 2003 -> resultParameterProcessor.processArray(statement, paramIndex);
            case -8 -> resultParameterProcessor.processRowID(statement, paramIndex);
            case -6 -> resultParameterProcessor.processTinyInt(statement, paramIndex);
            case 5 -> resultParameterProcessor.processSmallInt(statement, paramIndex);
            case 4 -> resultParameterProcessor.processInteger(statement, paramIndex);
            case -5 -> resultParameterProcessor.processBigInt(statement, paramIndex);
            case 7 -> resultParameterProcessor.processReal(statement, paramIndex);
            case 6 -> resultParameterProcessor.processFloat(statement, paramIndex);
            case 8 -> resultParameterProcessor.processDouble(statement, paramIndex);
            case 2 -> resultParameterProcessor.processNumeric(statement, paramIndex);
            case 3 -> resultParameterProcessor.processDecimal(statement, paramIndex);
            case -7 -> resultParameterProcessor.processBit(statement, paramIndex);
            case 16 -> resultParameterProcessor.processBoolean(statement, paramIndex);
            case 2006, 2012 -> {
                Object output = resultParameterProcessor.processRef(statement, paramIndex);
                procedureCallResult.addNativeData("RefCursorValue", output);
                yield output;
            }
            case 2002 -> resultParameterProcessor.processStruct(statement, paramIndex);
            case 2009 -> resultParameterProcessor.processXML(statement, paramIndex);
            default -> resultParameterProcessor.processCustomOutParameters(statement, paramIndex, sqlType);
        };
        return result;
    }

    public static BStream get(BObject result, Object recordType, AbstractResultParameterProcessor resultParameterProcessor) {
        Object value;
        try {
            value = OutParameterProcessor.populateOutParameter(result);
        }
        catch (ApplicationError | SQLException e) {
            return Utils.getErrorStream(recordType, ErrorGenerator.getSQLError(e, "Failed to read parameter value."));
        }
        RecordType streamConstraint = (RecordType)TypeUtils.getReferredType((Type)((BTypedesc)recordType).getDescribingType());
        return resultParameterProcessor.convertCursorValue((ResultSet)value, streamConstraint);
    }

    public static Object get(BObject result, BTypedesc typeDesc, AbstractResultParameterProcessor resultParameterProcessor, String parameterType) {
        Object value;
        int sqlType = (Integer)result.getNativeData("sqlType");
        try {
            value = OutParameterProcessor.populateOutParameter(result);
        }
        catch (ApplicationError | SQLException e) {
            return ErrorGenerator.getSQLError(e, "Failed to read parameter value.");
        }
        Type ballerinaType = TypeUtils.getReferredType((Type)typeDesc.getDescribingType());
        try {
            if (ballerinaType.getTag() == 33) {
                throw new ApplicationError(parameterType + " 'get' function does not support union return type.");
            }
            switch (sqlType) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    return resultParameterProcessor.convertChar((String)value, sqlType, ballerinaType);
                }
                case -4: 
                case -3: 
                case -2: {
                    return resultParameterProcessor.convertBinary(value, sqlType, ballerinaType);
                }
                case 2003: {
                    Array array = (Array)value;
                    Object[] dataArray = (Object[])array.getArray();
                    if (dataArray != null && dataArray.length != 0) {
                        String objectType = TypeUtils.getType((Object)result).getName();
                        if (objectType.equals("InOutParameter") || objectType.equals("ArrayOutParameter")) {
                            return resultParameterProcessor.convertArrayInOutParameter(dataArray, ballerinaType);
                        }
                        return resultParameterProcessor.convertArrayOutParameter(objectType, dataArray, ballerinaType);
                    }
                    return null;
                }
                case 2004: {
                    return resultParameterProcessor.convertBlob((Blob)value, sqlType, ballerinaType);
                }
                case 2005: {
                    String clobValue = Utils.getString((Clob)value, -1);
                    return resultParameterProcessor.convertChar(clobValue, sqlType, ballerinaType);
                }
                case 2011: {
                    String nClobValue = Utils.getString((NClob)value, -1);
                    return resultParameterProcessor.convertChar(nClobValue, sqlType, ballerinaType);
                }
                case 91: {
                    return resultParameterProcessor.convertDate((Date)value, sqlType, ballerinaType);
                }
                case 92: {
                    return resultParameterProcessor.convertTime((Time)value, sqlType, ballerinaType);
                }
                case 2013: {
                    return resultParameterProcessor.convertTimeWithTimezone((OffsetTime)value, sqlType, ballerinaType);
                }
                case 93: {
                    return resultParameterProcessor.convertTimeStamp((Timestamp)value, sqlType, ballerinaType);
                }
                case 2014: {
                    return resultParameterProcessor.convertTimestampWithTimezone((OffsetDateTime)value, sqlType, ballerinaType);
                }
                case -8: {
                    return resultParameterProcessor.convertByteArray(((RowId)value).getBytes(), sqlType, ballerinaType, "SQL RowID");
                }
                case -6: 
                case 5: {
                    if (value == null) {
                        return null;
                    }
                    return resultParameterProcessor.convertInteger(((Integer)value).intValue(), sqlType, ballerinaType, false);
                }
                case -5: 
                case 4: {
                    if (value == null) {
                        return null;
                    }
                    return resultParameterProcessor.convertInteger((Long)value, sqlType, ballerinaType, false);
                }
                case 6: 
                case 7: {
                    if (value == null) {
                        return null;
                    }
                    return resultParameterProcessor.convertDouble(((Float)value).floatValue(), sqlType, ballerinaType, false);
                }
                case 8: {
                    if (value == null) {
                        return null;
                    }
                    return resultParameterProcessor.convertDouble((Double)value, sqlType, ballerinaType, false);
                }
                case 2: 
                case 3: {
                    if (value == null) {
                        return null;
                    }
                    return resultParameterProcessor.convertDecimal((BigDecimal)value, sqlType, ballerinaType, false);
                }
                case -7: 
                case 16: {
                    if (value == null) {
                        return null;
                    }
                    return resultParameterProcessor.convertBoolean((Boolean)value, sqlType, ballerinaType, false);
                }
                case 2002: 
                case 2006: {
                    return resultParameterProcessor.convertStruct((Struct)value, sqlType, ballerinaType);
                }
                case 2009: {
                    return resultParameterProcessor.convertXml((SQLXML)value, sqlType, ballerinaType);
                }
            }
            String objectType = TypeUtils.getType((Object)result).getName();
            if (objectType.equals("InOutParameter")) {
                Object inParamValue = result.get(Constants.ParameterObject.IN_VALUE_FIELD);
                return resultParameterProcessor.convertCustomInOutParameter(value, inParamValue, sqlType, ballerinaType);
            }
            String outParamObjectName = TypeUtils.getType((Object)result).getName();
            return resultParameterProcessor.convertCustomOutParameter(value, outParamObjectName, sqlType, ballerinaType);
        }
        catch (ApplicationError applicationError) {
            return ErrorGenerator.getSQLApplicationError(applicationError);
        }
        catch (SQLException sqlException) {
            return ErrorGenerator.getSQLDatabaseError(sqlException, "Error when parsing out parameter.");
        }
        catch (Throwable th) {
            return ErrorGenerator.getSQLError(th, "Error when parsing out parameter.");
        }
    }
}

