/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.transaction;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.transactions.BallerinaTransactionContext;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAResource;

public class SQLTransactionContext
implements BallerinaTransactionContext {
    private Connection conn;
    private XAResource xaResource;

    public SQLTransactionContext(Connection conn, XAResource resource) {
        this.conn = conn;
        this.xaResource = resource;
    }

    public SQLTransactionContext(Connection conn) {
        this.conn = conn;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)("transaction commit failed:" + e.getMessage())));
        }
    }

    public void rollback() {
        try {
            if (!this.conn.isClosed()) {
                this.conn.rollback();
            }
        }
        catch (SQLException e) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)("transaction rollback failed:" + e.getMessage())));
        }
    }

    public void close() {
        try {
            if (!this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)("connection close failed:" + e.getMessage())));
        }
    }

    public XAResource getXAResource() {
        return this.xaResource;
    }
}

