/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.utils;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.sql.Constants;
import io.ballerina.stdlib.sql.exception.ApplicationError;
import io.ballerina.stdlib.sql.parameterprocessor.DefaultResultParameterProcessor;
import io.ballerina.stdlib.sql.utils.ColumnDefinition;
import io.ballerina.stdlib.sql.utils.ErrorGenerator;
import io.ballerina.stdlib.sql.utils.Utils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class ProcedureCallResultUtils {
    public static Object getNextQueryResult(BObject procedureCallResult) {
        DefaultResultParameterProcessor resultParameterProcessor = DefaultResultParameterProcessor.getInstance();
        return ProcedureCallResultUtils.getNextQueryResult(procedureCallResult, resultParameterProcessor);
    }

    public static Object getNextQueryResult(BObject procedureCallResult, DefaultResultParameterProcessor resultParameterProcessor) {
        CallableStatement statement = (CallableStatement)procedureCallResult.getNativeData("Statement");
        try {
            boolean moreResults = statement.getMoreResults();
            if (moreResults) {
                List<ColumnDefinition> columnDefinitions;
                RecordType streamConstraint;
                ResultSet resultSet = statement.getResultSet();
                int totalRecordDescriptions = (Integer)procedureCallResult.getNativeData("ResultSetTotal");
                if (totalRecordDescriptions == 0) {
                    streamConstraint = Utils.getDefaultStreamConstraint();
                    columnDefinitions = Utils.getColumnDefinitions(resultSet, (StructureType)streamConstraint);
                } else {
                    Object[] recordDescriptions = (Object[])procedureCallResult.getNativeData("TypeDescription");
                    int recordDescription = (Integer)procedureCallResult.getNativeData("ResultSetCount");
                    if (recordDescription <= totalRecordDescriptions) {
                        streamConstraint = (StructureType)TypeUtils.getReferredType((Type)((BTypedesc)recordDescriptions[recordDescription]).getDescribingType());
                        columnDefinitions = Utils.getColumnDefinitions(resultSet, (StructureType)streamConstraint);
                        procedureCallResult.addNativeData("ResultSetCount", (Object)(recordDescription + 1));
                    } else {
                        throw new ApplicationError("The record description array count does not match with the returned result sets count.");
                    }
                }
                BStream streamValue = ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)streamConstraint, (Type)PredefinedTypes.TYPE_NULL), (BObject)resultParameterProcessor.createRecordIterator(resultSet, null, null, columnDefinitions, (StructureType)streamConstraint));
                procedureCallResult.set(Constants.QUERY_RESULT_FIELD, (Object)streamValue);
                procedureCallResult.set(Constants.EXECUTION_RESULT_FIELD, null);
            } else {
                Utils.updateProcedureCallExecutionResult(statement, procedureCallResult);
            }
            return moreResults;
        }
        catch (SQLException e) {
            return ErrorGenerator.getSQLDatabaseError(e, "Error when accessing the next query result.");
        }
        catch (ApplicationError e) {
            return ErrorGenerator.getSQLApplicationError("Error when accessing the next query result. " + e.getMessage());
        }
        catch (Throwable throwable) {
            return ErrorGenerator.getSQLApplicationError("Error when accessing the next SQL result. " + throwable.getMessage());
        }
    }

    public static Object closeCallResult(BObject procedureCallResult) {
        Statement statement = (Statement)procedureCallResult.getNativeData("Statement");
        Connection connection = (Connection)procedureCallResult.getNativeData("Connection");
        Object resultSet = procedureCallResult.getNativeData("RefCursorValue");
        if (resultSet instanceof ResultSet) {
            try {
                ((ResultSet)resultSet).close();
                procedureCallResult.addNativeData("RefCursorValue", null);
            }
            catch (SQLException e) {
                return ErrorGenerator.getSQLDatabaseError(e, "Error when closing the result set.");
            }
        }
        return Utils.cleanUpConnection(procedureCallResult, null, statement, connection);
    }
}

