/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.utils;

import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.sql.exception.ApplicationError;
import io.ballerina.stdlib.sql.parameterprocessor.DefaultResultParameterProcessor;
import io.ballerina.stdlib.sql.utils.ErrorGenerator;
import io.ballerina.stdlib.sql.utils.Utils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class RecordIteratorUtils {
    public static Object nextResult(BObject recordIterator) {
        DefaultResultParameterProcessor resultParameterProcessor = DefaultResultParameterProcessor.getInstance();
        return RecordIteratorUtils.nextResult(recordIterator, resultParameterProcessor);
    }

    public static Object nextResult(BObject recordIterator, DefaultResultParameterProcessor resultParameterProcessor) {
        ResultSet resultSet = (ResultSet)recordIterator.getNativeData("ResultSet");
        try {
            if (resultSet.next()) {
                RecordType streamConstraint = (RecordType)recordIterator.getNativeData("recordType");
                List columnDefinitions = (List)recordIterator.getNativeData("ColumnDefinition");
                return Utils.createBallerinaRecord(streamConstraint, resultParameterProcessor, resultSet, columnDefinitions);
            }
            RecordIteratorUtils.closeResult(recordIterator);
            return null;
        }
        catch (SQLException e) {
            RecordIteratorUtils.closeResult(recordIterator);
            return ErrorGenerator.getSQLDatabaseError(e, "Error when iterating the SQL result");
        }
        catch (ApplicationError e) {
            RecordIteratorUtils.closeResult(recordIterator);
            return ErrorGenerator.getSQLApplicationError(e, "Error when iterating the SQL result. ");
        }
        catch (Throwable throwable) {
            RecordIteratorUtils.closeResult(recordIterator);
            return ErrorGenerator.getSQLApplicationError("Error when iterating through the SQL result. " + throwable.getMessage());
        }
    }

    public static Object closeResult(BObject recordIterator) {
        ResultSet resultSet = (ResultSet)recordIterator.getNativeData("ResultSet");
        Statement statement = (Statement)recordIterator.getNativeData("Statement");
        Connection connection = (Connection)recordIterator.getNativeData("Connection");
        return Utils.cleanUpConnection(recordIterator, resultSet, statement, connection);
    }
}

