/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.utils;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.transactions.TransactionResourceManager;
import io.ballerina.stdlib.sql.Constants;
import io.ballerina.stdlib.sql.exception.ApplicationError;
import io.ballerina.stdlib.sql.exception.ConversionError;
import io.ballerina.stdlib.sql.exception.DataError;
import io.ballerina.stdlib.sql.exception.FieldMismatchError;
import io.ballerina.stdlib.sql.exception.TypeMismatchError;
import io.ballerina.stdlib.sql.parameterprocessor.AbstractResultParameterProcessor;
import io.ballerina.stdlib.sql.utils.ColumnDefinition;
import io.ballerina.stdlib.sql.utils.ErrorGenerator;
import io.ballerina.stdlib.sql.utils.ModuleUtils;
import io.ballerina.stdlib.sql.utils.PrimitiveTypeColumnDefinition;
import io.ballerina.stdlib.sql.utils.RecordColumnDefinition;
import io.ballerina.stdlib.sql.utils.SQLColumnMetadata;
import io.ballerina.stdlib.time.util.TimeValueHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Utils {
    public static final RecordType DATE_RECORD_TYPE = TypeCreator.createRecordType((String)"Date", (Module)io.ballerina.stdlib.time.util.ModuleUtils.getModule(), (long)0L, (boolean)true, (int)0);
    public static final ArrayType DATE_ARRAY_TYPE = TypeCreator.createArrayType((Type)DATE_RECORD_TYPE);
    public static final ArrayType STRING_ARRAY = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING);
    public static final ArrayType BOOLEAN_ARRAY = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_BOOLEAN);
    public static final ArrayType INT_ARRAY = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_INT);
    public static final ArrayType FLOAT_ARRAY = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_FLOAT);
    public static final ArrayType DECIMAL_ARRAY = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_DECIMAL);
    private static final ArrayType BYTE_ARRAY_TYPE = TypeCreator.createArrayType((Type)TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_BYTE));
    public static final RecordType CIVIL_RECORD_TYPE = TypeCreator.createRecordType((String)"Civil", (Module)io.ballerina.stdlib.time.util.ModuleUtils.getModule(), (long)0L, (boolean)true, (int)0);
    public static final ArrayType CIVIL_ARRAY_TYPE = TypeCreator.createArrayType((Type)CIVIL_RECORD_TYPE);
    public static final RecordType TIME_RECORD_TYPE = TypeCreator.createRecordType((String)"TimeOfDay", (Module)io.ballerina.stdlib.time.util.ModuleUtils.getModule(), (long)0L, (boolean)true, (int)0);
    public static final ArrayType TIME_ARRAY_TYPE = TypeCreator.createArrayType((Type)TIME_RECORD_TYPE);
    private static final List<String> KNOWN_RECORD_TYPES = Arrays.asList("Civil", "Date", "TimeOfDay");

    private Utils() {
    }

    public static boolean isWithinTrxBlock(TransactionResourceManager trxResourceManager) {
        return trxResourceManager.isInTransaction() && trxResourceManager.getCurrentTransactionContext().hasTransactionBlock();
    }

    public static void closeResources(boolean isWithinTrxBlock, ResultSet resultSet, Statement statement, Connection connection) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (!isWithinTrxBlock && connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static String getSqlQuery(BObject paramString) {
        BArray stringsArray = paramString.getArrayValue(Constants.ParameterizedQueryFields.STRINGS);
        StringBuilder sqlQuery = new StringBuilder();
        for (int i = 0; i < stringsArray.size(); ++i) {
            if (i > 0) {
                sqlQuery.append(" ? ");
            }
            sqlQuery.append(stringsArray.get((long)i).toString());
        }
        return sqlQuery.toString();
    }

    public static DataError throwInvalidParameterError(Object value, String sqlType) {
        String valueName = value instanceof BValue ? ((BValue)value).getType().getName() : value.getClass().getName();
        return new TypeMismatchError("Invalid parameter :" + valueName + " is passed as value for SQL type : " + sqlType);
    }

    public static String getString(Clob data, int columnIndex) throws DataError, SQLException {
        String string;
        if (data == null) {
            return null;
        }
        BufferedReader r = new BufferedReader(data.getCharacterStream());
        try {
            int pos;
            StringBuilder sb = new StringBuilder();
            while ((pos = ((Reader)r).read()) != -1) {
                sb.append((char)pos);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)r).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                if (columnIndex > 0) {
                    throw new ConversionError(columnIndex, "", "string", e.getMessage());
                }
                throw new ConversionError("", "string", e.getMessage());
            }
        }
        ((Reader)r).close();
        return string;
    }

    public static BArray createTimeStruct(long millis) {
        return TimeValueHandler.createUtcFromMilliSeconds((long)millis);
    }

    public static Object getGeneratedKeys(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        if (columnCount > 0) {
            int sqlType = metaData.getColumnType(1);
            switch (sqlType) {
                case -7: 
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 16: {
                    return rs.getLong(1);
                }
            }
            return rs.getString(1);
        }
        return null;
    }

    public static StructureType getDefaultRecordType(List<PrimitiveTypeColumnDefinition> columnDefinitions) {
        RecordType defaultRecord = Utils.getDefaultStreamConstraint();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (PrimitiveTypeColumnDefinition column : columnDefinitions) {
            long flags = 1L;
            flags = column.isNullable() ? (flags += 4096L) : (flags += 256L);
            fieldMap.put(column.getColumnName(), TypeCreator.createField((Type)column.getBallerinaType(), (String)column.getColumnName(), (long)flags));
        }
        defaultRecord.setFields(fieldMap);
        return defaultRecord;
    }

    public static RecordType getDefaultStreamConstraint() {
        Module ballerinaAnnotation = new Module("ballerina", "lang.annotations", "0.0.0");
        return TypeCreator.createRecordType((String)"$stream$anon$constraint$", (Module)ballerinaAnnotation, (long)0L, new HashMap(), (Type)PredefinedTypes.TYPE_ANYDATA, (boolean)false, (int)TypeFlags.asMask((int[])new int[]{2, 4}));
    }

    public static Object cleanUpConnection(BObject ballerinaObject, ResultSet resultSet, Statement statement, Connection connection) {
        TransactionResourceManager trxResourceManager;
        if (resultSet != null) {
            try {
                resultSet.close();
                ballerinaObject.addNativeData("ResultSet", null);
            }
            catch (SQLException e) {
                return ErrorGenerator.getSQLDatabaseError(e, "Error while closing the result set. ");
            }
        }
        if (statement != null) {
            try {
                statement.close();
                ballerinaObject.addNativeData("Statement", null);
            }
            catch (SQLException e) {
                return ErrorGenerator.getSQLDatabaseError(e, "Error while closing the result set. ");
            }
        }
        if (!((trxResourceManager = TransactionResourceManager.getInstance()).isInTransaction() && trxResourceManager.getCurrentTransactionContext().hasTransactionBlock() || connection == null)) {
            try {
                connection.close();
                ballerinaObject.addNativeData("Connection", null);
            }
            catch (SQLException e) {
                return ErrorGenerator.getSQLDatabaseError(e, "Error while closing the connection. ");
            }
        }
        return null;
    }

    public static void updateProcedureCallExecutionResult(CallableStatement statement, BObject procedureCallResult) throws SQLException {
        int count = statement.getUpdateCount();
        HashMap<String, Integer> resultFields = new HashMap<String, Integer>();
        resultFields.put("affectedRowCount", count);
        resultFields.put("lastInsertId", null);
        BMap executionResult = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"ExecutionResult", resultFields);
        procedureCallResult.set(Constants.EXECUTION_RESULT_FIELD, (Object)executionResult);
    }

    public static void validatedInvalidFieldAssignment(int sqlType, Type type, String sqlTypeName) throws DataError {
        if (!Utils.isValidFieldConstraint(sqlType, type)) {
            throw new TypeMismatchError(sqlTypeName, type.getName());
        }
    }

    private static Type validFieldConstraint(int sqlType, Type type) {
        if (type.getTag() == 33 && type instanceof UnionType) {
            if (Utils.isEnumType(type)) {
                return type;
            }
            UnionType bUnionType = (UnionType)type;
            for (Type memberType : bUnionType.getMemberTypes()) {
                Type referredType = TypeUtils.getReferredType((Type)memberType);
                if (!Utils.isValidFieldConstraint(sqlType, referredType)) continue;
                return referredType;
            }
        } else if (Utils.isValidPrimitiveConstraint(sqlType, type)) {
            return type;
        }
        return null;
    }

    public static PrimitiveTypeColumnDefinition getColumnDefinition(ResultSet resultSet, int columnIndex, Type type) throws SQLException, ApplicationError {
        type = TypeUtils.getReferredType((Type)type);
        ResultSetMetaData rsMetaData = resultSet.getMetaData();
        String columnName = rsMetaData.getColumnLabel(columnIndex);
        int sqlType = rsMetaData.getColumnType(columnIndex);
        String sqlTypeName = rsMetaData.getColumnTypeName(columnIndex);
        boolean isNullable = rsMetaData.isNullable(columnIndex) != 0;
        Utils.validatedInvalidFieldAssignment(sqlType, type, sqlTypeName);
        return new PrimitiveTypeColumnDefinition(columnName, sqlType, sqlTypeName, isNullable, 1, columnName, type);
    }

    public static List<ColumnDefinition> getColumnDefinitions(ResultSet resultSet, StructureType streamConstraint) throws SQLException, ApplicationError {
        boolean isTypedRecord;
        ArrayList<ColumnDefinition> columnDefs = new ArrayList<ColumnDefinition>();
        ArrayList<SQLColumnMetadata> sqlColumnMetadata = new ArrayList<SQLColumnMetadata>();
        HashMap groupedSQLColumnDefs = new HashMap();
        HashSet<Object> columnNames = new HashSet<Object>();
        HashMap groupedColumnNames = new HashMap();
        ResultSetMetaData rsMetaData = resultSet.getMetaData();
        boolean bl = isTypedRecord = !streamConstraint.getName().startsWith("record {");
        if (isTypedRecord) {
            streamConstraint.getFields().forEach((name, field) -> {
                if (TypeUtils.getReferredType((Type)field.getFieldType()).getTag() == 24) {
                    String fieldName = name;
                    String annotatedColumnName = Utils.getAnnotatedColumnName(streamConstraint, field.getFieldName());
                    if (annotatedColumnName != null) {
                        fieldName = annotatedColumnName;
                    }
                    groupedSQLColumnDefs.put(name, new ArrayList());
                    groupedColumnNames.put(fieldName, name);
                }
            });
        }
        int cols = rsMetaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            int n = rsMetaData.getColumnType(i);
            String sqlTypeName = rsMetaData.getColumnTypeName(i);
            boolean isNullable = rsMetaData.isNullable(i) != 0;
            Object colName = rsMetaData.getColumnLabel(i);
            String tablePrefix = "";
            boolean isDuplicatedColumn = false;
            if (((String)colName).contains(".")) {
                tablePrefix = ((String)colName).substring(0, ((String)colName).indexOf("."));
            } else if (columnNames.contains(colName)) {
                tablePrefix = rsMetaData.getTableName(i).toUpperCase(Locale.getDefault());
                isDuplicatedColumn = true;
            }
            String finalTablePrefix = tablePrefix;
            String matchedRecordField = groupedColumnNames.keySet().stream().filter(name -> name.equalsIgnoreCase(finalTablePrefix)).findFirst().orElse("");
            if (isTypedRecord && !matchedRecordField.equals("")) {
                List sqlColumnDefs = (List)groupedSQLColumnDefs.get(groupedColumnNames.get(matchedRecordField));
                sqlColumnDefs.add(new SQLColumnMetadata(((String)colName).substring(((String)colName).indexOf(".") + 1), n, sqlTypeName, isNullable, i));
                continue;
            }
            if (isDuplicatedColumn) {
                colName = tablePrefix + "." + (String)colName;
            }
            sqlColumnMetadata.add(new SQLColumnMetadata((String)colName, n, sqlTypeName, isNullable, i));
            columnNames.add(colName);
        }
        for (SQLColumnMetadata sQLColumnMetadata : sqlColumnMetadata) {
            columnDefs.add(Utils.generateColumnDefinition(sQLColumnMetadata, streamConstraint, sQLColumnMetadata.getColumnName()));
        }
        for (Map.Entry entry : groupedSQLColumnDefs.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            String groupedColumnKey = (String)entry.getKey();
            String annotatedColumnName = Utils.getAnnotatedColumnName(streamConstraint, groupedColumnKey);
            if (annotatedColumnName != null) {
                groupedColumnKey = annotatedColumnName;
            }
            Type fieldType = TypeUtils.getReferredType((Type)((Field)streamConstraint.getFields().get(entry.getKey())).getFieldType());
            StructureType recordFieldType = (StructureType)fieldType;
            ArrayList<PrimitiveTypeColumnDefinition> innerRecordFields = new ArrayList<PrimitiveTypeColumnDefinition>();
            for (SQLColumnMetadata columnMetadata : (List)entry.getValue()) {
                String loggedColumnName = groupedColumnKey.toUpperCase(Locale.getDefault()) + "." + columnMetadata.getColumnName();
                innerRecordFields.add(Utils.generateColumnDefinition(columnMetadata, recordFieldType, loggedColumnName));
            }
            columnDefs.add(new RecordColumnDefinition((String)entry.getKey(), (Type)recordFieldType, innerRecordFields));
        }
        return columnDefs;
    }

    private static PrimitiveTypeColumnDefinition generateColumnDefinition(SQLColumnMetadata metadata, StructureType streamConstraint, String logColumnName) throws ApplicationError {
        String ballerinaFieldName = null;
        Type ballerinaType = null;
        for (Map.Entry field : streamConstraint.getFields().entrySet()) {
            String fieldName = (String)field.getKey();
            String annotatedDBColName = Utils.getAnnotatedColumnName(streamConstraint, fieldName);
            if (annotatedDBColName != null) {
                fieldName = annotatedDBColName;
            }
            if (!fieldName.equalsIgnoreCase(metadata.getColumnName())) continue;
            ballerinaFieldName = (String)field.getKey();
            Type fieldType = TypeUtils.getReferredType((Type)((Field)field.getValue()).getFieldType());
            ballerinaType = Utils.validFieldConstraint(metadata.getSqlType(), fieldType);
            if (ballerinaType != null) break;
            throw new TypeMismatchError("The field '" + (String)field.getKey() + "' of type " + ((Field)field.getValue()).getFieldType().getName() + " cannot be mapped to the column '" + logColumnName + "' of SQL type '" + metadata.getSqlName() + "'");
        }
        if (ballerinaFieldName == null) {
            if (((RecordType)streamConstraint).isSealed()) {
                throw new FieldMismatchError("No mapping field found for SQL table column '" + logColumnName + "' in the record type '" + streamConstraint.getName() + "'");
            }
            ballerinaType = Utils.getDefaultBallerinaType(metadata.getSqlType());
            ballerinaFieldName = metadata.getColumnName();
        }
        return new PrimitiveTypeColumnDefinition(metadata.getColumnName(), metadata.getSqlType(), metadata.getSqlName(), metadata.isNullable(), metadata.getResultSetColIndex(), ballerinaFieldName, ballerinaType);
    }

    private static String getAnnotatedColumnName(StructureType streamConstraint, String fieldName) {
        Object fieldAnnotationsObj = streamConstraint.getAnnotation(StringUtils.fromString((String)("$field$." + fieldName)));
        if (fieldAnnotationsObj instanceof BMap) {
            BMap fieldAnnotations = (BMap)fieldAnnotationsObj;
            BMap columnAnnotation = fieldAnnotations.getMapValue(StringUtils.fromString((String)(String.valueOf(ModuleUtils.getPkgIdentifier()) + ":Column")));
            return columnAnnotation != null ? columnAnnotation.getStringValue(Constants.ANN_COLUMN_NAME_FIELD).getValue() : null;
        }
        return null;
    }

    public static BMap<BString, Object> createBallerinaRecord(RecordType recordConstraint, AbstractResultParameterProcessor resultParameterProcessor, ResultSet resultSet, List<ColumnDefinition> columnDefinitions) throws SQLException, DataError {
        HashMap<String, Object> struct = new HashMap<String, Object>();
        for (ColumnDefinition columnDefinition : columnDefinitions) {
            if (columnDefinition instanceof RecordColumnDefinition) {
                RecordColumnDefinition recordColumnDef = (RecordColumnDefinition)columnDefinition;
                BMap innerRecord = ValueCreator.createRecordValue((RecordType)((RecordType)recordColumnDef.getBallerinaType()));
                for (PrimitiveTypeColumnDefinition innerField : recordColumnDef.getInnerFields()) {
                    innerRecord.put((Object)StringUtils.fromString((String)innerField.getBallerinaFieldName()), Utils.getResult(resultSet, innerField.getResultSetColumnIndex(), innerField, resultParameterProcessor));
                }
                struct.put(recordColumnDef.getBallerinaFieldName(), innerRecord);
                continue;
            }
            if (!(columnDefinition instanceof PrimitiveTypeColumnDefinition)) continue;
            PrimitiveTypeColumnDefinition definition = (PrimitiveTypeColumnDefinition)columnDefinition;
            struct.put(columnDefinition.getBallerinaFieldName(), Utils.getResult(resultSet, definition.getResultSetColumnIndex(), definition, resultParameterProcessor));
        }
        try {
            if (recordConstraint.getName().equals("$stream$anon$constraint$")) {
                return ValueCreator.createRecordValue((RecordType)recordConstraint, (BMapInitialValueEntry[])Utils.getInitialValueEntries(struct));
            }
            return ValueCreator.createRecordValue((Module)recordConstraint.getPackage(), (String)recordConstraint.getName(), struct);
        }
        catch (BError e) {
            if (e.getMessage().equals("{ballerina/lang.map}InherentTypeViolation")) {
                Map errorDetails = (Map)e.getDetails();
                String message = ((BString)errorDetails.get(StringUtils.fromString((String)"message"))).toString();
                throw new TypeMismatchError(message);
            }
            throw e;
        }
    }

    public static Object getResult(ResultSet resultSet, int columnIndex, PrimitiveTypeColumnDefinition columnDefinition, AbstractResultParameterProcessor resultParameterProcessor) throws SQLException, DataError {
        int sqlType = columnDefinition.getSqlType();
        Type ballerinaType = columnDefinition.getBallerinaType();
        switch (sqlType) {
            case 2003: {
                return resultParameterProcessor.processArrayResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                if (ballerinaType.getTag() == 15) {
                    return resultParameterProcessor.processJsonResult(resultSet, columnIndex, sqlType, ballerinaType);
                }
                return resultParameterProcessor.processCharResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case -4: 
            case -3: 
            case -2: {
                if (ballerinaType.getTag() == 5) {
                    return resultParameterProcessor.processCharResult(resultSet, columnIndex, sqlType, ballerinaType, columnDefinition.getSqlTypeName());
                }
                return resultParameterProcessor.processByteArrayResult(resultSet, columnIndex, sqlType, ballerinaType, columnDefinition.getSqlTypeName());
            }
            case 2004: {
                return resultParameterProcessor.processBlobResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case 2005: {
                return resultParameterProcessor.processClobResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case 2011: {
                return resultParameterProcessor.processNClobResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case 91: {
                return resultParameterProcessor.processDateResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case 92: {
                return resultParameterProcessor.processTimeResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case 2013: {
                return resultParameterProcessor.processTimeWithTimezoneResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case 93: {
                return resultParameterProcessor.processTimestampResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case 2014: {
                return resultParameterProcessor.processTimestampWithTimezoneResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case -8: {
                return resultParameterProcessor.processRowIdResult(resultSet, columnIndex, sqlType, ballerinaType, "SQL RowID");
            }
            case -6: 
            case 5: {
                return resultParameterProcessor.processIntResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case -5: 
            case 4: {
                return resultParameterProcessor.processLongResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case 6: 
            case 7: {
                return resultParameterProcessor.processFloatResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case 8: {
                return resultParameterProcessor.processDoubleResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case 2: 
            case 3: {
                return resultParameterProcessor.processDecimalResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case -7: 
            case 16: {
                return resultParameterProcessor.processBooleanResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case 2002: 
            case 2006: {
                return resultParameterProcessor.processStructResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            case 2009: {
                return resultParameterProcessor.processXmlResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
        }
        if (ballerinaType.getTag() == 1) {
            resultParameterProcessor.processIntResult(resultSet, columnIndex, sqlType, ballerinaType);
        } else {
            if (ballerinaType.getTag() == 5 || ballerinaType.getTag() == 29 || ballerinaType.getTag() == 23) {
                return resultParameterProcessor.processCharResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            if (ballerinaType.getTag() == 6) {
                return resultParameterProcessor.processBooleanResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            if (ballerinaType.getTag() == 32 && ((ArrayType)ballerinaType).getElementType().getTag() == 2) {
                return resultParameterProcessor.processByteArrayResult(resultSet, columnIndex, sqlType, ballerinaType, columnDefinition.getSqlTypeName());
            }
            if (ballerinaType.getTag() == 3) {
                return resultParameterProcessor.processDoubleResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            if (ballerinaType.getTag() == 4) {
                return resultParameterProcessor.processDecimalResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            if (ballerinaType.getTag() == 16) {
                return resultParameterProcessor.processXmlResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
            if (ballerinaType.getTag() == 15) {
                return resultParameterProcessor.processJsonResult(resultSet, columnIndex, sqlType, ballerinaType);
            }
        }
        return resultParameterProcessor.processCustomTypeFromResultSet(resultSet, columnIndex, columnDefinition);
    }

    private static boolean isValidFieldConstraint(int sqlType, Type type) {
        if (type.getTag() == 33 && type instanceof UnionType) {
            if (Utils.isEnumType(type)) {
                return true;
            }
            UnionType bUnionType = (UnionType)type;
            for (Type memberType : bUnionType.getMemberTypes()) {
                if (!Utils.isValidFieldConstraint(sqlType, memberType)) continue;
                return true;
            }
            return false;
        }
        return Utils.isValidPrimitiveConstraint(sqlType, type);
    }

    private static Type getDefaultBallerinaType(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_ANYDATA);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2005: 
            case 2011: 
            case 2013: 
            case 2014: {
                return PredefinedTypes.TYPE_STRING;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return PredefinedTypes.TYPE_INT;
            }
            case -7: 
            case 16: {
                return PredefinedTypes.TYPE_BOOLEAN;
            }
            case 2: 
            case 3: {
                return PredefinedTypes.TYPE_DECIMAL;
            }
            case 6: 
            case 7: 
            case 8: {
                return PredefinedTypes.TYPE_FLOAT;
            }
            case -8: 
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_BYTE);
            }
            case 2002: 
            case 2006: {
                return Utils.getDefaultStreamConstraint();
            }
            case 2009: {
                return PredefinedTypes.TYPE_XML;
            }
        }
        return PredefinedTypes.TYPE_ANYDATA;
    }

    private static boolean isValidPrimitiveConstraint(int sqlType, Type type) {
        int tag = type.getTag();
        switch (sqlType) {
            case 2003: {
                return tag == 32;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return tag == 5 || tag == 15;
            }
            case 91: 
            case 92: 
            case 2013: {
                return tag == 5 || tag == 47 || tag == 24 || tag == 1;
            }
            case 93: 
            case 2014: {
                return tag == 5 || tag == 47 || tag == 24 || tag == 34 || tag == 1 || tag == 44;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return tag == 1 || tag == 5;
            }
            case -7: 
            case 16: {
                return tag == 6 || tag == 1 || tag == 5;
            }
            case 2: 
            case 3: {
                return tag == 4 || tag == 1 || tag == 5;
            }
            case 6: 
            case 7: 
            case 8: {
                return tag == 3 || tag == 5;
            }
            case -8: 
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (tag == 32) {
                    int elementTypeTag = ((ArrayType)type).getElementType().getTag();
                    return elementTypeTag == 2;
                }
                return tag == 5 || tag == 48;
            }
            case 2002: 
            case 2006: {
                return tag == 24;
            }
            case 2009: {
                return tag == 16;
            }
        }
        return tag == 29 || tag == 23 || tag == 32 && ((ArrayType)type).getElementType().getTag() == 2 || tag == 5 || tag == 1 || tag == 6 || tag == 16 || tag == 3 || tag == 4 || tag == 15 || tag == 24;
    }

    public static BMap<BString, Object> createDateRecord(Date date) {
        LocalDate dateObj = date.toLocalDate();
        BMap dateMap = ValueCreator.createRecordValue((Module)io.ballerina.stdlib.time.util.ModuleUtils.getModule(), (String)"Date");
        dateMap.put((Object)StringUtils.fromString((String)"year"), (Object)dateObj.getYear());
        dateMap.put((Object)StringUtils.fromString((String)"month"), (Object)dateObj.getMonthValue());
        dateMap.put((Object)StringUtils.fromString((String)"day"), (Object)dateObj.getDayOfMonth());
        return dateMap;
    }

    public static BMap<BString, Object> createTimeRecord(Time time) {
        LocalTime timeObj = time.toLocalTime();
        BMap timeMap = ValueCreator.createRecordValue((Module)io.ballerina.stdlib.time.util.ModuleUtils.getModule(), (String)"TimeOfDay");
        timeMap.put((Object)StringUtils.fromString((String)"hour"), (Object)timeObj.getHour());
        timeMap.put((Object)StringUtils.fromString((String)"minute"), (Object)timeObj.getMinute());
        BigDecimal second = new BigDecimal(timeObj.getSecond());
        second = second.add(new BigDecimal(timeObj.getNano()).divide(io.ballerina.stdlib.time.util.Constants.ANALOG_GIGA, MathContext.DECIMAL128));
        timeMap.put((Object)StringUtils.fromString((String)"second"), (Object)ValueCreator.createDecimalValue((BigDecimal)second));
        return timeMap;
    }

    public static BMap<BString, Object> createTimeWithTimezoneRecord(OffsetTime offsetTime) {
        BMap timeMap = ValueCreator.createRecordValue((Module)io.ballerina.stdlib.time.util.ModuleUtils.getModule(), (String)"TimeOfDay");
        timeMap.put((Object)StringUtils.fromString((String)"hour"), (Object)offsetTime.getHour());
        timeMap.put((Object)StringUtils.fromString((String)"minute"), (Object)offsetTime.getMinute());
        BigDecimal second = new BigDecimal(offsetTime.getSecond());
        second = second.add(new BigDecimal(offsetTime.getNano()).divide(io.ballerina.stdlib.time.util.Constants.ANALOG_GIGA, MathContext.DECIMAL128));
        timeMap.put((Object)StringUtils.fromString((String)"second"), (Object)ValueCreator.createDecimalValue((BigDecimal)second));
        Map zoneInfo = TimeValueHandler.zoneOffsetMapFromString((String)offsetTime.getOffset().toString());
        BMap zoneMap = ValueCreator.createRecordValue((Module)io.ballerina.stdlib.time.util.ModuleUtils.getModule(), (String)"ReadWriteZoneOffset");
        if (zoneInfo.get("hours") != null) {
            zoneMap.put((Object)StringUtils.fromString((String)"hours"), (Object)((Integer)zoneInfo.get("hours")).longValue());
        } else {
            zoneMap.put((Object)StringUtils.fromString((String)"hours"), (Object)0);
        }
        if (zoneInfo.get("minutes") != null) {
            zoneMap.put((Object)StringUtils.fromString((String)"minutes"), (Object)((Integer)zoneInfo.get("minutes")).longValue());
        } else {
            zoneMap.put((Object)StringUtils.fromString((String)"minutes"), (Object)0);
        }
        if (zoneInfo.get("seconds") != null) {
            zoneMap.put((Object)StringUtils.fromString((String)"seconds"), (Object)((Integer)zoneInfo.get("seconds")).longValue());
        }
        zoneMap.freezeDirect();
        timeMap.put((Object)StringUtils.fromString((String)"utcOffset"), (Object)zoneMap);
        timeMap.put((Object)StringUtils.fromString((String)"timeAbbrev"), (Object)StringUtils.fromString((String)offsetTime.getOffset().toString()));
        return timeMap;
    }

    public static BMap<BString, Object> createTimestampRecord(Timestamp timestamp) {
        LocalDateTime dateTimeObj = timestamp.toLocalDateTime();
        BMap civilMap = ValueCreator.createRecordValue((Module)io.ballerina.stdlib.time.util.ModuleUtils.getModule(), (String)"Civil");
        civilMap.put((Object)StringUtils.fromString((String)"year"), (Object)dateTimeObj.getYear());
        civilMap.put((Object)StringUtils.fromString((String)"month"), (Object)dateTimeObj.getMonthValue());
        civilMap.put((Object)StringUtils.fromString((String)"day"), (Object)dateTimeObj.getDayOfMonth());
        civilMap.put((Object)StringUtils.fromString((String)"hour"), (Object)dateTimeObj.getHour());
        civilMap.put((Object)StringUtils.fromString((String)"minute"), (Object)dateTimeObj.getMinute());
        BigDecimal second = new BigDecimal(dateTimeObj.getSecond());
        second = second.add(new BigDecimal(dateTimeObj.getNano()).divide(io.ballerina.stdlib.time.util.Constants.ANALOG_GIGA, MathContext.DECIMAL128));
        civilMap.put((Object)StringUtils.fromString((String)"second"), (Object)ValueCreator.createDecimalValue((BigDecimal)second));
        return civilMap;
    }

    public static BMap<BString, Object> createTimestampWithTimezoneRecord(OffsetDateTime offsetDateTime) {
        BMap civilMap = ValueCreator.createRecordValue((Module)io.ballerina.stdlib.time.util.ModuleUtils.getModule(), (String)"Civil");
        civilMap.put((Object)StringUtils.fromString((String)"year"), (Object)offsetDateTime.getYear());
        civilMap.put((Object)StringUtils.fromString((String)"month"), (Object)offsetDateTime.getMonthValue());
        civilMap.put((Object)StringUtils.fromString((String)"day"), (Object)offsetDateTime.getDayOfMonth());
        civilMap.put((Object)StringUtils.fromString((String)"hour"), (Object)offsetDateTime.getHour());
        civilMap.put((Object)StringUtils.fromString((String)"minute"), (Object)offsetDateTime.getMinute());
        BigDecimal second = new BigDecimal(offsetDateTime.getSecond());
        second = second.add(new BigDecimal(offsetDateTime.getNano()).divide(io.ballerina.stdlib.time.util.Constants.ANALOG_GIGA, MathContext.DECIMAL128));
        civilMap.put((Object)StringUtils.fromString((String)"second"), (Object)ValueCreator.createDecimalValue((BigDecimal)second));
        Map zoneInfo = TimeValueHandler.zoneOffsetMapFromString((String)offsetDateTime.getOffset().toString());
        BMap zoneMap = ValueCreator.createRecordValue((Module)io.ballerina.stdlib.time.util.ModuleUtils.getModule(), (String)"ReadWriteZoneOffset");
        if (zoneInfo.get("hours") != null) {
            zoneMap.put((Object)StringUtils.fromString((String)"hours"), (Object)((Integer)zoneInfo.get("hours")).longValue());
        } else {
            zoneMap.put((Object)StringUtils.fromString((String)"hours"), (Object)0);
        }
        if (zoneInfo.get("minutes") != null) {
            zoneMap.put((Object)StringUtils.fromString((String)"minutes"), (Object)((Integer)zoneInfo.get("minutes")).longValue());
        } else {
            zoneMap.put((Object)StringUtils.fromString((String)"minutes"), (Object)0);
        }
        if (zoneInfo.get("seconds") != null) {
            zoneMap.put((Object)StringUtils.fromString((String)"seconds"), (Object)((Integer)zoneInfo.get("seconds")).longValue());
        }
        zoneMap.freezeDirect();
        civilMap.put((Object)StringUtils.fromString((String)"utcOffset"), (Object)zoneMap);
        civilMap.put((Object)StringUtils.fromString((String)"timeAbbrev"), (Object)StringUtils.fromString((String)offsetDateTime.getOffset().toString()));
        return civilMap;
    }

    public static Object toStringArray(Object[] dataArray, String objectTypeName, Type ballerinaType) throws TypeMismatchError {
        String name = ballerinaType.toString();
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        return Utils.getError(objectTypeName, ballerinaType, "string[]");
    }

    public static Object toBooleanArray(Object[] dataArray, String objectTypeName, Type ballerinaType) throws TypeMismatchError {
        String name = ballerinaType.toString();
        if (name.equalsIgnoreCase("int[]")) {
            return Utils.booleanToIntArray(dataArray);
        }
        if (name.equalsIgnoreCase("boolean[]")) {
            return Utils.createBooleanArray(dataArray);
        }
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        return Utils.getError(objectTypeName, ballerinaType, "boolean[]", "int[]", "string[]");
    }

    public static Object toBitArray(Object[] dataArray, String objectTypeName, Type ballerinaType) throws TypeMismatchError {
        String name = ballerinaType.toString();
        if (name.equalsIgnoreCase("int[]")) {
            return Utils.booleanToIntArray(dataArray);
        }
        if (name.equalsIgnoreCase("boolean[]")) {
            return Utils.createBooleanArray(dataArray);
        }
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        if (name.equalsIgnoreCase("byte[][]")) {
            return Utils.createByteArray(dataArray);
        }
        return Utils.getError(objectTypeName, ballerinaType, "int[]", "boolean[]", "string[]", "byte[][]");
    }

    public static Object booleanToIntArray(Object[] dataArray) {
        BArray intDataArray = ValueCreator.createArrayValue((ArrayType)INT_ARRAY);
        for (int i = 0; i < dataArray.length; ++i) {
            int val = (Boolean)dataArray[i] != false ? 1 : 0;
            intDataArray.add((long)i, (long)val);
        }
        return intDataArray;
    }

    public static Object toIntArray(Object[] dataArray, String objectTypeName, Type ballerinaType) throws TypeMismatchError {
        String name = ballerinaType.toString();
        String className = dataArray[0].getClass().getCanonicalName();
        if (name.equalsIgnoreCase("int[]") && className.equalsIgnoreCase("java.lang.Integer")) {
            return Utils.createIntegerArray(dataArray);
        }
        if (name.equalsIgnoreCase("int[]") && className.equalsIgnoreCase("java.lang.Long")) {
            return Utils.createLongArray(dataArray);
        }
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        return Utils.getError(objectTypeName, ballerinaType, "int[]", "string[]");
    }

    public static Object toRealArray(Object[] dataArray, String objectTypeName, Type ballerinaType) throws TypeMismatchError {
        String name = ballerinaType.toString();
        if (name.equalsIgnoreCase("int[]")) {
            BArray intDataArray = ValueCreator.createArrayValue((ArrayType)INT_ARRAY);
            for (int i = 0; i < dataArray.length; ++i) {
                intDataArray.add((long)i, (long)((Double)dataArray[i]).intValue());
            }
            return intDataArray;
        }
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        if (name.equalsIgnoreCase("decimal[]")) {
            return Utils.toDecimalArray(dataArray);
        }
        if (name.equalsIgnoreCase("float[]")) {
            return Utils.toFloatArray(dataArray);
        }
        return Utils.getError(objectTypeName, ballerinaType, "int[]", "decimal[]", "float[]", "string[]");
    }

    public static Object toDateArray(Object[] dataArray, String objectTypeName, Type ballerinaType) throws TypeMismatchError {
        String name = ballerinaType.toString();
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        if (name.equalsIgnoreCase("time:Date[]")) {
            return Utils.createDateArray(dataArray);
        }
        return Utils.getError(objectTypeName, ballerinaType, "time:Date[]", "string[]");
    }

    public static Object toTimeArray(Object[] dataArray, String objectTypeName, Type ballerinaType) throws TypeMismatchError {
        String name = ballerinaType.toString();
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        if (name.equalsIgnoreCase("time:TimeOfDay[]")) {
            return Utils.createTimeArray(dataArray);
        }
        return Utils.getError(objectTypeName, ballerinaType, "time:TimeOfDay[]", "string[]");
    }

    private static Object toDecimalArray(Object[] dataArray) {
        BArray decimalDataArray = ValueCreator.createArrayValue((ArrayType)DECIMAL_ARRAY);
        for (int i = 0; i < dataArray.length; ++i) {
            Double doubleValue = (Double)dataArray[i];
            decimalDataArray.add((long)i, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(doubleValue)));
        }
        return decimalDataArray;
    }

    private static Object toFloatArray(Object[] dataArray) {
        BArray floatDataArray = ValueCreator.createArrayValue((ArrayType)FLOAT_ARRAY);
        for (int i = 0; i < dataArray.length; ++i) {
            floatDataArray.add((long)i, (double)((Double)dataArray[i]).floatValue());
        }
        return floatDataArray;
    }

    public static Object toTimeWithTimezoneArray(Object[] dataArray, String objectTypeName, Type ballerinaType) throws TypeMismatchError {
        String name = ballerinaType.toString();
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        if (name.equalsIgnoreCase("time:TimeOfDay[]")) {
            return Utils.createOffsetArray(dataArray);
        }
        return Utils.getError(objectTypeName, ballerinaType, "time:TimeOfDay[]", "string[]");
    }

    public static Object toDateTimeArray(Object[] dataArray, String objectTypeName, Type ballerinaType) throws TypeMismatchError {
        String name = ballerinaType.toString();
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        if (name.equalsIgnoreCase("time:Civil[]")) {
            return Utils.createTimestampArray(dataArray);
        }
        return Utils.getError(objectTypeName, ballerinaType, "time:Civil[]", "string[]");
    }

    public static Object toTimestampWithTimezoneArray(Object[] dataArray, String objectTypeName, Type ballerinaType) throws TypeMismatchError {
        String name = ballerinaType.toString();
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        if (name.equalsIgnoreCase("time:Civil[]")) {
            return Utils.createOffsetTimeArray(dataArray);
        }
        return Utils.getError(objectTypeName, ballerinaType, "time:Civil[]", "string[]");
    }

    public static Object toFloatArray(Object[] dataArray, String objectTypeName, Type ballerinaType) throws TypeMismatchError {
        String name = ballerinaType.toString();
        if (name.equalsIgnoreCase("int[]")) {
            BArray intDataArray = ValueCreator.createArrayValue((ArrayType)INT_ARRAY);
            for (int i = 0; i < dataArray.length; ++i) {
                Double doubleValue = (Double)dataArray[i];
                intDataArray.add((long)i, (long)doubleValue.intValue());
            }
            return intDataArray;
        }
        if (name.equalsIgnoreCase("float[]")) {
            return Utils.createFloatArray(dataArray);
        }
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        return Utils.getError(objectTypeName, ballerinaType, "float[]", "int[]", "string[]");
    }

    public static Object toNumericArray(Object[] dataArray, String objectTypeName, Type ballerinaType) throws TypeMismatchError {
        String name = ballerinaType.toString();
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        if (name.equalsIgnoreCase("decimal[]")) {
            return Utils.createBigDecimalArray(dataArray);
        }
        if (name.equalsIgnoreCase("float[]")) {
            return Utils.floatToFloatArray(dataArray);
        }
        if (name.equalsIgnoreCase("int[]")) {
            return Utils.decimalToIntArray(dataArray);
        }
        return Utils.getError(objectTypeName, ballerinaType, "int[]", "decimal[]", "float[]", "string[]");
    }

    public static Object toTimestampArray(Object[] dataArray, String objectTypeName, Type ballerinaType) throws TypeMismatchError {
        String name = ballerinaType.toString();
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        if (name.equalsIgnoreCase("time:Civil[]")) {
            return Utils.createTimestampArray(dataArray);
        }
        return Utils.getError(objectTypeName, ballerinaType, "time:Civil[]", "string[]");
    }

    public static Object toBinaryArray(Object[] dataArray, String objectTypeName, Type ballerinaType) throws TypeMismatchError {
        String name = ballerinaType.toString();
        if (name.equalsIgnoreCase("string[]")) {
            return Utils.createStringArray(dataArray);
        }
        if (name.equalsIgnoreCase("byte[][]")) {
            return Utils.createByteArray(dataArray);
        }
        return Utils.getError(objectTypeName, ballerinaType, "byte[][]", "string[]");
    }

    public static Object floatToFloatArray(Object[] dataArray) {
        BArray floatDataArray = ValueCreator.createArrayValue((ArrayType)FLOAT_ARRAY);
        for (int i = 0; i < dataArray.length; ++i) {
            floatDataArray.add((long)i, (double)((BigDecimal)dataArray[i]).floatValue());
        }
        return floatDataArray;
    }

    public static Object decimalToIntArray(Object[] dataArray) {
        BArray intDataArray = ValueCreator.createArrayValue((ArrayType)INT_ARRAY);
        for (int i = 0; i < dataArray.length; ++i) {
            intDataArray.add((long)i, (long)((BigDecimal)dataArray[i]).intValue());
        }
        return intDataArray;
    }

    public static BArray createStringArray(Object[] dataArray) {
        BArray stringDataArray = ValueCreator.createArrayValue((ArrayType)STRING_ARRAY);
        for (int i = 0; i < dataArray.length; ++i) {
            if (dataArray[i] == null) {
                stringDataArray.add((long)i, StringUtils.fromString(null));
                continue;
            }
            stringDataArray.add((long)i, StringUtils.fromString((String)dataArray[i].toString()));
        }
        return stringDataArray;
    }

    public static BArray createBooleanArray(Object[] dataArray) {
        BArray boolDataArray = ValueCreator.createArrayValue((ArrayType)BOOLEAN_ARRAY);
        for (int i = 0; i < dataArray.length; ++i) {
            boolDataArray.add((long)i, ((Boolean)dataArray[i]).booleanValue());
        }
        return boolDataArray;
    }

    public static BArray createShortArray(Object[] dataArray) {
        BArray shortDataArray = ValueCreator.createArrayValue((ArrayType)INT_ARRAY);
        for (int i = 0; i < dataArray.length; ++i) {
            shortDataArray.add((long)i, (long)((Short)dataArray[i]).intValue());
        }
        return shortDataArray;
    }

    public static BArray createIntegerArray(Object[] dataArray) {
        BArray intDataArray = ValueCreator.createArrayValue((ArrayType)INT_ARRAY);
        for (int i = 0; i < dataArray.length; ++i) {
            intDataArray.add((long)i, (long)((Integer)dataArray[i]).intValue());
        }
        return intDataArray;
    }

    public static BArray createLongArray(Object[] dataArray) {
        BArray longDataArray = ValueCreator.createArrayValue((ArrayType)INT_ARRAY);
        for (int i = 0; i < dataArray.length; ++i) {
            longDataArray.add((long)i, ((Long)dataArray[i]).longValue());
        }
        return longDataArray;
    }

    public static BArray createFloatArray(Object[] dataArray) {
        BArray floatDataArray = ValueCreator.createArrayValue((ArrayType)FLOAT_ARRAY);
        for (int i = 0; i < dataArray.length; ++i) {
            floatDataArray.add((long)i, (double)((Float)dataArray[i]).floatValue());
        }
        return floatDataArray;
    }

    public static BArray createDoubleArray(Object[] dataArray) {
        BArray doubleDataArray = ValueCreator.createArrayValue((ArrayType)FLOAT_ARRAY);
        for (int i = 0; i < dataArray.length; ++i) {
            doubleDataArray.add((long)i, ((Double)dataArray[i]).doubleValue());
        }
        return doubleDataArray;
    }

    public static BArray createBigDecimalArray(Object[] dataArray) {
        BArray decimalDataArray = ValueCreator.createArrayValue((ArrayType)DECIMAL_ARRAY);
        for (int i = 0; i < dataArray.length; ++i) {
            decimalDataArray.add((long)i, (Object)ValueCreator.createDecimalValue((BigDecimal)((BigDecimal)dataArray[i])));
        }
        return decimalDataArray;
    }

    public static BArray createByteArray(Object[] dataArray) {
        BArray byteDataArray = ValueCreator.createArrayValue((ArrayType)BYTE_ARRAY_TYPE);
        for (int i = 0; i < dataArray.length; ++i) {
            byteDataArray.add((long)i, (Object)ValueCreator.createArrayValue((byte[])((byte[])dataArray[i])));
        }
        return byteDataArray;
    }

    public static BArray createDateArray(Object[] dataArray) {
        BArray mapDataArray = ValueCreator.createArrayValue((ArrayType)DATE_ARRAY_TYPE);
        for (int i = 0; i < dataArray.length; ++i) {
            BMap<BString, Object> dateMap = Utils.createDateRecord((Date)dataArray[i]);
            mapDataArray.add((long)i, dateMap);
        }
        mapDataArray.freezeDirect();
        return mapDataArray;
    }

    public static BArray createTimestampArray(Object[] dataArray) {
        BArray mapDataArray = ValueCreator.createArrayValue((ArrayType)CIVIL_ARRAY_TYPE);
        for (int i = 0; i < dataArray.length; ++i) {
            BMap<BString, Object> civilMap = Utils.createTimestampRecord((Timestamp)dataArray[i]);
            mapDataArray.add((long)i, civilMap);
        }
        mapDataArray.freezeDirect();
        return mapDataArray;
    }

    public static BArray createTimeArray(Object[] dataArray) {
        BArray mapDataArray = ValueCreator.createArrayValue((ArrayType)TIME_ARRAY_TYPE);
        for (int i = 0; i < dataArray.length; ++i) {
            BMap<BString, Object> timeMap = Utils.createTimeRecord((Time)dataArray[i]);
            mapDataArray.add((long)i, timeMap);
        }
        mapDataArray.freezeDirect();
        return mapDataArray;
    }

    public static BArray createOffsetArray(Object[] dataArray) {
        BArray mapTimeArray = ValueCreator.createArrayValue((ArrayType)TIME_ARRAY_TYPE);
        for (int i = 0; i < dataArray.length; ++i) {
            BMap<BString, Object> civilMap = Utils.createTimeWithTimezoneRecord((OffsetTime)dataArray[i]);
            mapTimeArray.add((long)i, civilMap);
        }
        mapTimeArray.freezeDirect();
        return mapTimeArray;
    }

    public static BArray createOffsetTimeArray(Object[] dataArray) {
        BArray mapDateTimeArray = ValueCreator.createArrayValue((ArrayType)CIVIL_ARRAY_TYPE);
        for (int i = 0; i < dataArray.length; ++i) {
            BMap<BString, Object> civilMap = Utils.createTimestampWithTimezoneRecord((OffsetDateTime)dataArray[i]);
            mapDateTimeArray.add((long)i, civilMap);
        }
        mapDateTimeArray.freezeDirect();
        return mapDateTimeArray;
    }

    private static BError getError(String sqlTypeName, Type ballerinaType, String ... expectedType) throws TypeMismatchError {
        if (expectedType.length == 1) {
            throw new TypeMismatchError(sqlTypeName.replace("ArrayOutParameter", " Array"), Utils.getBTypeName(ballerinaType), expectedType[0]);
        }
        throw new TypeMismatchError(sqlTypeName.replace("ArrayOutParameter", " Array"), Utils.getBTypeName(ballerinaType), expectedType);
    }

    public static String getBTypeName(Type ballerinaType) {
        if (ballerinaType.getName() == null || ballerinaType.getName().equals("")) {
            return ballerinaType.toString();
        }
        return ballerinaType.getName();
    }

    public static boolean isSupportedRecordType(Type ballerinaType) {
        return KNOWN_RECORD_TYPES.contains(Utils.getBTypeName(ballerinaType));
    }

    public static boolean isEnumType(Type ballerinaType) {
        return ballerinaType instanceof UnionType && ((UnionType)ballerinaType).getMemberTypes().stream().allMatch(memberType -> memberType.getTag() == 46 || memberType.getTag() == 14);
    }

    private static BMapInitialValueEntry[] getInitialValueEntries(Map<String, Object> struct) {
        BMapInitialValueEntry[] entries = new BMapInitialValueEntry[struct.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : struct.entrySet()) {
            entries[i] = ValueCreator.createKeyFieldEntry((Object)StringUtils.fromString((String)entry.getKey()), (Object)entry.getValue());
            ++i;
        }
        return entries;
    }

    public static SQLException getRootSQLException(SQLException e) {
        SQLException rootSQLException = e;
        for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
            if (!(t instanceof SQLException)) continue;
            rootSQLException = (SQLException)t;
        }
        return rootSQLException;
    }

    public static void disableHikariLogs() {
        Logger.getLogger("").setLevel(Level.OFF);
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> names = logManager.getLoggerNames();
        for (String name : Collections.list(names)) {
            if (!name.contains("hikari")) continue;
            LogManager.getLogManager().getLogger(name).setLevel(Level.OFF);
        }
    }

    public static BStream getErrorStream(Object recordType, BError errorValue) {
        return ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)((BTypedesc)recordType).getDescribingType(), (Type)PredefinedTypes.TYPE_NULL), (BObject)Utils.createRecordIterator(errorValue));
    }

    private static BObject createRecordIterator(BError errorValue) {
        return ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"ResultIterator", (Object[])new Object[]{errorValue, null});
    }
}

