/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.flowmodelgenerator.core.DiagnosticHandler;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.lsp4j.TextEdit;

public class ConfigVariablesManager {
    public static final String DEFAULTABLE = "defaultable";
    private final Gson gson = new Gson();

    public JsonElement get(Map<Document, SemanticModel> documentSemanticModelMap) {
        ArrayList<FlowNode> configVariables = new ArrayList<FlowNode>();
        for (Map.Entry<Document, SemanticModel> entry : documentSemanticModelMap.entrySet()) {
            SyntaxTree syntaxTree = entry.getKey().syntaxTree();
            ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
            SemanticModel semanticModel = entry.getValue();
            for (Node node : modulePartNode.children()) {
                ModuleVariableDeclarationNode modVarDeclarationNode;
                if (node.kind() != SyntaxKind.MODULE_VAR_DECL || !ConfigVariablesManager.hasConfigurableQualifier(modVarDeclarationNode = (ModuleVariableDeclarationNode)node)) continue;
                configVariables.add(this.genConfigVariable(modVarDeclarationNode, semanticModel));
            }
        }
        return this.gson.toJsonTree(configVariables);
    }

    private static boolean hasConfigurableQualifier(ModuleVariableDeclarationNode modVarDeclarationNode) {
        return modVarDeclarationNode.qualifiers().stream().anyMatch(q -> q.text().equals(Qualifier.CONFIGURABLE.getValue()));
    }

    private FlowNode genConfigVariable(ModuleVariableDeclarationNode modVarDeclNode, SemanticModel semanticModel) {
        DiagnosticHandler diagnosticHandler = new DiagnosticHandler(semanticModel);
        NodeBuilder nodeBuilder = NodeBuilder.getNodeFromKind(NodeKind.CONFIG_VARIABLE).semanticModel(semanticModel).diagnosticHandler(diagnosticHandler).defaultModuleName(null);
        diagnosticHandler.handle(nodeBuilder, modVarDeclNode.lineRange(), false);
        TypedBindingPatternNode typedBindingPattern = modVarDeclNode.typedBindingPattern();
        return ((NodeBuilder)((NodeBuilder)((NodeBuilder)nodeBuilder.metadata().label("Config variables").stepOut()).codedata().node(NodeKind.CONFIG_VARIABLE).lineRange(modVarDeclNode.lineRange()).stepOut()).properties().type((Node)typedBindingPattern.typeDescriptor(), true).defaultableName(typedBindingPattern.bindingPattern().toSourceCode().trim()).defaultableVariable(modVarDeclNode.initializer().orElse(null)).stepOut()).build();
    }

    public JsonElement update(Document document, Path configFile, FlowNode configVariable) {
        LineRange lineRange = configVariable.codedata().lineRange();
        Map<String, Property> properties = configVariable.properties();
        String configStatement = this.constructConfigStatement(properties);
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        if (this.isNew(configVariable) || lineRange == null) {
            SyntaxTree syntaxTree = document.syntaxTree();
            ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
            LinePosition startPos = LinePosition.from((int)(modulePartNode.lineRange().endLine().line() + 1), (int)0);
            textEdits.add(new TextEdit(CommonUtils.toRange((LinePosition)startPos), configStatement));
        } else {
            textEdits.add(new TextEdit(CommonUtils.toRange((LineRange)lineRange), configStatement));
        }
        HashMap<Path, ArrayList<TextEdit>> textEditsMap = new HashMap<Path, ArrayList<TextEdit>>();
        textEditsMap.put(configFile, textEdits);
        return this.gson.toJsonTree(textEditsMap);
    }

    private String constructConfigStatement(Map<String, Property> properties) {
        String value = properties.get(DEFAULTABLE).toSourceCode();
        return String.format("configurable %s %s = %s;", properties.get("type").toSourceCode(), properties.get("variable").toSourceCode(), value.isEmpty() ? "?" : value);
    }

    private boolean isNew(FlowNode configVariable) {
        return configVariable.codedata().isNew() != null && configVariable.codedata().isNew() != false;
    }
}

