/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextDocument;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;

public class CopilotContextGenerator {
    private final WorkspaceManager workspaceManager;
    private final Path filePath;
    private final LinePosition position;
    private String prefix;
    private String suffix;
    private final Set<String> imports;
    private static final int INDENT_SPACES = 4;

    public CopilotContextGenerator(WorkspaceManager workspaceManager, Path filePath, LinePosition position) {
        this.workspaceManager = workspaceManager;
        this.filePath = filePath;
        this.position = position;
        this.imports = new LinkedHashSet<String>();
    }

    public void generate() {
        try {
            this.workspaceManager.loadProject(this.filePath);
            Document document = (Document)this.workspaceManager.document(this.filePath).orElseThrow();
            TextDocument textDocument = document.textDocument();
            int textPosition = textDocument.textPositionFrom(this.position);
            char[] charArray = textDocument.toCharArray();
            ModulePartNode rootNode = (ModulePartNode)document.syntaxTree().rootNode();
            Token token = rootNode.findToken(textPosition);
            int start = this.processImports(document);
            Path projectPath = this.workspaceManager.projectRoot(this.filePath);
            this.suffix = new String(charArray, textPosition, charArray.length - textPosition);
            this.prefix = String.join((CharSequence)System.lineSeparator(), this.imports) + this.getDocumentContent(projectPath, "data_mappings.bal") + this.getDocumentContent(projectPath, "types.bal") + this.getDocumentContent(projectPath, "connections.bal") + new String(charArray, start, textPosition - start) + this.generatePrefixTrailingSpace(token, textDocument);
        }
        catch (EventSyncException | WorkspaceDocumentException e) {
            throw new RuntimeException(e);
        }
    }

    private String getDocumentContent(Path projectPath, String fileName) {
        try {
            Document document = (Document)this.workspaceManager.document(projectPath.resolve(fileName)).orElseThrow();
            TextDocument textDocument = document.textDocument();
            int start = this.processImports(document);
            char[] charArray = textDocument.toCharArray();
            return new String(charArray, start, charArray.length - start);
        }
        catch (Throwable ignored) {
            return "";
        }
    }

    private int processImports(Document document) {
        ModulePartNode rootNode = (ModulePartNode)document.syntaxTree().rootNode();
        NodeList imports = rootNode.imports();
        imports.forEach(importDeclarationNode -> this.imports.add(importDeclarationNode.toSourceCode().strip()));
        TextDocument textDocument = document.textDocument();
        return imports.isEmpty() ? 0 : textDocument.textPositionFrom(((ImportDeclarationNode)imports.get(imports.size() - 1)).lineRange().endLine());
    }

    private String generatePrefixTrailingSpace(Token token, TextDocument textDocument) {
        String indent = switch (token.kind()) {
            case SyntaxKind.CLOSE_BRACE_TOKEN -> {
                int offset = token.lineRange().startLine().offset();
                yield " ".repeat(offset);
            }
            case SyntaxKind.SEMICOLON_TOKEN -> {
                NonTerminalNode parent;
                for (parent = token.parent(); !(parent instanceof StatementNode) && parent != null; parent = parent.parent()) {
                }
                if (parent == null) {
                    yield "";
                }
                int offset = parent.lineRange().startLine().offset();
                yield " ".repeat(Math.max(0, offset));
            }
            case SyntaxKind.OPEN_BRACE_TOKEN -> {
                String line = textDocument.line(token.lineRange().startLine().line()).text();
                int offset = -1;
                for (int i = 0; i < line.length(); ++i) {
                    if (Character.isWhitespace(line.charAt(i))) continue;
                    offset = i;
                    break;
                }
                yield " ".repeat(offset + 4);
            }
            default -> "";
        };
        return System.lineSeparator() + indent;
    }

    public String prefix() {
        return this.prefix;
    }

    public String suffix() {
        return this.suffix;
    }
}

