/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ClauseNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FromClauseNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.SelectClauseNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.DefaultValueGeneratorUtil;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.projects.Document;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextRange;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.diagramutil.connector.models.connector.TypeInfo;
import org.ballerinalang.diagramutil.connector.models.connector.types.ArrayType;
import org.ballerinalang.diagramutil.connector.models.connector.types.PrimitiveType;
import org.ballerinalang.diagramutil.connector.models.connector.types.RecordType;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class DataMapManager {
    private final WorkspaceManager workspaceManager;
    private final Document document;
    private final Gson gson;
    private static final Type mt = new TypeToken<List<Mapping>>(){}.getType();

    public DataMapManager(WorkspaceManager workspaceManager, Document document) {
        this.workspaceManager = workspaceManager;
        this.document = document;
        this.gson = new Gson();
    }

    public JsonElement getTypes(JsonElement node, String propertyKey, SemanticModel semanticModel) {
        FlowNode flowNode = (FlowNode)this.gson.fromJson(node, FlowNode.class);
        Codedata codedata = flowNode.codedata();
        NodeKind nodeKind = codedata.node();
        if (nodeKind == NodeKind.VARIABLE) {
            String dataType = flowNode.properties().get("type").toSourceCode();
            Optional<Symbol> varSymbol = this.getSymbol(semanticModel.moduleSymbols(), dataType);
            if (varSymbol.isEmpty()) {
                throw new IllegalStateException("Symbol cannot be found for : " + dataType);
            }
            org.ballerinalang.diagramutil.connector.models.connector.Type t = org.ballerinalang.diagramutil.connector.models.connector.Type.fromSemanticSymbol((Symbol)varSymbol.get());
            if (t == null) {
                throw new IllegalStateException("Type cannot be found for : " + propertyKey);
            }
            return this.gson.toJsonTree((Object)t);
        }
        if (nodeKind == NodeKind.FUNCTION_CALL) {
            Optional<Symbol> varSymbol = this.getSymbol(semanticModel.moduleSymbols(), codedata.symbol());
            if (varSymbol.isEmpty() || varSymbol.get().kind() != SymbolKind.FUNCTION) {
                throw new IllegalStateException("Symbol cannot be found for : " + codedata.symbol());
            }
            Optional optParams = ((FunctionSymbol)varSymbol.get()).typeDescriptor().params();
            if (optParams.isEmpty()) {
                return new JsonObject();
            }
            Optional<org.ballerinalang.diagramutil.connector.models.connector.Type> type = optParams.flatMap(params -> params.parallelStream().filter(param -> param.nameEquals(propertyKey)).findAny()).map(org.ballerinalang.diagramutil.connector.models.connector.Type::fromSemanticSymbol);
            if (type.isEmpty()) {
                throw new IllegalStateException("Type cannot be found for : " + propertyKey);
            }
            return this.gson.toJsonTree((Object)type.get());
        }
        return new JsonObject();
    }

    private Optional<Symbol> getSymbol(List<Symbol> symbols, String name) {
        return symbols.parallelStream().filter(symbol -> symbol.nameEquals(name)).findAny();
    }

    public JsonElement getMappings(JsonElement node, LinePosition position, String propertyKey, Path filePath, String targetField, Project project) {
        org.ballerinalang.diagramutil.connector.models.connector.Type type;
        FlowNode flowNode = (FlowNode)this.gson.fromJson(node, FlowNode.class);
        SourceModification modification = flowNode.codedata().node() == NodeKind.NEW_CONNECTION ? this.applyConnection(flowNode, project, filePath) : this.applyNode(flowNode, project, filePath, position);
        SemanticModel newSemanticModel = modification.semanticModel();
        List<MappingPort> inputPorts = this.getInputPorts(newSemanticModel, modification.document(), position);
        inputPorts.sort(Comparator.comparing(mt -> mt.id));
        TargetNode targetNode = this.getTargetNode(modification.stNode(), targetField, flowNode.codedata().node(), propertyKey, newSemanticModel);
        if (targetNode == null) {
            return null;
        }
        ExpressionNode expressionNode = targetNode.expressionNode();
        if (expressionNode != null && targetNode.expressionNode().kind() == SyntaxKind.QUERY_EXPRESSION) {
            FromClauseNode fromClauseNode = ((QueryExpressionNode)targetNode.expressionNode()).queryPipeline().fromClause();
            Optional typeSymbol = newSemanticModel.typeOf((Node)fromClauseNode.expression());
            if (typeSymbol.isPresent() && ((TypeSymbol)typeSymbol.get()).typeKind() == TypeDescKind.ARRAY) {
                String fromClauseVar = fromClauseNode.typedBindingPattern().bindingPattern().toSourceCode().trim();
                inputPorts.add(this.getMappingPort(fromClauseVar, fromClauseVar, org.ballerinalang.diagramutil.connector.models.connector.Type.fromSemanticSymbol((Symbol)((ArrayTypeSymbol)typeSymbol.get()).memberTypeDescriptor())));
            }
            type = org.ballerinalang.diagramutil.connector.models.connector.Type.fromSemanticSymbol((Symbol)((ArrayTypeSymbol)targetNode.typeSymbol()).memberTypeDescriptor());
        } else {
            type = org.ballerinalang.diagramutil.connector.models.connector.Type.fromSemanticSymbol((Symbol)targetNode.typeSymbol());
        }
        String name = targetNode.name();
        MappingPort outputPort = this.getMappingPort(name, name, type);
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        if (expressionNode != null) {
            TypeDescKind typeDescKind = CommonUtils.getRawType((TypeSymbol)targetNode.typeSymbol()).typeKind();
            if (typeDescKind == TypeDescKind.RECORD) {
                this.generateRecordVariableDataMapping(expressionNode, mappings, name, newSemanticModel);
            } else if (typeDescKind == TypeDescKind.ARRAY) {
                this.generateArrayVariableDataMapping(expressionNode, mappings, name, newSemanticModel);
            }
        }
        return this.gson.toJsonTree((Object)new Model(inputPorts, outputPort, mappings));
    }

    private TargetNode getTargetNode(Node parentNode, String targetField, NodeKind nodeKind, String propertyKey, SemanticModel semanticModel) {
        TypedBindingPatternNode typedBindingPattern;
        Optional optInitializer;
        SyntaxKind kind = parentNode.kind();
        if (kind == SyntaxKind.LOCAL_VAR_DECL) {
            VariableDeclarationNode varDeclNode = (VariableDeclarationNode)parentNode;
            optInitializer = varDeclNode.initializer();
            typedBindingPattern = varDeclNode.typedBindingPattern();
        } else if (kind == SyntaxKind.MODULE_VAR_DECL) {
            ModuleVariableDeclarationNode moduleVarDeclNode = (ModuleVariableDeclarationNode)parentNode;
            optInitializer = moduleVarDeclNode.initializer();
            typedBindingPattern = moduleVarDeclNode.typedBindingPattern();
        } else {
            return null;
        }
        Optional optSymbol = semanticModel.symbol(parentNode);
        if (optSymbol.isEmpty()) {
            return null;
        }
        Symbol symbol = (Symbol)optSymbol.get();
        if (symbol.kind() != SymbolKind.VARIABLE) {
            return null;
        }
        VariableSymbol variableSymbol = (VariableSymbol)symbol;
        TypeSymbol typeSymbol = variableSymbol.typeDescriptor();
        if (optInitializer.isEmpty()) {
            return new TargetNode(typeSymbol, (String)variableSymbol.getName().get(), null);
        }
        ExpressionNode initializer = (ExpressionNode)optInitializer.get();
        if (initializer.kind() == SyntaxKind.FUNCTION_CALL && nodeKind == NodeKind.FUNCTION_CALL) {
            FunctionCallExpressionNode funcCallExprNode = (FunctionCallExpressionNode)initializer;
            Optional optFunctionSymbol = semanticModel.symbol((Node)funcCallExprNode);
            if (optFunctionSymbol.isEmpty() || ((Symbol)optFunctionSymbol.get()).kind() != SymbolKind.FUNCTION) {
                return null;
            }
            FunctionSymbol functionSymbol = (FunctionSymbol)optFunctionSymbol.get();
            Optional optParams = functionSymbol.typeDescriptor().params();
            if (optParams.isEmpty()) {
                return null;
            }
            return this.getTargetNodeForFunctionParam((List)optParams.get(), propertyKey, (SeparatedNodeList<FunctionArgumentNode>)funcCallExprNode.arguments());
        }
        if (initializer.kind() == SyntaxKind.CHECK_EXPRESSION && nodeKind == NodeKind.NEW_CONNECTION) {
            ExpressionNode expressionNode = ((CheckExpressionNode)initializer).expression();
            if (expressionNode.kind() != SyntaxKind.IMPLICIT_NEW_EXPRESSION) {
                return null;
            }
            TypeSymbol rawType = CommonUtils.getRawType((TypeSymbol)typeSymbol);
            if (rawType.kind() != SymbolKind.CLASS) {
                return null;
            }
            ClassSymbol classSymbol = (ClassSymbol)rawType;
            Optional optInitMethodSymbol = classSymbol.initMethod();
            if (optInitMethodSymbol.isEmpty()) {
                return null;
            }
            MethodSymbol initMethodSymbol = (MethodSymbol)optInitMethodSymbol.get();
            Optional optParams = initMethodSymbol.typeDescriptor().params();
            if (optParams.isEmpty()) {
                return null;
            }
            ImplicitNewExpressionNode implicitNewExprNode = (ImplicitNewExpressionNode)expressionNode;
            Optional optParenthesizedArgList = implicitNewExprNode.parenthesizedArgList();
            if (optParenthesizedArgList.isEmpty()) {
                return new TargetNode(((ParameterSymbol)((List)optParams.get()).getFirst()).typeDescriptor(), propertyKey, null);
            }
            return this.getTargetNodeForFunctionParam((List)optParams.get(), propertyKey, (SeparatedNodeList<FunctionArgumentNode>)((ParenthesizedArgList)optParenthesizedArgList.get()).arguments());
        }
        if (targetField == null) {
            return new TargetNode(typeSymbol, (String)variableSymbol.getName().get(), initializer);
        }
        if (initializer.kind() == SyntaxKind.QUERY_EXPRESSION) {
            if (typeSymbol.typeKind() != TypeDescKind.ARRAY) {
                return null;
            }
            typeSymbol = ((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor();
            initializer = ((SelectClauseNode)((QueryExpressionNode)initializer).resultClause()).expression();
        }
        if (initializer.kind() != SyntaxKind.MAPPING_CONSTRUCTOR) {
            return null;
        }
        if ((typeSymbol = CommonUtils.getRawType((TypeSymbol)typeSymbol)).typeKind() != TypeDescKind.RECORD) {
            return null;
        }
        RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)typeSymbol;
        MappingConstructorExpressionNode mappingCtrExprNode = (MappingConstructorExpressionNode)initializer;
        String[] splits = targetField.split("\\.");
        if (!splits[0].equals(typedBindingPattern.bindingPattern().toSourceCode().trim())) {
            return null;
        }
        MappingConstructorExpressionNode expr = mappingCtrExprNode;
        MappingConstructorExpressionNode lastExpr = null;
        for (int i = 1; i < splits.length; ++i) {
            SpecificFieldNode specificFieldNode;
            Optional optValueExpr;
            String split = splits[i];
            if (expr.kind() != SyntaxKind.MAPPING_CONSTRUCTOR) {
                return null;
            }
            Map<String, MappingFieldNode> mappingFieldsMap = this.convertMappingFieldsToMap(expr);
            MappingFieldNode mappingFieldNode = mappingFieldsMap.get(split);
            if (mappingFieldNode == null || mappingFieldNode.kind() != SyntaxKind.SPECIFIC_FIELD || (optValueExpr = (specificFieldNode = (SpecificFieldNode)mappingFieldNode).valueExpr()).isEmpty()) break;
            expr = (ExpressionNode)optValueExpr.get();
            if (i != splits.length - 1) continue;
            lastExpr = expr;
        }
        RecordTypeSymbol ts = recordTypeSymbol;
        RecordTypeSymbol lastTypeSymbol = null;
        for (int i = 1; i < splits.length; ++i) {
            RecordTypeSymbol rts;
            RecordFieldSymbol recordFieldSymbol;
            String split = splits[i];
            if (ts.typeKind() != TypeDescKind.RECORD || (recordFieldSymbol = (RecordFieldSymbol)(rts = ts).fieldDescriptors().get(split)) == null) break;
            ts = CommonUtils.getRawType((TypeSymbol)recordFieldSymbol.typeDescriptor());
            if (i != splits.length - 1) continue;
            lastTypeSymbol = ts;
        }
        if (lastTypeSymbol != null && lastTypeSymbol.typeKind() == TypeDescKind.ARRAY && lastExpr != null && lastExpr.kind() == SyntaxKind.QUERY_EXPRESSION) {
            return new TargetNode((TypeSymbol)lastTypeSymbol, splits[splits.length - 1], (ExpressionNode)lastExpr);
        }
        return null;
    }

    private TargetNode getTargetNodeForFunctionParam(List<ParameterSymbol> paramSymbols, String propertyKey, SeparatedNodeList<FunctionArgumentNode> args) {
        for (int i = 0; i < paramSymbols.size(); ++i) {
            ParameterSymbol paramSymbol = paramSymbols.get(i);
            if (!((String)paramSymbol.getName().get()).equals(propertyKey)) continue;
            return new TargetNode(paramSymbol.typeDescriptor(), propertyKey, this.getArgForParam(propertyKey, i, args));
        }
        throw new IllegalStateException("Parameter is not available for : " + propertyKey);
    }

    private ExpressionNode getArgForParam(String param, int index, SeparatedNodeList<FunctionArgumentNode> args) {
        for (int i = 0; i < args.size(); ++i) {
            NamedArgumentNode namedArgumentNode;
            FunctionArgumentNode arg = (FunctionArgumentNode)args.get(i);
            SyntaxKind kind = arg.kind();
            if (kind == SyntaxKind.POSITIONAL_ARG) {
                if (index != i) continue;
                return ((PositionalArgumentNode)arg).expression();
            }
            if (kind != SyntaxKind.NAMED_ARG || !(namedArgumentNode = (NamedArgumentNode)arg).argumentName().toSourceCode().equals(param)) continue;
            return namedArgumentNode.expression();
        }
        return null;
    }

    private Map<String, MappingFieldNode> convertMappingFieldsToMap(MappingConstructorExpressionNode mappingCtrExprNode) {
        HashMap<String, MappingFieldNode> mappingFieldNodeMap = new HashMap<String, MappingFieldNode>();
        mappingCtrExprNode.fields().forEach(mappingFieldNode -> {
            if (mappingFieldNode.kind() == SyntaxKind.SPECIFIC_FIELD) {
                SpecificFieldNode specificFieldNode = (SpecificFieldNode)mappingFieldNode;
                mappingFieldNodeMap.put(specificFieldNode.fieldName().toSourceCode().trim(), (MappingFieldNode)specificFieldNode);
            }
        });
        return mappingFieldNodeMap;
    }

    private void generateRecordVariableDataMapping(ExpressionNode expressionNode, List<Mapping> mappings, String name, SemanticModel semanticModel) {
        SyntaxKind exprKind = expressionNode.kind();
        if (exprKind == SyntaxKind.MAPPING_CONSTRUCTOR) {
            this.genMapping((MappingConstructorExpressionNode)expressionNode, mappings, name, semanticModel);
        } else {
            ArrayList<String> inputs = new ArrayList<String>();
            this.genInputs((Node)expressionNode, inputs);
            Mapping mapping = new Mapping(name, inputs, expressionNode.toSourceCode(), this.getDiagnostics(expressionNode.lineRange(), semanticModel), new ArrayList<MappingElements>());
            mappings.add(mapping);
        }
    }

    private void generateArrayVariableDataMapping(ExpressionNode expressionNode, List<Mapping> mappings, String name, SemanticModel semanticModel) {
        SyntaxKind exprKind = expressionNode.kind();
        if (exprKind == SyntaxKind.LIST_CONSTRUCTOR) {
            this.genMapping((ListConstructorExpressionNode)expressionNode, mappings, name, semanticModel);
        } else if (exprKind == SyntaxKind.QUERY_EXPRESSION) {
            this.genMapping((QueryExpressionNode)expressionNode, mappings, name, semanticModel);
        } else {
            this.genMapping((Node)expressionNode, name, mappings, semanticModel);
        }
    }

    private void genMapping(MappingConstructorExpressionNode mappingCtrExpr, List<Mapping> mappings, String name, SemanticModel semanticModel) {
        for (MappingFieldNode field : mappingCtrExpr.fields()) {
            SpecificFieldNode f;
            Optional optFieldExpr;
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD || (optFieldExpr = (f = (SpecificFieldNode)field).valueExpr()).isEmpty()) continue;
            ExpressionNode fieldExpr = (ExpressionNode)optFieldExpr.get();
            SyntaxKind kind = fieldExpr.kind();
            if (kind == SyntaxKind.MAPPING_CONSTRUCTOR) {
                this.genMapping((MappingConstructorExpressionNode)fieldExpr, mappings, name + "." + f.fieldName().toSourceCode().trim(), semanticModel);
                continue;
            }
            if (kind == SyntaxKind.LIST_CONSTRUCTOR) {
                this.genMapping((ListConstructorExpressionNode)fieldExpr, mappings, name + "." + f.fieldName().toSourceCode().trim(), semanticModel);
                continue;
            }
            this.genMapping((Node)fieldExpr, name + "." + f.fieldName().toSourceCode().trim(), mappings, semanticModel);
        }
    }

    private void genMapping(ListConstructorExpressionNode listCtrExpr, List<Mapping> mappings, String name, SemanticModel semanticModel) {
        SeparatedNodeList expressions = listCtrExpr.expressions();
        int size = expressions.size();
        ArrayList<MappingElements> mappingElements = new ArrayList<MappingElements>();
        for (int i = 0; i < size; ++i) {
            ArrayList<Mapping> elements = new ArrayList<Mapping>();
            Node expr = expressions.get(i);
            if (expr.kind() == SyntaxKind.MAPPING_CONSTRUCTOR) {
                this.genMapping((MappingConstructorExpressionNode)expr, elements, name + "." + i, semanticModel);
            } else if (expr.kind() == SyntaxKind.LIST_CONSTRUCTOR) {
                this.genMapping((ListConstructorExpressionNode)expr, elements, name + "." + i, semanticModel);
            } else {
                this.genMapping(expr, name + "." + i, elements, semanticModel);
            }
            mappingElements.add(new MappingElements(elements));
        }
        Mapping mapping = new Mapping(name, new ArrayList<String>(), listCtrExpr.toSourceCode(), this.getDiagnostics(listCtrExpr.lineRange(), semanticModel), mappingElements);
        mappings.add(mapping);
    }

    private void genMapping(Node expr, String name, List<Mapping> elements, SemanticModel semanticModel) {
        ArrayList<String> inputs = new ArrayList<String>();
        this.genInputs(expr, inputs);
        Mapping mapping = new Mapping(name, inputs, expr.toSourceCode(), this.getDiagnostics(expr.lineRange(), semanticModel), new ArrayList<MappingElements>());
        elements.add(mapping);
    }

    private void genMapping(QueryExpressionNode queryExpr, List<Mapping> mappings, String name, SemanticModel semanticModel) {
        ClauseNode clauseNode = queryExpr.resultClause();
        if (clauseNode.kind() != SyntaxKind.SELECT_CLAUSE) {
            return;
        }
        SelectClauseNode selectClauseNode = (SelectClauseNode)clauseNode;
        ExpressionNode expr = selectClauseNode.expression();
        if (expr.kind() == SyntaxKind.MAPPING_CONSTRUCTOR) {
            this.genMapping((MappingConstructorExpressionNode)expr, mappings, name, semanticModel);
        } else {
            this.genMapping((Node)expr, name, mappings, semanticModel);
        }
    }

    private void genInputs(Node expr, List<String> inputs) {
        SyntaxKind kind = expr.kind();
        if (kind == SyntaxKind.FIELD_ACCESS) {
            String source = expr.toSourceCode().trim();
            String[] split = source.split("\\[");
            if (split.length > 1) {
                inputs.add(split[0]);
            } else {
                inputs.add(source);
            }
        } else if (kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            inputs.add(expr.toSourceCode().trim());
        } else if (kind == SyntaxKind.BINARY_EXPRESSION) {
            BinaryExpressionNode binaryExpr = (BinaryExpressionNode)expr;
            this.genInputs(binaryExpr.lhsExpr(), inputs);
            this.genInputs(binaryExpr.rhsExpr(), inputs);
        } else if (kind == SyntaxKind.METHOD_CALL) {
            MethodCallExpressionNode methodCallExpr = (MethodCallExpressionNode)expr;
            this.genInputs((Node)methodCallExpr.expression(), inputs);
        } else if (kind == SyntaxKind.MAPPING_CONSTRUCTOR) {
            MappingConstructorExpressionNode mappingCtrExpr = (MappingConstructorExpressionNode)expr;
            for (MappingFieldNode field : mappingCtrExpr.fields()) {
                SyntaxKind fieldKind = field.kind();
                if (fieldKind == SyntaxKind.SPECIFIC_FIELD) {
                    Optional optFieldExpr = ((SpecificFieldNode)field).valueExpr();
                    optFieldExpr.ifPresent(expressionNode -> this.genInputs((Node)expressionNode, inputs));
                    continue;
                }
                this.genInputs((Node)field, inputs);
            }
        } else if (kind == SyntaxKind.INDEXED_EXPRESSION) {
            String source = expr.toSourceCode().trim();
            inputs.add(source.replace("[", ".").substring(0, source.length() - 1));
        }
    }

    private List<String> getDiagnostics(LineRange lineRange, SemanticModel semanticModel) {
        ArrayList<String> diagnosticMsgs = new ArrayList<String>();
        for (Diagnostic diagnostic : semanticModel.diagnostics(lineRange)) {
            diagnosticMsgs.add(diagnostic.message());
        }
        return diagnosticMsgs;
    }

    private List<MappingPort> getInputPorts(SemanticModel semanticModel, Document document, LinePosition position) {
        ArrayList<MappingPort> mappingPorts = new ArrayList<MappingPort>();
        List symbols = semanticModel.visibleSymbols(document, position);
        for (Symbol symbol : symbols) {
            org.ballerinalang.diagramutil.connector.models.connector.Type type;
            MappingPort mappingPort;
            MappingPort mappingPort2;
            org.ballerinalang.diagramutil.connector.models.connector.Type type2;
            Optional optName;
            SymbolKind kind = symbol.kind();
            if (kind == SymbolKind.VARIABLE) {
                optName = symbol.getName();
                if (optName.isEmpty()) continue;
                type2 = org.ballerinalang.diagramutil.connector.models.connector.Type.fromSemanticSymbol((Symbol)symbol);
                mappingPort2 = this.getMappingPort((String)optName.get(), (String)optName.get(), type2);
                if (mappingPort2 == null) continue;
                VariableSymbol varSymbol = (VariableSymbol)symbol;
                mappingPort2.category = varSymbol.qualifiers().contains(Qualifier.CONFIGURABLE) ? "configurable" : "variable";
                mappingPorts.add(mappingPort2);
                continue;
            }
            if (kind == SymbolKind.PARAMETER) {
                optName = symbol.getName();
                if (optName.isEmpty()) continue;
                type2 = org.ballerinalang.diagramutil.connector.models.connector.Type.fromSemanticSymbol((Symbol)symbol);
                mappingPort2 = this.getMappingPort((String)optName.get(), (String)optName.get(), type2);
                if (mappingPort2 == null) continue;
                mappingPort2.category = "parameter";
                mappingPorts.add(mappingPort2);
                continue;
            }
            if (kind != SymbolKind.CONSTANT || (mappingPort = this.getMappingPort((type = org.ballerinalang.diagramutil.connector.models.connector.Type.fromSemanticSymbol((Symbol)symbol)).getTypeName(), type.getTypeName(), type)) == null) continue;
            mappingPort.category = "constant";
            mappingPorts.add(mappingPort);
        }
        return mappingPorts;
    }

    private MappingPort getMappingPort(String id, String name, org.ballerinalang.diagramutil.connector.models.connector.Type type) {
        if (type.getTypeName().equals("record")) {
            RecordType recordType = (RecordType)type;
            TypeInfo typeInfo = type.getTypeInfo();
            MappingRecordPort recordPort = new MappingRecordPort(id, name, typeInfo != null ? typeInfo.name : type.getTypeName(), type.getTypeName());
            for (org.ballerinalang.diagramutil.connector.models.connector.Type field : recordType.fields) {
                recordPort.fields.add(this.getMappingPort(id + "." + field.getName(), field.getName(), field));
            }
            return recordPort;
        }
        if (type instanceof PrimitiveType) {
            return new MappingPort(id, type.getName(), type.getTypeName(), type.getTypeName());
        }
        if (type.getTypeName().equals("array")) {
            ArrayType arrayType = (ArrayType)type;
            MappingPort memberPort = this.getMappingPort(id, null, arrayType.memberType);
            MappingArrayPort arrayPort = new MappingArrayPort(id, name, (String)(memberPort == null ? "record" : memberPort.typeName + "[]"), type.getTypeName());
            arrayPort.setMember(memberPort);
            return arrayPort;
        }
        return null;
    }

    private Object genSourceForMappings(List<Mapping> mappings, String prevOutput) {
        Mapping firstMapping;
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        if (mappings.size() == 1 && (firstMapping = mappings.getFirst()).output().equals(prevOutput)) {
            List<MappingElements> elements = firstMapping.elements();
            if (elements == null) {
                return this.genExprFromMapping(firstMapping);
            }
            ArrayList<Object> rawMappings = new ArrayList<Object>();
            for (MappingElements element : elements) {
                this.genSourceFromMappingThroughElements(element, firstMapping.output(), rawMappings);
            }
            return rawMappings;
        }
        for (Mapping mapping : mappings) {
            String output = mapping.output();
            String substring = output.substring(prevOutput.length() + 1);
            String[] splits = substring.split("\\.");
            Map cm = m;
            int length = splits.length;
            for (int i = 0; i < length; ++i) {
                String split = splits[i];
                Object o = cm.get(split);
                if (o == null) {
                    if (i == length - 1) {
                        cm.put(split, this.genExprFromMapping(mapping));
                        continue;
                    }
                    LinkedHashMap temp = new LinkedHashMap();
                    cm.put(split, temp);
                    cm = temp;
                    continue;
                }
                if (!(o instanceof Map)) continue;
                cm = (Map)o;
            }
        }
        return m;
    }

    private Object genExprFromMapping(Mapping mapping) {
        List<MappingElements> elements = mapping.elements();
        if (elements == null || elements.isEmpty()) {
            return mapping.expression();
        }
        ArrayList<Object> rawMappings = new ArrayList<Object>();
        for (MappingElements element : elements) {
            this.genSourceFromMappingThroughElements(element, mapping.output(), rawMappings);
        }
        return rawMappings;
    }

    private void genSourceFromMappingThroughElements(MappingElements mappingElements, String prevOutput, List<Object> elements) {
        List<Mapping> mappings = mappingElements.mappings();
        LinkedHashMap m = new LinkedHashMap();
        for (Mapping mapping : mappings) {
            String output = mapping.output();
            String substring = output.substring(prevOutput.length() + 1);
            if (substring.isEmpty()) continue;
            String[] splits = substring.split("\\.");
            int length = splits.length;
            String lastSplit = splits[length - 1];
            if (length == 1 && lastSplit.matches("\\d+")) {
                elements.add(mapping.expression());
                continue;
            }
            Map<String, Object> currentMapping = m;
            String key = splits[0];
            for (int i = 0; i < length; ++i) {
                String split = splits[i];
                Object o = currentMapping.get(key);
                if (o == null) {
                    if (split.matches("\\d+")) continue;
                    if (i == length - 1) {
                        Object o1 = this.genExprFromMapping(mapping);
                        currentMapping.put(split, o1);
                        continue;
                    }
                    LinkedHashMap t = new LinkedHashMap();
                    currentMapping.put(split, t);
                    currentMapping = t;
                    key = split;
                    continue;
                }
                if (!(o instanceof Map)) continue;
                currentMapping = (Map)o;
            }
        }
        if (!m.isEmpty()) {
            elements.add(m);
        }
    }

    public String getSource(JsonElement mp, JsonElement fNode, String targetField) {
        FlowNode flowNode = (FlowNode)this.gson.fromJson(fNode, FlowNode.class);
        List fieldMapping = (List)this.gson.fromJson(mp, mt);
        if (flowNode.codedata().node() != NodeKind.VARIABLE) {
            return "";
        }
        String mappingSource = this.genSource(this.genSourceForMappings(fieldMapping, this.getVariableName(flowNode)));
        Optional<Property> optProperty = flowNode.getProperty("expression");
        if (optProperty.isEmpty()) {
            return mappingSource;
        }
        Property property = optProperty.get();
        String source = property.toSourceCode();
        if (targetField == null) {
            if (source.matches("^from.*in.*select.*$")) {
                String[] split = source.split("select");
                return split[0] + " select " + mappingSource + ";";
            }
        } else {
            String fieldsPattern = this.getFieldsPattern(targetField);
            if (source.matches(".*" + fieldsPattern + "\\s*:\\s*from.*in.*select.*$")) {
                String[] split = source.split(fieldsPattern + "\\s*:\\s*from");
                String newSource = split[0] + fieldsPattern + ": from";
                String[] splitBySelect = split[1].split("select");
                return newSource + splitBySelect[0] + "select" + splitBySelect[1].replaceFirst("\\{.*?}", mappingSource);
            }
        }
        return mappingSource;
    }

    private String getVariableName(FlowNode flowNode) {
        Optional<Property> optProperty = flowNode.getProperty("variable");
        if (optProperty.isEmpty()) {
            return "";
        }
        return optProperty.get().toSourceCode();
    }

    private String getFieldsPattern(String targetField) {
        String[] splits = targetField.split("\\.");
        StringBuilder pattern = new StringBuilder();
        int length = splits.length;
        for (int i = 1; i < length - 1; ++i) {
            String split = splits[i];
            if (split.matches("^-?\\d+$")) continue;
            pattern.append(split).append(".*");
        }
        pattern.append(splits[length - 1]);
        return pattern.toString();
    }

    private String genSource(Object sourceObj) {
        if (sourceObj instanceof Map) {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            Map mappings = (Map)sourceObj;
            int len = mappings.entrySet().size();
            int i = 0;
            for (Map.Entry stringObjectEntry : mappings.entrySet()) {
                sb.append((String)stringObjectEntry.getKey()).append(":");
                sb.append(this.genSource(stringObjectEntry.getValue()));
                if (i != len - 1) {
                    sb.append(",");
                }
                ++i;
            }
            sb.append("}");
            return sb.toString();
        }
        if (sourceObj instanceof List) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            List objects = (List)sourceObj;
            int len = objects.size();
            int i = 0;
            for (Object object : objects) {
                sb.append(this.genSource(object));
                if (i != len - 1) {
                    sb.append(",");
                }
                ++i;
            }
            sb.append("]");
            return sb.toString();
        }
        return sourceObj.toString();
    }

    public String getQuery(JsonElement fNode, String targetField, Path filePath, LinePosition position, Project project) {
        FlowNode flowNode = (FlowNode)this.gson.fromJson(fNode, FlowNode.class);
        SourceModification modification = this.applyNode(flowNode, project, filePath, position);
        TargetNode targetNode = this.getTargetNode(modification.stNode(), targetField, flowNode.codedata().node(), null, modification.semanticModel());
        if (targetNode == null) {
            return "";
        }
        TypeSymbol targetTypeSymbol = CommonUtils.getRawType((TypeSymbol)targetNode.typeSymbol());
        if (targetTypeSymbol.typeKind() != TypeDescKind.ARRAY) {
            return "";
        }
        TypeSymbol typeSymbol = CommonUtils.getRawType((TypeSymbol)((ArrayTypeSymbol)targetTypeSymbol).memberTypeDescriptor());
        if (typeSymbol.typeKind() != TypeDescKind.RECORD) {
            return "";
        }
        String query = this.getQuerySource((NonTerminalNode)targetNode.expressionNode(), (RecordTypeSymbol)typeSymbol);
        if (targetField == null) {
            return query;
        }
        if (flowNode.codedata().node() != NodeKind.VARIABLE) {
            return query;
        }
        Optional<Property> optProperty = flowNode.getProperty("expression");
        if (optProperty.isEmpty()) {
            return query;
        }
        Property property = optProperty.get();
        String expr = property.toSourceCode();
        return expr.replace(targetNode.expressionNode().toSourceCode(), query);
    }

    private SourceModification applyNode(FlowNode flowNode, Project project, Path filePath, LinePosition position) {
        SourceBuilder sourceBuilder = new SourceBuilder(flowNode, this.workspaceManager, filePath);
        String source = ((TextEdit)((List)((Map.Entry)NodeBuilder.getNodeFromKind(flowNode.codedata().node()).toSource(sourceBuilder).entrySet().stream().iterator().next()).getValue()).get(0)).getNewText();
        TextDocument textDocument = this.document.textDocument();
        int startTextPosition = textDocument.textPositionFrom(position);
        io.ballerina.tools.text.TextEdit textEdit = io.ballerina.tools.text.TextEdit.from((TextRange)TextRange.from((int)startTextPosition, (int)0), (String)source);
        io.ballerina.tools.text.TextEdit[] textEdits = new io.ballerina.tools.text.TextEdit[]{textEdit};
        TextDocument modifiedTextDoc = textDocument.apply(TextDocumentChange.from((io.ballerina.tools.text.TextEdit[])textEdits));
        Document modifiedDoc = project.duplicate().currentPackage().module(this.document.module().moduleId()).document(this.document.documentId()).modify().withContent(String.join((CharSequence)System.lineSeparator(), modifiedTextDoc.textLines())).apply();
        SemanticModel newSemanticModel = PackageUtil.getCompilation((Package)modifiedDoc.module().packageInstance()).getSemanticModel(modifiedDoc.module().moduleId());
        LinePosition startLine = modifiedTextDoc.linePositionFrom(startTextPosition);
        LinePosition endLine = modifiedTextDoc.linePositionFrom(startTextPosition + source.length());
        Range range = new Range(new Position(startLine.line(), startLine.offset()), new Position(endLine.line(), endLine.offset()));
        NonTerminalNode stNode = CommonUtil.findNode((Range)range, (SyntaxTree)modifiedDoc.syntaxTree());
        return new SourceModification(source, modifiedDoc, newSemanticModel, (Node)stNode);
    }

    private SourceModification applyConnection(FlowNode flowNode, Project project, Path filePath) {
        SourceBuilder sourceBuilder = new SourceBuilder(flowNode, this.workspaceManager, filePath);
        Path connectionPath = this.workspaceManager.projectRoot(filePath).resolve("connections.bal");
        List<TextEdit> connectionTextEdits = NodeBuilder.getNodeFromKind(flowNode.codedata().node()).toSource(sourceBuilder).get(connectionPath);
        Document document = (Document)this.workspaceManager.document(connectionPath).orElseThrow();
        TextDocument textDocument = document.textDocument();
        io.ballerina.tools.text.TextEdit[] textEdits = new io.ballerina.tools.text.TextEdit[connectionTextEdits.size()];
        for (int i = 0; i < connectionTextEdits.size(); ++i) {
            io.ballerina.tools.text.TextEdit textEdit;
            TextEdit connectionTextEdit = connectionTextEdits.get(i);
            Position start = connectionTextEdit.getRange().getStart();
            int startTextPosition = textDocument.textPositionFrom(LinePosition.from((int)start.getLine(), (int)start.getCharacter()));
            Position end = connectionTextEdit.getRange().getEnd();
            int endTextPosition = textDocument.textPositionFrom(LinePosition.from((int)end.getLine(), (int)end.getCharacter()));
            textEdits[i] = textEdit = io.ballerina.tools.text.TextEdit.from((TextRange)TextRange.from((int)startTextPosition, (int)(endTextPosition - startTextPosition)), (String)connectionTextEdit.getNewText());
        }
        TextDocument modifiedTextDoc = textDocument.apply(TextDocumentChange.from((io.ballerina.tools.text.TextEdit[])textEdits));
        Document modifiedDoc = project.duplicate().currentPackage().module(document.module().moduleId()).document(document.documentId()).modify().withContent(String.join((CharSequence)System.lineSeparator(), modifiedTextDoc.textLines())).apply();
        Optional<Property> optVariable = flowNode.getProperty("variable");
        if (optVariable.isEmpty()) {
            throw new IllegalStateException("Variable cannot be found for the connection");
        }
        SemanticModel newSemanticModel = PackageUtil.getCompilation((Package)modifiedDoc.module().packageInstance()).getSemanticModel(modifiedDoc.module().moduleId());
        return new SourceModification("", modifiedDoc, newSemanticModel, this.connectionNode(modifiedDoc, optVariable.get().toSourceCode()));
    }

    private Node connectionNode(Document document, String connectionName) {
        ModulePartNode modulePartNode = (ModulePartNode)document.syntaxTree().rootNode();
        NodeList members = modulePartNode.members();
        for (ModuleMemberDeclarationNode member : members) {
            ModuleVariableDeclarationNode varDecl;
            if (member.kind() != SyntaxKind.MODULE_VAR_DECL || !(varDecl = (ModuleVariableDeclarationNode)member).typedBindingPattern().bindingPattern().toSourceCode().trim().equals(connectionName)) continue;
            return varDecl;
        }
        return null;
    }

    private String getQuerySource(NonTerminalNode inputExpr, RecordTypeSymbol recordTypeSymbol) {
        Object name = "item";
        SyntaxKind kind = inputExpr.kind();
        if (kind == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            name = inputExpr.toSourceCode() + "Item";
        } else if (kind == SyntaxKind.FIELD_ACCESS) {
            FieldAccessExpressionNode fieldAccessExpr = (FieldAccessExpressionNode)inputExpr;
            name = fieldAccessExpr.fieldName().toSourceCode() + "Item";
        }
        StringBuilder sb = new StringBuilder("from var " + (String)name + " in " + inputExpr.toSourceCode());
        sb.append(" ").append(SyntaxKind.SELECT_KEYWORD.stringValue()).append(" ");
        sb.append(SyntaxKind.OPEN_BRACE_TOKEN.stringValue());
        ArrayList keys = new ArrayList(recordTypeSymbol.fieldDescriptors().keySet());
        int size = keys.size();
        for (int i = 0; i < size - 1; ++i) {
            sb.append((String)keys.get(i)).append(": ").append(SyntaxKind.COMMA_TOKEN.stringValue());
        }
        sb.append((String)keys.get(size - 1)).append(": ");
        sb.append(SyntaxKind.CLOSE_BRACE_TOKEN.stringValue());
        return sb.toString();
    }

    public JsonElement getVisualizableProperties(JsonElement node, Project project, Path filePath, LinePosition position) {
        FlowNode flowNode = (FlowNode)this.gson.fromJson(node, FlowNode.class);
        ArrayList<String> visualizableProperties = new ArrayList<String>();
        NodeKind nodeKind = flowNode.codedata().node();
        if (nodeKind == NodeKind.VARIABLE) {
            SourceModification sourceModification = this.applyNode(flowNode, project, filePath, position);
            Node stNode = sourceModification.stNode();
            if (stNode.kind() != SyntaxKind.LOCAL_VAR_DECL) {
                throw new IllegalStateException("Node is not a variable declaration");
            }
            Optional optVarSymbol = sourceModification.semanticModel().symbol(stNode);
            if (optVarSymbol.isEmpty()) {
                throw new IllegalStateException("Symbol cannot be found for the variable declaration");
            }
            VariableSymbol variableSymbol = (VariableSymbol)optVarSymbol.get();
            if (this.isEffectiveRecordType(variableSymbol.typeDescriptor())) {
                visualizableProperties.add("expression");
            }
        } else if (nodeKind == NodeKind.NEW_CONNECTION) {
            SourceModification sourceModification = this.applyConnection(flowNode, project, filePath);
            Optional<Property> optVariable = flowNode.getProperty("variable");
            if (optVariable.isEmpty()) {
                throw new IllegalStateException("Variable cannot be found for the connection");
            }
            List symbols = sourceModification.semanticModel().moduleSymbols();
            String variableName = optVariable.get().toSourceCode();
            Optional<Symbol> optVariableSymbol = symbols.parallelStream().filter(symbol -> symbol.getName().isPresent() && ((String)symbol.getName().get()).equals(variableName)).findAny();
            if (optVariableSymbol.isEmpty()) {
                throw new IllegalStateException("Symbol cannot be found for the connection variable");
            }
            VariableSymbol variableSymbol = (VariableSymbol)optVariableSymbol.get();
            TypeSymbol typeSymbol = CommonUtils.getRawType((TypeSymbol)variableSymbol.typeDescriptor());
            if (typeSymbol.kind() != SymbolKind.CLASS) {
                throw new IllegalStateException("Connection symbol is not a class symbol");
            }
            ClassSymbol classSymbol = (ClassSymbol)typeSymbol;
            Optional optInitMethodSymbol = classSymbol.initMethod();
            if (optInitMethodSymbol.isEmpty()) {
                throw new IllegalStateException("Init method cannot be found for the connection class");
            }
            MethodSymbol initMethodSymbol = (MethodSymbol)optInitMethodSymbol.get();
            Optional optParams = initMethodSymbol.typeDescriptor().params();
            if (optParams.isPresent()) {
                List params = (List)optParams.get();
                for (ParameterSymbol param : params) {
                    if (!this.isEffectiveRecordType(param.typeDescriptor())) continue;
                    visualizableProperties.add((String)param.getName().get());
                }
            }
        }
        return this.gson.toJsonTree(visualizableProperties);
    }

    private boolean isEffectiveRecordType(TypeSymbol typeSymbol) {
        TypeSymbol rawTypeSymbol = CommonUtils.getRawType((TypeSymbol)typeSymbol);
        TypeDescKind kind = rawTypeSymbol.typeKind();
        if (kind == TypeDescKind.ARRAY) {
            return this.isEffectiveRecordType(((ArrayTypeSymbol)rawTypeSymbol).memberTypeDescriptor());
        }
        return kind == TypeDescKind.RECORD;
    }

    public String addElement(JsonElement node, String propertyKey, Path filePath, String targetField, Project project, LinePosition position) {
        FlowNode flowNode = (FlowNode)this.gson.fromJson(node, FlowNode.class);
        if (flowNode.codedata().node() != NodeKind.VARIABLE) {
            return "";
        }
        Optional<Property> optProperty = flowNode.getProperty(propertyKey);
        if (optProperty.isEmpty()) {
            return "";
        }
        Property property = optProperty.get();
        String source = property.toSourceCode();
        SourceModification sourceModification = this.applyNode(flowNode, project, filePath, position);
        Node stNode = sourceModification.stNode();
        if (stNode.kind() != SyntaxKind.LOCAL_VAR_DECL) {
            return "";
        }
        Optional symbol = sourceModification.semanticModel().symbol(stNode);
        if (symbol.isEmpty()) {
            return "";
        }
        TypeSymbol targetType = this.getTargetType(((VariableSymbol)symbol.get()).typeDescriptor(), targetField);
        if (targetType == null) {
            return "";
        }
        if (targetType.typeKind() == TypeDescKind.ARRAY) {
            targetType = ((ArrayTypeSymbol)targetType).memberTypeDescriptor();
        }
        Object defaultVal = DefaultValueGeneratorUtil.getDefaultValueForType((TypeSymbol)targetType);
        if (source.equals("[]")) {
            return "[" + (String)defaultVal + "]";
        }
        VariableDeclarationNode varDeclNode = (VariableDeclarationNode)stNode;
        if (varDeclNode.initializer().isEmpty()) {
            return source;
        }
        ExpressionNode initializer = (ExpressionNode)varDeclNode.initializer().get();
        ExpressionNode expr = this.getArrayExpr(targetField, initializer);
        if (expr == null || expr.kind() != SyntaxKind.LIST_CONSTRUCTOR) {
            return source;
        }
        ListConstructorExpressionNode listCtrExpr = (ListConstructorExpressionNode)expr;
        if (!listCtrExpr.expressions().isEmpty()) {
            defaultVal = ", " + (String)defaultVal;
        }
        int pos = listCtrExpr.closeBracket().position() - initializer.position();
        source = initializer.toSourceCode();
        return source.substring(0, pos) + (String)defaultVal + source.substring(pos);
    }

    private ExpressionNode getArrayExpr(String targetField, ExpressionNode expr) {
        String[] splits = targetField.split("\\.");
        ExpressionNode currentExpr = expr;
        for (int i = 1; i < splits.length; ++i) {
            String split = splits[i];
            if (split.matches("\\d+")) {
                if (currentExpr.kind() != SyntaxKind.LIST_CONSTRUCTOR) continue;
                ListConstructorExpressionNode listCtrExpr = (ListConstructorExpressionNode)currentExpr;
                SeparatedNodeList expressions = listCtrExpr.expressions();
                int size = expressions.size();
                int index = Integer.parseInt(split);
                if (index >= size) {
                    return null;
                }
                currentExpr = (ExpressionNode)expressions.get(index);
                continue;
            }
            if (currentExpr.kind() != SyntaxKind.MAPPING_CONSTRUCTOR) continue;
            MappingConstructorExpressionNode mappingCtrExpr = (MappingConstructorExpressionNode)currentExpr;
            for (MappingFieldNode field : mappingCtrExpr.fields()) {
                SpecificFieldNode specificFieldNode;
                if (field.kind() != SyntaxKind.SPECIFIC_FIELD || !(specificFieldNode = (SpecificFieldNode)field).fieldName().toSourceCode().trim().equals(split)) continue;
                Optional optFieldExpr = specificFieldNode.valueExpr();
                if (optFieldExpr.isEmpty()) {
                    return null;
                }
                currentExpr = (ExpressionNode)optFieldExpr.get();
            }
        }
        return currentExpr;
    }

    private TypeSymbol getTargetType(TypeSymbol typeSymbol, String targetField) {
        if (targetField == null || targetField.isEmpty()) {
            return typeSymbol;
        }
        String[] splits = targetField.split("\\.");
        if (splits.length == 1) {
            return typeSymbol;
        }
        TypeSymbol targetType = typeSymbol;
        for (int i = 1; i < splits.length; ++i) {
            targetType = CommonUtils.getRawType((TypeSymbol)targetType);
            String split = splits[i];
            if (split.matches("\\d+")) {
                if (targetType.typeKind() != TypeDescKind.ARRAY) {
                    return null;
                }
                targetType = ((ArrayTypeSymbol)targetType).memberTypeDescriptor();
                continue;
            }
            if (targetType.typeKind() != TypeDescKind.RECORD) {
                return null;
            }
            RecordFieldSymbol recordFieldSymbol = (RecordFieldSymbol)((RecordTypeSymbol)targetType).fieldDescriptors().get(split);
            targetType = recordFieldSymbol.typeDescriptor();
        }
        return targetType;
    }

    private record SourceModification(String source, Document document, SemanticModel semanticModel, Node stNode) {
    }

    private record TargetNode(TypeSymbol typeSymbol, String name, ExpressionNode expressionNode) {
    }

    private static class MappingPort {
        String id;
        String variableName;
        String typeName;
        String kind;
        String category;

        MappingPort(String id, String variableName, String typeName, String kind) {
            this.id = id;
            this.variableName = variableName;
            this.typeName = typeName;
            this.kind = kind;
        }

        String getCategory() {
            return this.category;
        }

        String getKind() {
            return this.kind;
        }

        void setKind(String kind) {
            this.kind = kind;
        }

        String getVariableName() {
            return this.variableName;
        }

        void setVariableName(String variableName) {
            this.variableName = variableName;
        }
    }

    private record Model(List<MappingPort> inputs, MappingPort output, List<Mapping> mappings) {
    }

    private record Mapping(String output, List<String> inputs, String expression, List<String> diagnostics, List<MappingElements> elements) {
    }

    private record MappingElements(List<Mapping> mappings) {
    }

    private static class MappingRecordPort
    extends MappingPort {
        List<MappingPort> fields = new ArrayList<MappingPort>();

        MappingRecordPort(String id, String variableName, String typeName, String kind) {
            super(id, variableName, typeName, kind);
        }
    }

    private static class MappingArrayPort
    extends MappingPort {
        MappingPort member;

        MappingArrayPort(String id, String variableName, String typeName, String kind) {
            super(id, variableName, typeName, kind);
        }

        MappingPort getMember() {
            return this.member;
        }

        void setMember(MappingPort member) {
            this.member = member;
        }
    }
}

