/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.flowmodelgenerator.core.model.Diagnostics;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.util.Iterator;
import org.ballerinalang.langserver.common.utils.PositionUtil;

public class DiagnosticHandler {
    private final Iterator<Diagnostic> iterator;
    private Diagnostic currentDiagnostic;
    private boolean hasNodeAnnotated;

    public DiagnosticHandler(SemanticModel semanticModel) {
        this.iterator = semanticModel.diagnostics().parallelStream().filter(diagnostic -> diagnostic.diagnosticInfo().severity() == DiagnosticSeverity.ERROR).iterator();
        this.hasNodeAnnotated = false;
        if (this.iterator.hasNext()) {
            this.currentDiagnostic = this.iterator.next();
        }
    }

    public void handle(DiagnosticCapable builder, LineRange nodeLineRange, boolean isLeafNode) {
        if (this.currentDiagnostic == null) {
            return;
        }
        LinePosition nodeStartLine = nodeLineRange.startLine();
        while (this.currentDiagnostic != null) {
            if (!nodeLineRange.fileName().equals(this.currentDiagnostic.location().lineRange().fileName())) {
                this.next();
                continue;
            }
            LineRange diagnosticLineRange = this.currentDiagnostic.location().lineRange();
            LinePosition diagnosticEndLine = diagnosticLineRange.endLine();
            while (DiagnosticHandler.hasDiagnosticPassed(nodeStartLine, diagnosticEndLine, isLeafNode)) {
                if (this.iterator.hasNext()) {
                    this.currentDiagnostic = this.iterator.next();
                    this.hasNodeAnnotated = false;
                    diagnosticLineRange = this.currentDiagnostic.location().lineRange();
                    diagnosticEndLine = diagnosticLineRange.endLine();
                    continue;
                }
                this.currentDiagnostic = null;
                return;
            }
            boolean isNodeWithinDiagnostic = PositionUtil.isWithinLineRange((LineRange)nodeLineRange, (LineRange)diagnosticLineRange);
            boolean isDiagnosticWithinNode = PositionUtil.isWithinLineRange((LineRange)diagnosticLineRange, (LineRange)nodeLineRange);
            if (isNodeWithinDiagnostic && isDiagnosticWithinNode) {
                if (!isLeafNode) {
                    this.hasNodeAnnotated = true;
                }
                this.addDiagnostic(builder);
                this.next();
                continue;
            }
            if (isNodeWithinDiagnostic) {
                if (this.handleLeafNode(builder, isLeafNode)) continue;
                this.hasNodeAnnotated = true;
                this.addDiagnostic(builder);
                return;
            }
            if (isDiagnosticWithinNode) {
                if (this.handleLeafNode(builder, isLeafNode)) continue;
                builder.diagnostics().hasDiagnostics();
            }
            return;
        }
    }

    private boolean handleLeafNode(DiagnosticCapable builder, boolean isLeafNode) {
        if (isLeafNode) {
            if (!this.hasNodeAnnotated) {
                this.addDiagnostic(builder);
            }
            this.next();
            return true;
        }
        return false;
    }

    private void next() {
        this.currentDiagnostic = this.iterator.hasNext() ? this.iterator.next() : null;
        this.hasNodeAnnotated = false;
    }

    private void addDiagnostic(DiagnosticCapable builder) {
        builder.diagnostics().diagnostic(this.currentDiagnostic.diagnosticInfo().severity(), this.currentDiagnostic.message());
    }

    private static boolean hasDiagnosticPassed(LinePosition nodeStartLine, LinePosition diagnosticEndLine, boolean isLeafNode) {
        return !isLeafNode && (nodeStartLine.line() > diagnosticEndLine.line() || nodeStartLine.line() == diagnosticEndLine.line() && nodeStartLine.offset() > diagnosticEndLine.offset());
    }

    public static interface DiagnosticCapable {
        public Diagnostics.Builder<?> diagnostics();
    }
}

