/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ChildNodeList;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.TextEdit;

public class ErrorHandlerGenerator {
    private final WorkspaceManager workspaceManager;
    private final Path filePath;
    private final Gson gson;

    public ErrorHandlerGenerator(WorkspaceManager workspaceManager, Path filePath) {
        this.workspaceManager = workspaceManager;
        this.filePath = filePath;
        this.gson = new Gson();
    }

    public JsonElement getTextEdits() {
        ModulePartNode rootNode;
        SemanticModel semanticModel;
        try {
            this.workspaceManager.loadProject(this.filePath);
            Document document = (Document)this.workspaceManager.document(this.filePath).orElseThrow();
            semanticModel = (SemanticModel)this.workspaceManager.semanticModel(this.filePath).orElseThrow();
            rootNode = (ModulePartNode)document.syntaxTree().rootNode();
        }
        catch (EventSyncException | WorkspaceDocumentException e) {
            throw new RuntimeException("Failed to get the document", e);
        }
        FunctionVisitor functionVisitor = new FunctionVisitor(semanticModel);
        rootNode.accept((NodeVisitor)functionVisitor);
        List<TextEdit> textEdits = functionVisitor.getTextEdits();
        return this.gson.toJsonTree(Map.of(this.filePath, textEdits));
    }

    private static class FunctionVisitor
    extends NodeVisitor {
        private static final String prefix = "do {\n";
        private static final String suffix = "\n} on fail var e {\n   return e;\n}";
        private final List<TextEdit> textEdits = new ArrayList<TextEdit>();
        private final SemanticModel semanticModel;
        private final TypeSymbol errorTypeSymbol;

        public FunctionVisitor(SemanticModel semanticModel) {
            this.semanticModel = semanticModel;
            this.errorTypeSymbol = semanticModel.types().ERROR;
        }

        public void visit(FunctionDefinitionNode functionDefinitionNode) {
            FunctionBodyNode functionBodyNode = functionDefinitionNode.functionBody();
            if (functionBodyNode.kind() == SyntaxKind.EXPRESSION_FUNCTION_BODY) {
                return;
            }
            ChildNodeList children = functionBodyNode.children();
            if (children.size() == 3 && children.get(1).kind() == SyntaxKind.DO_STATEMENT) {
                return;
            }
            if (this.hasNoReturnError(functionDefinitionNode)) {
                FunctionSignatureNode functionSignatureNode = functionDefinitionNode.functionSignature();
                Optional returnTypeDescriptorNode = functionSignatureNode.returnTypeDesc();
                if (returnTypeDescriptorNode.isEmpty()) {
                    this.addTextEdit(functionSignatureNode.lineRange().endLine(), " returns error?");
                } else {
                    this.addTextEdit(((ReturnTypeDescriptorNode)returnTypeDescriptorNode.get()).type().lineRange().endLine(), "|error");
                }
            }
            LineRange childLineRange = CommonUtils.getLineRangeOfBlockNode((NonTerminalNode)functionBodyNode);
            this.addTextEdit(childLineRange.startLine(), prefix);
            this.addTextEdit(childLineRange.endLine(), suffix);
        }

        private boolean hasNoReturnError(FunctionDefinitionNode functionDefinitionNode) {
            return this.semanticModel.symbol((Node)functionDefinitionNode).filter(symbol -> symbol.kind() == SymbolKind.FUNCTION).map(symbol -> ((FunctionSymbol)symbol).typeDescriptor().returnTypeDescriptor()).map(returnType -> returnType.isEmpty() || !this.errorTypeSymbol.subtypeOf((TypeSymbol)returnType.get())).orElse(true);
        }

        private void addTextEdit(LinePosition position, String text) {
            this.textEdits.add(new TextEdit(CommonUtils.toRange((LinePosition)position), text));
        }

        public List<TextEdit> getTextEdits() {
            return this.textEdits;
        }
    }
}

