/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import io.ballerina.flowmodelgenerator.core.model.AvailableNode;
import io.ballerina.flowmodelgenerator.core.model.Category;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.flowmodelgenerator.core.model.Item;
import io.ballerina.flowmodelgenerator.core.model.Metadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LocalIndexCentral {
    private final Gson gson = new GsonBuilder().registerTypeAdapter(Item.class, (Object)new ItemDeserializer()).registerTypeAdapter(Category.class, (Object)new CategoryDeserializer()).create();
    private Map<String, FlowNode> templateCache;
    private Map<String, List<Item>> connectionMap;
    private static final String NODE_TEMPLATES_JSON = "node_templates.json";
    private static final String CONNECTORS_JSON = "connectors.json";
    private static final String CONNECTIONS_JSON = "connections.json";
    private static final String FUNCTIONS_JSON = "functions.json";

    public static LocalIndexCentral getInstance() {
        return CentralProxyHolder.instance;
    }

    public FlowNode getNodeTemplate(Codedata codedata) {
        if (this.templateCache == null) {
            this.initializeTemplateCache();
        }
        return this.templateCache.get(codedata.toString());
    }

    public List<Item> getConnectors() {
        Category connectors = (Category)this.readJsonResource(CONNECTORS_JSON, (Type)((Object)Category.class));
        return connectors.items();
    }

    public List<Item> getFunctions() {
        Category functions = (Category)this.readJsonResource(FUNCTIONS_JSON, (Type)((Object)Category.class));
        return functions.items();
    }

    public List<Item> getConnectorActions(Codedata codedata) {
        if (this.connectionMap == null) {
            this.initializeConnectionMap();
        }
        return this.connectionMap.get(codedata.toString());
    }

    public List<AvailableNode> getConnectors(Map<String, String> queryMap) {
        List<Item> connectors = this.getConnectors();
        String query = queryMap.getOrDefault("q", "");
        int limit = Integer.parseInt(queryMap.getOrDefault("limit", "10"));
        int offset = Integer.parseInt(queryMap.getOrDefault("offset", "0"));
        ArrayList<AvailableNode> availableNodes = new ArrayList<AvailableNode>();
        for (Item item : connectors) {
            if (item instanceof Category) {
                availableNodes.addAll(this.getAvailableNodesFromCategory((Category)item));
                continue;
            }
            if (!(item instanceof AvailableNode)) continue;
            availableNodes.add((AvailableNode)item);
        }
        return availableNodes.stream().filter(node -> node.codedata().object().contains(query) || node.codedata().module().contains(query)).skip(offset).limit(limit).toList();
    }

    private List<AvailableNode> getAvailableNodesFromCategory(Category category) {
        ArrayList<AvailableNode> availableNodes = new ArrayList<AvailableNode>();
        for (Item item : category.items()) {
            if (item instanceof Category) {
                availableNodes.addAll(this.getAvailableNodesFromCategory((Category)item));
                continue;
            }
            if (!(item instanceof AvailableNode)) continue;
            availableNodes.add((AvailableNode)item);
        }
        return availableNodes;
    }

    private void initializeTemplateCache() {
        this.templateCache = (Map)this.readJsonResource(NODE_TEMPLATES_JSON, new FlowNodeTypeToken().getType());
    }

    private void initializeConnectionMap() {
        this.connectionMap = (Map)this.readJsonResource(CONNECTIONS_JSON, new ConnectionTypeToken().getType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T readJsonResource(String resourcePath, Type type) {
        InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        if (resourceStream == null) {
            throw new IllegalArgumentException("Resource not found: " + resourcePath);
        }
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(resourceStream, StandardCharsets.UTF_8));){
            Object object = this.gson.fromJson(reader, type);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class CentralProxyHolder {
        private static final LocalIndexCentral instance = new LocalIndexCentral();

        private CentralProxyHolder() {
        }
    }

    private static class ItemDeserializer
    implements JsonDeserializer<Item> {
        private ItemDeserializer() {
        }

        public Item deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            if (jsonObject.has("items")) {
                return (Item)context.deserialize((JsonElement)jsonObject, Category.class);
            }
            if (jsonObject.has("enabled")) {
                return (Item)context.deserialize((JsonElement)jsonObject, AvailableNode.class);
            }
            throw new JsonParseException("Unknown type of Item");
        }
    }

    private static class CategoryDeserializer
    implements JsonDeserializer<Category> {
        private CategoryDeserializer() {
        }

        public Category deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            Metadata metadata = (Metadata)context.deserialize(jsonObject.get("metadata"), Metadata.class);
            JsonArray itemsArray = jsonObject.getAsJsonArray("items");
            ArrayList<Item> items = new ArrayList<Item>();
            for (JsonElement itemElement : itemsArray) {
                items.add((Item)context.deserialize(itemElement, Item.class));
            }
            return new Category(metadata, items);
        }
    }

    private static class FlowNodeTypeToken
    extends TypeToken<Map<String, FlowNode>> {
        private FlowNodeTypeToken() {
        }
    }

    private static class ConnectionTypeToken
    extends TypeToken<Map<String, List<Item>>> {
        private ConnectionTypeToken() {
        }
    }
}

