/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.openapi.core.generators.client.BallerinaClientGenerator;
import io.ballerina.openapi.core.generators.client.exception.ClientException;
import io.ballerina.openapi.core.generators.client.model.OASClientConfig;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.TypeHandler;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.model.Filter;
import io.ballerina.openapi.core.generators.common.model.GenSrcFile;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.TableArrayNode;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;
import org.eclipse.lsp4j.TextEdit;

public class OpenAPIClientGenerator {
    public static final String BALLERINA_TOML = "Ballerina.toml";
    private final Gson gson = new Gson();
    private final Path oAContractPath;
    private final Path projectPath;
    private static final String LS = System.lineSeparator();

    public OpenAPIClientGenerator(Path oAContractPath, Path projectPath) {
        this.oAContractPath = oAContractPath;
        this.projectPath = projectPath;
    }

    public JsonElement genClient(String module) throws IOException, BallerinaOpenApiException, ClientException, FormatterException {
        HashMap<Path, List<TextEdit>> textEditsMap = new HashMap<Path, List<TextEdit>>();
        boolean isModuleExists = this.genBalTomlTableEntry(module, textEditsMap);
        this.genClientSource(module, textEditsMap);
        ClientSource clientSource = new ClientSource(isModuleExists, textEditsMap);
        return this.gson.toJsonTree((Object)clientSource);
    }

    public JsonArray getModules() throws IOException {
        Path tomlPath = this.projectPath.resolve(BALLERINA_TOML);
        TextDocument configDocument = TextDocuments.from((String)Files.readString(tomlPath));
        io.ballerina.toml.syntax.tree.SyntaxTree syntaxTree = io.ballerina.toml.syntax.tree.SyntaxTree.from((TextDocument)configDocument);
        DocumentNode rootNode = (DocumentNode)syntaxTree.rootNode();
        ArrayList<String> modules = new ArrayList<String>();
        for (DocumentMemberDeclarationNode node : rootNode.members()) {
            TableArrayNode tableArrayNode;
            if (node.kind() != SyntaxKind.TABLE_ARRAY || !(tableArrayNode = (TableArrayNode)node).identifier().toSourceCode().equals("tool.openapi")) continue;
            for (KeyValueNode field : tableArrayNode.fields()) {
                String identifier = field.identifier().toSourceCode();
                if (!identifier.trim().equals("targetModule")) continue;
                String fieldValue = field.value().toSourceCode().trim();
                int endCharIndex = fieldValue.length() - 1;
                if (fieldValue.endsWith(System.lineSeparator())) {
                    --endCharIndex;
                }
                modules.add(fieldValue.substring(1, endCharIndex));
            }
        }
        return this.gson.toJsonTree(modules).getAsJsonArray();
    }

    public JsonElement deleteModule(String module) throws IOException {
        File dir = new File(this.projectPath.resolve("generated").resolve(module).toUri());
        File[] files = dir.listFiles();
        ArrayList<String> filesToDelete = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                filesToDelete.add(file.getAbsolutePath());
            }
        }
        Path tomlPath = this.projectPath.resolve(BALLERINA_TOML);
        TextDocument configDocument = TextDocuments.from((String)Files.readString(tomlPath));
        io.ballerina.toml.syntax.tree.SyntaxTree syntaxTree = io.ballerina.toml.syntax.tree.SyntaxTree.from((TextDocument)configDocument);
        DocumentNode rootNode = (DocumentNode)syntaxTree.rootNode();
        LineRange lineRange = null;
        block1: for (DocumentMemberDeclarationNode node : rootNode.members()) {
            TableArrayNode tableArrayNode;
            if (node.kind() != SyntaxKind.TABLE_ARRAY || !(tableArrayNode = (TableArrayNode)node).identifier().toSourceCode().equals("tool.openapi")) continue;
            for (KeyValueNode field : tableArrayNode.fields()) {
                String identifier = field.identifier().toSourceCode();
                if (!identifier.trim().equals("targetModule") || !field.value().toSourceCode().contains("\"" + module + "\"")) continue;
                lineRange = tableArrayNode.lineRange();
                continue block1;
            }
        }
        HashMap<Path, List<TextEdit>> textEditsMap = new HashMap<Path, List<TextEdit>>();
        if (lineRange != null) {
            textEditsMap.put(tomlPath, List.of(new TextEdit(CommonUtils.toRange(lineRange), "")));
        }
        return this.gson.toJsonTree((Object)new DeleteData(filesToDelete, textEditsMap));
    }

    private boolean genBalTomlTableEntry(String module, Map<Path, List<TextEdit>> textEditsMap) throws IOException {
        Path tomlPath = this.projectPath.resolve(BALLERINA_TOML);
        TextDocument configDocument = TextDocuments.from((String)Files.readString(tomlPath));
        io.ballerina.toml.syntax.tree.SyntaxTree syntaxTree = io.ballerina.toml.syntax.tree.SyntaxTree.from((TextDocument)configDocument);
        DocumentNode rootNode = (DocumentNode)syntaxTree.rootNode();
        LineRange lineRange = null;
        block0: for (DocumentMemberDeclarationNode node : rootNode.members()) {
            TableArrayNode tableArrayNode;
            if (node.kind() != SyntaxKind.TABLE_ARRAY || !(tableArrayNode = (TableArrayNode)node).identifier().toSourceCode().equals("tool.openapi")) continue;
            for (KeyValueNode field : tableArrayNode.fields()) {
                String identifier = field.identifier().toSourceCode();
                if (!identifier.trim().equals("targetModule") || !field.value().toSourceCode().contains("\"" + module + "\"")) continue;
                lineRange = tableArrayNode.lineRange();
                continue block0;
            }
        }
        String tomlEntry = this.getTomlEntry(module);
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        textEditsMap.put(tomlPath, textEdits);
        if (lineRange != null) {
            textEdits.add(new TextEdit(CommonUtils.toRange(lineRange), tomlEntry));
        } else {
            LinePosition startPos = LinePosition.from((int)(rootNode.lineRange().endLine().line() + 1), (int)0);
            textEdits.add(new TextEdit(CommonUtils.toRange((LinePosition)startPos), tomlEntry));
        }
        return lineRange != null;
    }

    private void genClientSource(String module, Map<Path, List<TextEdit>> textEditsMap) throws IOException, BallerinaOpenApiException, ClientException, FormatterException {
        OpenAPI openAPI = GeneratorUtils.normalizeOpenAPI((Path)this.oAContractPath, (boolean)false, (boolean)true, (boolean)true);
        if (openAPI.getInfo() == null) {
            throw new BallerinaOpenApiException("Info section of the definition file cannot be empty/null: " + String.valueOf(openAPI));
        }
        Filter filter = new Filter();
        OASClientConfig clientConfig = new OASClientConfig.Builder().withFilters(filter).withOpenAPI(openAPI).build();
        TypeHandler.createInstance((OpenAPI)clientConfig.getOpenAPI(), (boolean)clientConfig.isNullable());
        BallerinaClientGenerator balClientGenerator = new BallerinaClientGenerator(clientConfig);
        SyntaxTree syntaxTree = balClientGenerator.generateSyntaxTree();
        List clientDiagnostic = balClientGenerator.getDiagnostics();
        if (clientDiagnostic.stream().anyMatch(diagnostic -> diagnostic.getDiagnosticSeverity() == DiagnosticSeverity.ERROR)) {
            throw new ClientException("Error occurred while generating client");
        }
        List authNodes = balClientGenerator.getBallerinaAuthConfigGenerator().getAuthRelatedTypeDefinitionNodes();
        for (TypeDefinitionNode typeDef : authNodes) {
            TypeHandler.getInstance().addTypeDefinitionNode(typeDef.typeName().text(), typeDef);
        }
        String licenseContent = clientConfig.getLicense();
        String licenseHeader = licenseContent == null || licenseContent.isBlank() ? "" : licenseContent + LS;
        List<GenSrcFile> sourceFiles = this.genClientSourceFiles(syntaxTree, licenseHeader, balClientGenerator);
        Path outputPath = this.projectPath.resolve("generated").resolve(module);
        for (GenSrcFile sourceFile : sourceFiles) {
            ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
            textEdits.add(new TextEdit(CommonUtils.toRange((LinePosition)LinePosition.from((int)0, (int)0)), sourceFile.getContent()));
            textEditsMap.put(outputPath.resolve(sourceFile.getFileName()), textEdits);
        }
    }

    private List<GenSrcFile> genClientSourceFiles(SyntaxTree syntaxTree, String licenseHeader, BallerinaClientGenerator ballerinaClientGenerator) throws FormatterException, IOException {
        SyntaxTree schemaSyntaxTree;
        String schemaContent;
        ArrayList<GenSrcFile> sourceFiles = new ArrayList<GenSrcFile>();
        String mainContent = Formatter.format((SyntaxTree)syntaxTree).toSourceCode();
        sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, null, "client.bal", licenseHeader + mainContent));
        String utilContent = Formatter.format((SyntaxTree)ballerinaClientGenerator.getBallerinaUtilGenerator().generateUtilSyntaxTree()).toString();
        if (!utilContent.isBlank()) {
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.UTIL_SRC, null, "utils.bal", licenseHeader + utilContent));
        }
        if (!(schemaContent = Formatter.format((SyntaxTree)(schemaSyntaxTree = TypeHandler.getInstance().generateTypeSyntaxTree())).toSourceCode()).isBlank()) {
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.MODEL_SRC, null, "types.bal", licenseHeader + schemaContent));
        }
        return sourceFiles;
    }

    private String getTomlEntry(String module) {
        String moduleWithQuotes = "\"" + module + "\"";
        return LS + "[[tool.openapi]]" + LS + "id = " + moduleWithQuotes + LS + "targetModule = " + moduleWithQuotes + LS + "filePath = \"" + this.oAContractPath.toAbsolutePath().toString().replace("\\", "\\\\") + "\"" + LS;
    }

    private record ClientSource(boolean isModuleExists, Map<Path, List<TextEdit>> textEditsMap) {
    }

    private record DeleteData(List<String> filesToDelete, Map<Path, List<TextEdit>> textEditsMap) {
    }
}

