/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class SourceGenerator {
    private final Gson gson;
    private final WorkspaceManager workspaceManager;
    private Path filePath;

    public SourceGenerator(WorkspaceManager workspaceManager, Path filePath) {
        this.workspaceManager = workspaceManager;
        this.filePath = filePath;
        this.gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    public JsonElement toSourceCode(JsonElement diagramNode, LSClientLogger lsClientLogger) {
        FlowNode flowNode = (FlowNode)this.gson.fromJson(diagramNode, FlowNode.class);
        SourceBuilder sourceBuilder = new SourceBuilder(flowNode, this.workspaceManager, this.filePath, lsClientLogger);
        Map<Path, List<TextEdit>> textEdits = NodeBuilder.getNodeFromKind(flowNode.codedata().node()).toSource(sourceBuilder);
        this.addNewLine(textEdits);
        return this.gson.toJsonTree(textEdits);
    }

    private void addNewLine(Map<Path, List<TextEdit>> textEdits) {
        block0: for (Map.Entry<Path, List<TextEdit>> pathListEntry : textEdits.entrySet()) {
            List<TextEdit> edits = pathListEntry.getValue();
            for (TextEdit edit : edits) {
                Range range = edit.getRange();
                if (range.getStart().equals((Object)new Position(0, 0)) || !range.getStart().equals((Object)range.getEnd())) continue;
                edit.setNewText(System.lineSeparator() + edit.getNewText());
                continue block0;
            }
        }
    }
}

