/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionItemLabelDetails;

public final class TypeCompletionItemBuilder {
    private TypeCompletionItemBuilder() {
    }

    public static CompletionItem build(Symbol bSymbol, String label, String detail) {
        CompletionItemLabelDetails completionItemLabelDetails = new CompletionItemLabelDetails();
        completionItemLabelDetails.setDetail(detail);
        CompletionItem item = new CompletionItem();
        item.setLabel(label);
        String insertText = CommonUtil.escapeSpecialCharsInInsertText((String)label);
        item.setInsertText(insertText);
        TypeCompletionItemBuilder.setMeta(item, bSymbol, completionItemLabelDetails);
        item.setLabelDetails(completionItemLabelDetails);
        return item;
    }

    private static void setMeta(CompletionItem item, Symbol bSymbol, CompletionItemLabelDetails completionItemLabelDetails) {
        Documentable documentableSymbol;
        if (bSymbol == null) {
            item.setKind(CompletionItemKind.Unit);
            completionItemLabelDetails.setDescription("type");
            return;
        }
        if (bSymbol.kind() == SymbolKind.MODULE) {
            item.setKind(CompletionItemKind.Module);
            return;
        }
        if (bSymbol.kind() == SymbolKind.ENUM) {
            item.setKind(CompletionItemKind.Enum);
            completionItemLabelDetails.setDescription("enum");
            return;
        }
        Optional<TypeSymbol> typeDescriptor = SymbolUtil.getTypeDescriptor((Symbol)bSymbol);
        Optional<TypeSymbol> optional = typeDescriptor = typeDescriptor.isPresent() && ((TypeSymbol)typeDescriptor.get()).typeKind() == TypeDescKind.TYPE_REFERENCE ? Optional.of(((TypeReferenceTypeSymbol)typeDescriptor.get()).typeDescriptor()) : typeDescriptor;
        if (typeDescriptor.isEmpty() || ((TypeSymbol)typeDescriptor.get()).typeKind() == null || typeDescriptor.get().typeKind() == TypeDescKind.COMPILATION_ERROR) {
            item.setKind(CompletionItemKind.Unit);
            completionItemLabelDetails.setDescription("type");
            return;
        }
        CompletionItemKind itemKind = switch (typeDescriptor.get().typeKind()) {
            case TypeDescKind.UNION -> {
                ArrayList memberTypes = new ArrayList(((UnionTypeSymbol)typeDescriptor.get()).memberTypeDescriptors());
                if (memberTypes.isEmpty()) {
                    completionItemLabelDetails.setDescription("type");
                    yield CompletionItemKind.Unit;
                }
                boolean allMatch = memberTypes.stream().allMatch(typeDesc -> typeDesc.typeKind() == ((TypeSymbol)memberTypes.get(0)).typeKind());
                if (allMatch) {
                    switch (((TypeSymbol)memberTypes.get(0)).typeKind()) {
                        case ERROR: {
                            yield CompletionItemKind.Event;
                        }
                        case RECORD: {
                            yield CompletionItemKind.Struct;
                        }
                        case OBJECT: {
                            yield CompletionItemKind.Interface;
                        }
                    }
                    yield CompletionItemKind.TypeParameter;
                }
                yield CompletionItemKind.Enum;
            }
            case TypeDescKind.RECORD -> CompletionItemKind.Struct;
            case TypeDescKind.OBJECT -> CompletionItemKind.Interface;
            case TypeDescKind.ERROR -> CompletionItemKind.Event;
            default -> CompletionItemKind.TypeParameter;
        };
        item.setKind(itemKind);
        Documentable documentable = documentableSymbol = bSymbol instanceof Documentable ? (Documentable)bSymbol : null;
        if (documentableSymbol != null && documentableSymbol.documentation().isPresent() && ((Documentation)documentableSymbol.documentation().get()).description().isPresent()) {
            item.setDocumentation((String)((Documentation)documentableSymbol.documentation().get()).description().get());
        }
        String name = typeDescriptor.get().kind() == SymbolKind.CLASS ? typeDescriptor.get().kind().name() : typeDescriptor.get().typeKind().getName();
        String detail = name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1).toLowerCase(Locale.ENGLISH);
        completionItemLabelDetails.setDescription(detail);
    }
}

