/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.EnumSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.flowmodelgenerator.core.TypeCompletionItemBuilder;
import io.ballerina.flowmodelgenerator.core.expressioneditor.DocumentContext;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.model.types.TypeKind;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class TypesGenerator {
    private final Map<String, TypeSymbol> typeSymbolMap = new LinkedHashMap<String, TypeSymbol>();
    private final Map<String, CompletionItem> completionItemMap = new LinkedHashMap<String, CompletionItem>();
    private final Map<String, List<CompletionItem>> subtypeItemsMap = new LinkedHashMap<String, List<CompletionItem>>();
    private volatile boolean initialized = false;
    private static final String LANG_ANNOTATIONS_MODULE = "lang.annotations";
    private static final String USER_DEFINED_TYPE = "User-Defined";
    private static final String VARIABLE_TYPE = "Used Variable Types";
    private static final List<SymbolKind> TYPE_SYMBOL_KINDS = List.of(SymbolKind.TYPE_DEFINITION, SymbolKind.CLASS, SymbolKind.ENUM);
    public static final String TYPE_BOOLEAN = TypeKind.BOOLEAN.typeName();
    public static final String TYPE_DECIMAL = TypeKind.DECIMAL.typeName();
    public static final String TYPE_FLOAT = TypeKind.FLOAT.typeName();
    public static final String TYPE_INT = TypeKind.INT.typeName();
    public static final String TYPE_NIL = "()";
    public static final String TYPE_STRING = TypeKind.STRING.typeName();
    public static final String TYPE_XML = TypeKind.XML.typeName();
    public static final String TYPE_ERROR = TypeKind.ERROR.typeName();
    public static final String TYPE_FUNCTION = TypeKind.FUNCTION.typeName();
    public static final String TYPE_FUTURE = TypeKind.FUTURE.typeName();
    public static final String TYPE_HANDLE = TypeKind.HANDLE.typeName();
    public static final String TYPE_STREAM = TypeKind.STREAM.typeName();
    public static final String TYPE_TYPEDESC = TypeKind.TYPEDESC.typeName();
    public static final String TYPE_BYTE_ARRAY = "byte[]";
    public static final String TYPE_MAP_JSON = "map<json>";
    public static final String TYPE_MAP_STRING = "map<string>";
    public static final String TYPE_JSON_ARRAY = "json[]";
    public static final String TYPE_STRING_ARRAY = "string[]";
    public static final String TYPE_ANY = TypeKind.ANY.typeName();
    public static final String TYPE_ANYDATA = TypeKind.ANYDATA.typeName();
    public static final String TYPE_BYTE = TypeKind.BYTE.typeName();
    public static final String TYPE_JSON = TypeKind.JSON.typeName();
    public static final String TYPE_READONLY = TypeKind.READONLY.typeName();
    public static final String TYPE_RECORD = TypeKind.RECORD.typeName();
    private static final Map<String, List<String>> categoryMap = Map.of("Primitive Types", List.of(TYPE_STRING, TYPE_INT, TYPE_FLOAT, TYPE_DECIMAL, TYPE_BOOLEAN, "()", TYPE_BYTE), "Data Types", List.of(TYPE_JSON, TYPE_XML, TYPE_ANYDATA), "Structural Types", List.of("byte[]", "map<json>", "map<string>", "json[]", "string[]", TYPE_RECORD), "Error Types", List.of(TYPE_ERROR), "Behaviour Types", List.of(TYPE_FUNCTION, TYPE_FUTURE, TYPE_TYPEDESC, TYPE_HANDLE, TYPE_STREAM), "Other Types", List.of(TYPE_ANY, TYPE_READONLY));

    private TypesGenerator() {
    }

    public Either<List<CompletionItem>, CompletionList> getTypes(DocumentContext documentContext, String typeConstraint, LinePosition linePosition) {
        Optional<SemanticModel> optionalSemanticModel = documentContext.semanticModel();
        if (optionalSemanticModel.isEmpty()) {
            return Either.forLeft(new ArrayList());
        }
        SemanticModel semanticModel = optionalSemanticModel.get();
        this.initializeBuiltinTypes(semanticModel);
        Optional<ModuleInfo> userModuleInfo = documentContext.module().map(module -> ModuleInfo.from((ModuleDescriptor)module.descriptor()));
        TypeSymbol typeConstraintSymbol = this.typeSymbolMap.get(typeConstraint);
        List symbols = linePosition == null ? semanticModel.moduleSymbols() : semanticModel.visibleSymbols(documentContext.document(), linePosition);
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        for (Symbol symbol : symbols) {
            if (symbol.kind() == SymbolKind.VARIABLE && userModuleInfo.isPresent()) {
                VariableSymbol variableSymbol = (VariableSymbol)symbol;
                TypeSymbol variableTypeSymbol = variableSymbol.typeDescriptor();
                if (this.isInvalidTypeSymbol((Symbol)variableTypeSymbol, typeConstraintSymbol)) continue;
                completionItems.add(TypeCompletionItemBuilder.build((Symbol)variableTypeSymbol, CommonUtils.getTypeSignature((SemanticModel)semanticModel, (TypeSymbol)variableTypeSymbol, (boolean)false, (ModuleInfo)userModuleInfo.get()), VARIABLE_TYPE));
                continue;
            }
            if (!TYPE_SYMBOL_KINDS.contains(symbol.kind()) || this.isInvalidTypeSymbol(symbol, typeConstraintSymbol) || symbol.getModule().map(moduleSymbol -> moduleSymbol.nameEquals(LANG_ANNOTATIONS_MODULE)).orElse(false).booleanValue()) continue;
            completionItems.add(TypeCompletionItemBuilder.build(symbol, symbol.getName().orElse(""), USER_DEFINED_TYPE));
        }
        if (typeConstraintSymbol == null) {
            completionItems.addAll(this.completionItemMap.values());
        } else {
            List<CompletionItem> subtypeItems = this.subtypeItemsMap.get(typeConstraintSymbol.signature());
            if (subtypeItems != null) {
                completionItems.addAll(subtypeItems);
            }
        }
        return Either.forLeft(completionItems);
    }

    private boolean isInvalidTypeSymbol(Symbol symbol, TypeSymbol typeConstraintSymbol) {
        ClassSymbol childTypeSymbol;
        if (typeConstraintSymbol == null) {
            return false;
        }
        switch (symbol.kind()) {
            case TYPE_DEFINITION: {
                ClassSymbol classSymbol = ((TypeDefinitionSymbol)symbol).typeDescriptor();
                break;
            }
            case CLASS: {
                ClassSymbol classSymbol = (ClassSymbol)symbol;
                break;
            }
            case ENUM: {
                ClassSymbol classSymbol = ((EnumSymbol)symbol).typeDescriptor();
                break;
            }
            case TYPE: {
                ClassSymbol classSymbol = (TypeSymbol)symbol;
                break;
            }
            default: {
                ClassSymbol classSymbol = childTypeSymbol = null;
            }
        }
        if (childTypeSymbol == null) {
            return true;
        }
        try {
            return !childTypeSymbol.subtypeOf(typeConstraintSymbol) || this.completionItemMap.containsKey(childTypeSymbol.signature());
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeBuiltinTypes(SemanticModel semanticModel) {
        if (this.initialized) {
            return;
        }
        TypesGenerator typesGenerator = this;
        synchronized (typesGenerator) {
            if (this.initialized) {
                return;
            }
            Types types = semanticModel.types();
            this.typeSymbolMap.put(TYPE_STRING, types.STRING);
            this.typeSymbolMap.put(TYPE_BOOLEAN, types.BOOLEAN);
            this.typeSymbolMap.put(TYPE_INT, types.INT);
            this.typeSymbolMap.put(TYPE_NIL, types.NIL);
            this.typeSymbolMap.put(TYPE_FLOAT, types.FLOAT);
            this.typeSymbolMap.put(TYPE_DECIMAL, types.DECIMAL);
            this.typeSymbolMap.put(TYPE_XML, types.XML);
            this.typeSymbolMap.put(TYPE_BYTE, types.BYTE);
            this.typeSymbolMap.put(TYPE_ERROR, types.ERROR);
            this.typeSymbolMap.put(TYPE_JSON, types.JSON);
            this.typeSymbolMap.put(TYPE_ANY, types.ANY);
            this.typeSymbolMap.put(TYPE_ANYDATA, types.ANYDATA);
            this.typeSymbolMap.put(TYPE_FUNCTION, types.FUNCTION);
            this.typeSymbolMap.put(TYPE_FUTURE, types.FUTURE);
            this.typeSymbolMap.put(TYPE_TYPEDESC, types.TYPEDESC);
            this.typeSymbolMap.put(TYPE_HANDLE, types.HANDLE);
            this.typeSymbolMap.put(TYPE_STREAM, (TypeSymbol)types.builder().STREAM_TYPE.withValueType(types.ANYDATA).withCompletionType(types.ERROR).build());
            this.typeSymbolMap.put(TYPE_READONLY, types.READONLY);
            this.typeSymbolMap.put(TYPE_RECORD, (TypeSymbol)types.builder().RECORD_TYPE.withRestField(types.ANYDATA).build());
            this.typeSymbolMap.put(TYPE_MAP_JSON, (TypeSymbol)types.builder().MAP_TYPE.withTypeParam(types.JSON).build());
            this.typeSymbolMap.put(TYPE_MAP_STRING, (TypeSymbol)types.builder().MAP_TYPE.withTypeParam(types.STRING).build());
            this.typeSymbolMap.put(TYPE_JSON_ARRAY, (TypeSymbol)types.builder().ARRAY_TYPE.withType(types.JSON).build());
            this.typeSymbolMap.put(TYPE_BYTE_ARRAY, (TypeSymbol)types.builder().ARRAY_TYPE.withType(types.BYTE).build());
            this.typeSymbolMap.put(TYPE_STRING_ARRAY, (TypeSymbol)types.builder().ARRAY_TYPE.withType(types.STRING).build());
            categoryMap.forEach((category, typeNames) -> typeNames.forEach(typeName -> {
                TypeSymbol symbol = this.typeSymbolMap.get(typeName);
                this.completionItemMap.put(symbol.signature(), TypeCompletionItemBuilder.build((Symbol)symbol, typeName, category));
            }));
            this.typeSymbolMap.forEach((name, symbol) -> {
                List<CompletionItem> completionsList = this.typeSymbolMap.values().stream().filter(typeSymbol -> typeSymbol.subtypeOf(symbol)).map(typeSymbol -> this.completionItemMap.get(typeSymbol.signature())).toList();
                this.subtypeItemsMap.put(symbol.signature(), completionsList);
            });
            this.initialized = true;
        }
    }

    public static TypesGenerator getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final TypesGenerator INSTANCE = new TypesGenerator();

        private Holder() {
        }
    }
}

