/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.util.PathSegment;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.projects.Document;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.diagramutil.connector.models.connector.Type;
import org.ballerinalang.langserver.common.utils.PositionUtil;

public class VisibleVariableTypesGenerator {
    private final SemanticModel semanticModel;
    private final Document document;
    private final LinePosition position;
    private final Gson gson;
    private final Map<String, List<Category.Variable>> categoryMap;
    private static final List<String> CATEGORY_ORDER = Arrays.asList("Local Variables", "Module Variables", "Configurable Variables", "Parameters", "Path Parameters");

    public VisibleVariableTypesGenerator(SemanticModel semanticModel, Document document, LinePosition position) {
        this.semanticModel = semanticModel;
        this.document = document;
        this.position = position;
        this.gson = new Gson();
        this.categoryMap = new HashMap<String, List<Category.Variable>>();
    }

    public JsonArray getVisibleVariableTypes() {
        Optional<LineRange> functionLineRange = this.findFunctionLineRange();
        List symbols = this.semanticModel.visibleSymbols(this.document, this.position);
        for (Symbol symbol : symbols) {
            String name;
            Type type;
            if (symbol.kind() == SymbolKind.VARIABLE) {
                TypeSymbol effectiveTypeSymbol;
                VariableSymbol variableSymbol = (VariableSymbol)symbol;
                String name2 = variableSymbol.getName().orElse("");
                type = this.fromTypeSymbol(variableSymbol.typeDescriptor());
                TypeSymbol typeSymbol = variableSymbol.typeDescriptor();
                if (typeSymbol instanceof TypeReferenceTypeSymbol) {
                    TypeReferenceTypeSymbol typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)typeSymbol;
                    effectiveTypeSymbol = typeReferenceTypeSymbol.typeDescriptor();
                } else {
                    effectiveTypeSymbol = typeSymbol;
                }
                if (effectiveTypeSymbol instanceof ObjectTypeSymbol) continue;
                if (variableSymbol.qualifiers().contains(Qualifier.CONFIGURABLE)) {
                    this.addCategoryValue("Configurable Variables", name2, type);
                    continue;
                }
                if (functionLineRange.isPresent() && this.isInFunctionRange(variableSymbol, functionLineRange.get())) {
                    this.addCategoryValue("Local Variables", name2, type);
                    continue;
                }
                this.addCategoryValue("Module Variables", name2, type);
                continue;
            }
            if (symbol.kind() == SymbolKind.PARAMETER) {
                name = symbol.getName().orElse("");
                Type type2 = this.fromTypeSymbol(((ParameterSymbol)symbol).typeDescriptor());
                this.addCategoryValue("Parameters", name, type2);
                continue;
            }
            if (symbol.kind() != SymbolKind.PATH_PARAMETER) continue;
            name = symbol.getName().orElse("");
            PathParameterSymbol pathParameterSymbol = (PathParameterSymbol)symbol;
            type = this.fromTypeSymbol(pathParameterSymbol.typeDescriptor());
            type.isRestType = pathParameterSymbol.pathSegmentKind() == PathSegment.Kind.PATH_REST_PARAMETER;
            this.addCategoryValue("Path Parameters", name, type);
        }
        ArrayList<Category> categories = new ArrayList<Category>();
        for (String categoryName : CATEGORY_ORDER) {
            List<Category.Variable> variables = this.categoryMap.get(categoryName);
            if (variables == null) continue;
            Collections.sort(variables);
            categories.add(new Category(categoryName, variables));
        }
        return this.gson.toJsonTree(categories).getAsJsonArray();
    }

    private Type fromTypeSymbol(TypeSymbol typeSymbol) {
        String typeName = CommonUtils.getTypeSignature((SemanticModel)this.semanticModel, (TypeSymbol)typeSymbol, (boolean)false, (ModuleInfo)ModuleInfo.from((ModuleDescriptor)this.document.module().descriptor()));
        Type newType = new Type();
        newType.typeName = this.getTypeName(typeSymbol);
        newType.name = typeName;
        return newType;
    }

    private String getTypeName(TypeSymbol typeSymbol) {
        if (typeSymbol instanceof RecordTypeSymbol) {
            return "record";
        }
        if (typeSymbol instanceof ArrayTypeSymbol) {
            return "array";
        }
        if (typeSymbol instanceof MapTypeSymbol) {
            return "map";
        }
        if (typeSymbol instanceof TableTypeSymbol) {
            return "table";
        }
        if (typeSymbol instanceof UnionTypeSymbol) {
            return "union";
        }
        if (typeSymbol instanceof ErrorTypeSymbol) {
            return "error";
        }
        if (typeSymbol instanceof IntersectionTypeSymbol) {
            return "intersection";
        }
        if (typeSymbol instanceof StreamTypeSymbol) {
            return "stream";
        }
        if (typeSymbol instanceof ObjectTypeSymbol) {
            return "object";
        }
        if (typeSymbol instanceof TypeReferenceTypeSymbol) {
            TypeReferenceTypeSymbol typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)typeSymbol;
            if (typeReferenceTypeSymbol.definition().kind().equals((Object)SymbolKind.ENUM)) {
                return "enum";
            }
            return this.getTypeName(typeReferenceTypeSymbol.typeDescriptor());
        }
        String typeName = typeSymbol.signature();
        if (typeName.startsWith("\"") && typeName.endsWith("\"")) {
            typeName = typeName.substring(1, typeName.length() - 1);
        }
        return typeName;
    }

    private void addCategoryValue(String categoryName, String name, Type type) {
        this.categoryMap.computeIfAbsent(categoryName, k -> new ArrayList()).add(new Category.Variable(name, type));
    }

    private boolean isInFunctionRange(VariableSymbol variableSymbol, LineRange functionLineRange) {
        return variableSymbol.getLocation().map(loc -> {
            LineRange variableLineRange = loc.lineRange();
            if (!variableLineRange.fileName().equals(functionLineRange.fileName())) {
                return false;
            }
            return PositionUtil.isWithinLineRange((LineRange)variableLineRange, (LineRange)functionLineRange);
        }).orElse(false);
    }

    private Optional<LineRange> findFunctionLineRange() {
        NonTerminalNode parent;
        ModulePartNode rootNode = (ModulePartNode)this.document.syntaxTree().rootNode();
        for (parent = rootNode.findNode(TextRange.from((int)this.document.textDocument().textPositionFrom(this.position), (int)0)); parent != null && VisibleVariableTypesGenerator.notDefinitionKind(parent.kind()); parent = parent.parent()) {
        }
        return parent == null ? Optional.empty() : Optional.of(parent.lineRange());
    }

    private static boolean notDefinitionKind(SyntaxKind kind) {
        return kind != SyntaxKind.FUNCTION_DEFINITION && kind != SyntaxKind.RESOURCE_ACCESSOR_DEFINITION;
    }

    private record Category(String name, List<Variable> types) {
        public static final String LOCAL_CATEGORY = "Local Variables";
        public static final String MODULE_CATEGORY = "Module Variables";
        public static final String CONFIGURABLE_CATEGORY = "Configurable Variables";
        public static final String PARAMETER_CATEGORY = "Parameters";
        public static final String PATH_PARAMETER_CATEGORY = "Path Parameters";

        public record Variable(String name, Type type) implements Comparable<Variable>
        {
            @Override
            public int compareTo(Variable o) {
                return this.name.compareTo(o.name);
            }
        }
    }
}

