/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.expressioneditor;

import io.ballerina.flowmodelgenerator.core.expressioneditor.services.DebouncedExpressionEditorRequest;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Debouncer {
    private static final TimeUnit TIME_UNIT = TimeUnit.MILLISECONDS;
    private final ConcurrentHashMap<String, ScheduledTaskHolder<?>> delayedMap;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    private Debouncer() {
        this.delayedMap = new ConcurrentHashMap();
    }

    public <T> CompletableFuture<T> debounce(DebouncedExpressionEditorRequest<T> request) {
        ScheduledFuture<?> scheduledFuture;
        CompletableFuture promise;
        long delay = request.getDelay();
        String key = request.getKey();
        ScheduledTaskHolder prev = this.delayedMap.put(key, new ScheduledTaskHolder(promise = new CompletableFuture(), scheduledFuture = this.scheduler.schedule(() -> {
            try {
                Object result = request.call();
                promise.complete(result);
            }
            catch (Exception ex) {
                promise.completeExceptionally(ex);
            }
            finally {
                if (promise.isCompletedExceptionally()) {
                    request.revertDocument();
                }
                this.delayedMap.remove(key);
            }
        }, delay, TIME_UNIT)));
        if (prev != null) {
            prev.future().cancel(true);
            prev.promise().completeExceptionally(new CancellationException("Debounced by a new request"));
        }
        return promise;
    }

    public static Debouncer getInstance() {
        return Holder.INSTANCE;
    }

    private record ScheduledTaskHolder<T>(CompletableFuture<T> promise, Future<?> future) {
    }

    private static class Holder {
        private static final Debouncer INSTANCE = new Debouncer();

        private Holder() {
        }
    }
}

