/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.expressioneditor;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManagerProxy;

public class DocumentContext {
    private final WorkspaceManagerProxy workspaceManagerProxy;
    private final String inputFileUri;
    private final Path inputFilePath;
    private String fileUri;
    private Path filePath;
    private Project project;
    private Document document;
    private Module module;
    private SemanticModel semanticModel;
    private List<ImportDeclarationNode> imports;
    private WorkspaceManager workspaceManager;
    private boolean initialized;

    public DocumentContext(WorkspaceManagerProxy workspaceManagerProxy, Path filePath) {
        this(workspaceManagerProxy, null, filePath, null);
    }

    public DocumentContext(WorkspaceManagerProxy workspaceManagerProxy, String fileUri, Path filePath) {
        this(workspaceManagerProxy, fileUri, filePath, null);
    }

    public DocumentContext(WorkspaceManagerProxy workspaceManagerProxy, String fileUri, Path filePath, Document document) {
        this.workspaceManagerProxy = workspaceManagerProxy;
        this.inputFileUri = fileUri;
        this.inputFilePath = filePath;
        this.document = document;
        this.initialized = false;
    }

    public WorkspaceManager workspaceManager() {
        if (this.workspaceManager == null) {
            this.fileUri = this.inputFileUri == null ? CommonUtils.getExprUri((String)this.inputFilePath.toString()) : this.inputFileUri;
            this.workspaceManager = this.workspaceManagerProxy.get(this.fileUri);
        }
        return this.workspaceManager;
    }

    public Optional<Project> project() {
        if (this.project != null) {
            return Optional.of(this.project);
        }
        try {
            this.project = this.workspaceManager().loadProject(this.inputFilePath);
            return Optional.of(this.project);
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    public Optional<Module> module() {
        if (this.module != null) {
            return Optional.of(this.module);
        }
        this.initialize();
        Optional optModule = this.workspaceManager().module(this.filePath);
        optModule.ifPresent(mod -> {
            this.module = mod;
        });
        return optModule;
    }

    public Optional<SemanticModel> semanticModel() {
        if (this.semanticModel != null) {
            return Optional.of(this.semanticModel);
        }
        this.initialize();
        Optional optSemanticModel = this.workspaceManager().semanticModel(this.filePath);
        optSemanticModel.ifPresent(model -> {
            this.semanticModel = model;
        });
        return optSemanticModel;
    }

    public String fileUri() {
        if (this.fileUri == null) {
            this.initialize();
        }
        return this.fileUri;
    }

    public Document document() {
        if (this.document == null) {
            this.initialize();
        }
        return this.document;
    }

    public Path filePath() {
        if (this.filePath == null) {
            this.initialize();
        }
        return this.filePath;
    }

    public List<ImportDeclarationNode> imports() {
        if (this.imports == null) {
            this.initialize();
            SyntaxTree syntaxTree = this.document.syntaxTree();
            this.imports = syntaxTree.rootNode().kind() == SyntaxKind.MODULE_PART ? ((ModulePartNode)syntaxTree.rootNode()).imports().stream().toList() : List.of();
        }
        return this.imports;
    }

    private void initialize() {
        Optional inputDoc;
        if (this.initialized) {
            return;
        }
        PackageUtil.loadProject((WorkspaceManager)this.workspaceManager(), (Path)this.inputFilePath);
        try {
            inputDoc = this.workspaceManager.document(this.inputFilePath);
        }
        catch (Throwable t) {
            inputDoc = Optional.empty();
        }
        if (inputDoc.isPresent()) {
            this.document = (Document)inputDoc.get();
            this.filePath = this.inputFilePath;
            this.fileUri = this.fileUri == null ? CommonUtils.getExprUri((String)this.filePath.toString()) : this.inputFileUri;
            this.initialized = true;
            return;
        }
        Optional optModule = this.workspaceManager().module(this.inputFilePath);
        if (optModule.isPresent()) {
            this.module = (Module)optModule.get();
        } else {
            Optional<Project> project = this.project();
            if (project.isEmpty()) {
                throw new IllegalStateException("Project not found for the file: " + String.valueOf(this.inputFilePath));
            }
            this.module = project.get().currentPackage().getDefaultModule();
        }
        Collection documentIds = this.module.documentIds();
        if (documentIds.isEmpty()) {
            throw new IllegalStateException("No documents found in the module: " + String.valueOf(this.module.moduleName()));
        }
        DocumentId documentId = (DocumentId)documentIds.iterator().next();
        this.document = this.module.document(documentId);
        this.filePath = this.inputFilePath.resolve(this.document.name());
        this.fileUri = CommonUtils.getExprUri((String)this.filePath.toString());
        this.initialized = true;
    }

    public void clear() {
        this.initialized = false;
        this.document = null;
        this.module = null;
        this.project = null;
        this.semanticModel = null;
    }
}

