/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.expressioneditor;

import com.google.gson.JsonObject;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.expressioneditor.DocumentContext;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManagerProxy;
import org.eclipse.lsp4j.Position;

public class ExpressionEditorContext {
    private final Info info;
    private final DocumentContext documentContext;
    private final Property property;
    private int expressionOffset;
    private LineRange statementLineRange;
    private LinePosition startLine;
    private int numberOfLines;

    public ExpressionEditorContext(WorkspaceManagerProxy workspaceManagerProxy, String fileUri, Info info, Path filePath) {
        this.info = info;
        this.numberOfLines = info.expression().split(System.lineSeparator()).length - 1;
        this.documentContext = new DocumentContext(workspaceManagerProxy, fileUri, filePath);
        this.property = new Property(info.property(), info.codedata());
    }

    public ExpressionEditorContext(WorkspaceManagerProxy workspaceManagerProxy, String fileUri, Path filePath, Document document) {
        this.info = null;
        this.documentContext = new DocumentContext(workspaceManagerProxy, fileUri, filePath, document);
        this.property = new Property(null, null);
    }

    public boolean isNodeKind(List<NodeKind> nodeKinds) {
        NodeKind nodeKind = this.property.nodeKind();
        return nodeKind != null && nodeKinds.contains((Object)nodeKind);
    }

    public LinePosition getStartLine() {
        List<ImportDeclarationNode> imports = this.documentContext.imports();
        if (imports.isEmpty()) {
            return this.info.startLine();
        }
        LinePosition importEndLine = imports.getLast().lineRange().endLine();
        if (CommonUtils.isLinePositionAfter((LinePosition)this.info.startLine(), (LinePosition)importEndLine)) {
            return this.info.startLine();
        }
        return importEndLine;
    }

    public Info info() {
        return this.info;
    }

    public LinePosition startLine() {
        if (this.startLine == null) {
            this.startLine = CommonUtils.getPosition((LinePosition)this.info.startLine(), (Document)this.documentContext.document());
        }
        return this.startLine;
    }

    private Optional<TextEdit> getImport() {
        String org = this.property.org();
        String module = this.property.module();
        if (org == null || module == null || CommonUtils.isPredefinedLangLib((String)org, (String)module)) {
            return Optional.empty();
        }
        return this.getImport(CommonUtils.getImportStatement((String)org, (String)module, (String)module));
    }

    public Optional<TextEdit> getImport(String importStatement) {
        ModuleDescriptor descriptor;
        this.documentContext.project();
        Optional<Module> currentModule = this.documentContext.module();
        if (currentModule.isPresent() && CommonUtils.getImportStatement((String)(descriptor = currentModule.get().descriptor()).org().toString(), (String)descriptor.packageName().value(), (String)descriptor.name().toString()).equals(importStatement)) {
            return Optional.empty();
        }
        boolean importExists = this.documentContext.imports().stream().anyMatch(importDeclarationNode -> {
            String importText = importDeclarationNode.toSourceCode().trim();
            return importText.startsWith("import " + importStatement) && importText.endsWith(";");
        });
        if (!importExists) {
            String stmt = new SourceBuilder.TokenBuilder(null).keyword(SyntaxKind.IMPORT_KEYWORD).name(importStatement).endOfStatement().build(SourceBuilder.SourceKind.IMPORT);
            TextEdit textEdit = TextEdit.from((TextRange)TextRange.from((int)0, (int)0), (String)(stmt + System.lineSeparator()));
            return Optional.of(textEdit);
        }
        return Optional.empty();
    }

    public LineRange generateStatement() {
        Optional<TextEdit> textEdit;
        String prefix = "any|error __reserved__ = ";
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        int lineOffset = 0;
        if (this.property != null) {
            Map<String, String> imports;
            if (this.property.valueTypeConstraint() != null) {
                prefix = String.format("%s __reserved__ = ", this.property.valueTypeConstraint());
            }
            if ((imports = this.property.importStatements()) != null && !imports.isEmpty()) {
                for (String importStmt : imports.values()) {
                    Optional<TextEdit> textEdit2 = this.getImport(importStmt.split(":")[0]);
                    if (!textEdit2.isPresent()) continue;
                    textEdits.add(textEdit2.get());
                    ++lineOffset;
                }
            }
        }
        if (this.isNodeKind(List.of(NodeKind.NEW_CONNECTION, NodeKind.FUNCTION_CALL, NodeKind.REMOTE_ACTION_CALL, NodeKind.RESOURCE_ACTION_CALL)) && (textEdit = this.getImport()).isPresent()) {
            textEdits.add(textEdit.get());
            ++lineOffset;
        }
        TextDocument textDocument = this.documentContext.document().textDocument();
        LinePosition cursorStartLine = this.startLine();
        int textPosition = textDocument.textPositionFrom(cursorStartLine);
        String statement = String.format("%s%s;%n", prefix, this.info.expression());
        this.expressionOffset = prefix.length();
        textEdits.add(TextEdit.from((TextRange)TextRange.from((int)textPosition, (int)0), (String)statement));
        this.applyTextEdits(textEdits);
        LinePosition startLine = LinePosition.from((int)(cursorStartLine.line() + lineOffset), (int)cursorStartLine.offset());
        LinePosition endLineRange = LinePosition.from((int)(startLine.line() + this.numberOfLines), (int)(startLine.offset() + statement.length()));
        this.statementLineRange = LineRange.from((String)this.getFileName(this.documentContext.filePath()), (LinePosition)startLine, (LinePosition)endLineRange);
        return this.statementLineRange;
    }

    public LineRange getExpressionLineRange() {
        LinePosition startLine = this.info().startLine();
        LinePosition endLine = LinePosition.from((int)(startLine.line() + this.numberOfLines), (int)(startLine.offset() + this.info().expression().length()));
        return LineRange.from((String)this.getFileName(this.documentContext.filePath()), (LinePosition)startLine, (LinePosition)endLine);
    }

    private String getFileName(Path filePath) {
        Path fileName = filePath.getFileName();
        return fileName == null ? filePath.toString() : fileName.toString();
    }

    public Position getCursorPosition() {
        if (this.statementLineRange == null || this.info == null) {
            throw new IllegalStateException("Statement line range not initialized. Call generateStatement() first.");
        }
        int lineOffset = this.info.lineOffset();
        int offsetChange = lineOffset > 0 ? 0 : this.expressionOffset + this.statementLineRange.startLine().offset();
        return new Position(this.statementLineRange.startLine().line() + lineOffset, this.info.offset() + offsetChange);
    }

    public void applyTextEdits(List<TextEdit> textEdits) {
        TextDocument newTextDocument = this.documentContext.document().textDocument().apply(TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0])));
        this.applyContent(newTextDocument);
    }

    public void applyContent(TextDocument textDocument) {
        this.documentContext.document().modify().withContent(String.join((CharSequence)System.lineSeparator(), textDocument.textLines())).apply();
        this.documentContext.clear();
    }

    public String fileUri() {
        return this.documentContext.fileUri();
    }

    public TextDocument textDocument() {
        return this.documentContext.document().textDocument();
    }

    public Path filePath() {
        return this.documentContext.filePath();
    }

    public WorkspaceManager workspaceManager() {
        return this.documentContext.workspaceManager();
    }

    public DocumentContext documentContext() {
        return this.documentContext;
    }

    public Property getProperty() {
        return this.property;
    }

    public record Info(String expression, LinePosition startLine, int offset, int lineOffset, JsonObject codedata, JsonObject property) {
    }

    public static class Property {
        private final JsonObject property;
        private final JsonObject codedata;
        private boolean initialized;
        private String value;
        private String valueType;
        private String typeConstraint;
        private Map<String, String> imports;
        private String org;
        private String module;
        private NodeKind nodeKind;
        private static final String VALUE_KEY = "value";
        private static final String VALUE_TYPE_KEY = "valueType";
        private static final String TYPE_CONSTRAINT_KEY = "valueTypeConstraint";
        private static final String IMPORTS_KEY = "imports";
        private static final String ORG_KEY = "org";
        private static final String MODULE_KEY = "module";
        private static final String NODE_KEY = "node";

        public Property(JsonObject property, JsonObject codedata) {
            this.property = property;
            this.codedata = codedata;
            this.initialized = false;
        }

        private void initialize() {
            if (this.initialized) {
                return;
            }
            if (this.property == null) {
                this.value = "";
                this.typeConstraint = null;
            } else {
                this.value = this.property.has(VALUE_KEY) ? this.property.get(VALUE_KEY).getAsString() : "";
                this.valueType = this.property.has(VALUE_TYPE_KEY) ? this.property.get(VALUE_TYPE_KEY).getAsString() : "";
                String string = this.typeConstraint = this.property.has(TYPE_CONSTRAINT_KEY) ? this.property.get(TYPE_CONSTRAINT_KEY).getAsString() : null;
                if (this.property.has(IMPORTS_KEY) && this.property.get(IMPORTS_KEY).isJsonObject()) {
                    JsonObject imports = this.property.getAsJsonObject(IMPORTS_KEY);
                    this.imports = new HashMap<String, String>();
                    for (String key : imports.keySet()) {
                        if (!imports.get(key).isJsonPrimitive()) continue;
                        this.imports.put(key, imports.get(key).getAsString());
                    }
                } else {
                    this.imports = null;
                }
            }
            if (this.codedata == null) {
                this.imports = null;
                this.org = "";
                this.module = "";
                this.nodeKind = null;
            } else {
                this.org = this.codedata.has(ORG_KEY) ? this.codedata.get(ORG_KEY).getAsString() : "";
                this.module = this.codedata.has(MODULE_KEY) ? this.codedata.get(MODULE_KEY).getAsString() : "";
                this.nodeKind = this.codedata.has(NODE_KEY) ? NodeKind.valueOf(this.codedata.get(NODE_KEY).getAsString()) : null;
            }
            this.initialized = true;
        }

        public String value() {
            this.initialize();
            return this.value;
        }

        public String valueType() {
            this.initialize();
            return this.valueType;
        }

        public String valueTypeConstraint() {
            this.initialize();
            return this.typeConstraint;
        }

        public Map<String, String> importStatements() {
            this.initialize();
            return this.imports;
        }

        public String org() {
            this.initialize();
            return this.org;
        }

        public String module() {
            this.initialize();
            return this.module;
        }

        public NodeKind nodeKind() {
            this.initialize();
            return this.nodeKind;
        }
    }
}

