/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.expressioneditor.services;

import io.ballerina.flowmodelgenerator.core.expressioneditor.ExpressionEditorContext;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.DebouncedExpressionEditorRequest;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpContext;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.services.TextDocumentService;

public class SignatureHelpRequest
extends DebouncedExpressionEditorRequest<SignatureHelp> {
    private final SignatureHelpContext signatureHelpContext;
    private final TextDocumentService textDocumentService;

    public SignatureHelpRequest(ExpressionEditorContext context, SignatureHelpContext signatureHelpContext, TextDocumentService textDocumentService) {
        super(context);
        this.signatureHelpContext = signatureHelpContext;
        this.textDocumentService = textDocumentService;
    }

    @Override
    public SignatureHelp getResponse(ExpressionEditorContext context) {
        context.generateStatement();
        Position position = context.getCursorPosition();
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(context.fileUri());
        SignatureHelpParams params = new SignatureHelpParams(identifier, position, this.signatureHelpContext);
        CompletableFuture future = this.textDocumentService.signatureHelp(params);
        return (SignatureHelp)future.join();
    }

    @Override
    public String getKey() {
        return "signatureHelp";
    }

    @Override
    public long getDelay() {
        return 150L;
    }
}

