/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.expressioneditor.services;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.flowmodelgenerator.core.expressioneditor.ExpressionEditorContext;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.DiagnosticsRequest;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.projects.Document;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.LineRange;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.Diagnostic;

public class TypeDiagnosticRequest
extends DiagnosticsRequest {
    private static final String UNDEFINED_TYPE = "undefined type '%s'";
    private static final String INVALID_SUBTYPE = "expected a subtype of '%s', but found '%s'";
    private static final DiagnosticErrorCode UNKNOWN_TYPE_ERROR_CODE = DiagnosticErrorCode.UNKNOWN_TYPE;

    public TypeDiagnosticRequest(ExpressionEditorContext context) {
        super(context);
    }

    @Override
    protected Node getParsedNode(String text) {
        return NodeParser.parseTypeDescriptor((String)this.getTrimmedOutput(text));
    }

    @Override
    protected Set<Diagnostic> getSemanticDiagnostics(ExpressionEditorContext context) {
        Optional semanticModel = context.workspaceManager().semanticModel(context.filePath());
        Optional document = context.workspaceManager().document(context.filePath());
        if (semanticModel.isEmpty() || document.isEmpty()) {
            return Set.of();
        }
        HashSet<Diagnostic> diagnostics = new HashSet<Diagnostic>();
        String inputExpression = this.getTrimmedOutput(context.info().expression());
        Types types = ((SemanticModel)semanticModel.get()).types();
        Optional typeSymbol = types.getType((Document)document.get(), inputExpression);
        if (typeSymbol.isEmpty()) {
            String message = String.format(UNDEFINED_TYPE, inputExpression);
            diagnostics.add(CommonUtils.createDiagnostic((String)message, (LineRange)context.getExpressionLineRange(), (DiagnosticErrorCode)UNKNOWN_TYPE_ERROR_CODE));
            return diagnostics;
        }
        String typeConstraint = context.getProperty().valueTypeConstraint();
        if (typeConstraint == null) {
            return diagnostics;
        }
        Optional typeConstraintTypeSymbol = types.getType((Document)document.get(), typeConstraint);
        if (typeConstraintTypeSymbol.isPresent() && !((TypeSymbol)typeSymbol.get()).subtypeOf((TypeSymbol)typeConstraintTypeSymbol.get())) {
            String message = String.format(INVALID_SUBTYPE, typeConstraint, inputExpression);
            diagnostics.add(CommonUtils.createDiagnostic((String)message, (LineRange)context.getExpressionLineRange(), (String)"", (DiagnosticSeverity)DiagnosticSeverity.ERROR));
        }
        return diagnostics;
    }

    private String getTrimmedOutput(String text) {
        String trimmedInput = text.trim();
        if (trimmedInput.startsWith("readonly ")) {
            return trimmedInput.substring(9);
        }
        return text;
    }
}

