/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.flowmodelgenerator.core.model.Branch;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.FacetedBuilder;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.utils.FileSystemUtils;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.DefaultValueGeneratorUtil;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.modelgenerator.commons.ParameterData;
import io.ballerina.projects.Document;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.Package;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.formatter.core.FormattingTreeModifier;
import org.ballerinalang.formatter.core.options.FormattingOptions;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.RecordUtil;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class SourceBuilder {
    private TokenBuilder tokenBuilder = new TokenBuilder(this);
    public final Path filePath;
    public final FlowNode flowNode;
    public final WorkspaceManager workspaceManager;
    private final Map<Path, List<TextEdit>> textEditsMap = new HashMap<Path, List<TextEdit>>();
    private final Set<String> imports;
    private final LSClientLogger lsClientLogger;
    private Range defaultRange;
    private static final String CONNECTIONS_BAL = "connections.bal";
    private static final String AUTOMATION_BAL = "automation.bal";
    private static final String AGENTS_BAL = "agents.bal";
    private static final String DATA_MAPPINGS_BAL = "data_mappings.bal";
    private static final String FUNCTIONS_BAL = "functions.bal";
    private static final String BALLERINA_FILE_SUFFIX = ".bal";

    public SourceBuilder(FlowNode flowNode, WorkspaceManager workspaceManager, Path filePath, LSClientLogger lsClientLogger) {
        this.flowNode = flowNode;
        this.workspaceManager = workspaceManager;
        this.imports = new HashSet<String>();
        this.lsClientLogger = lsClientLogger;
        Codedata codedata = flowNode.codedata();
        if (codedata == null) {
            this.filePath = filePath;
        } else {
            NodeKind nodeKind = codedata.node();
            if (filePath.endsWith(AGENTS_BAL) && (nodeKind == NodeKind.FUNCTION_DEFINITION || nodeKind == NodeKind.CLASS_INIT || nodeKind == NodeKind.RESOURCE_ACTION_CALL || nodeKind == NodeKind.REMOTE_ACTION_CALL)) {
                nodeKind = NodeKind.AGENT;
            }
            this.filePath = this.resolvePath(filePath, nodeKind, codedata.lineRange(), codedata.isNew());
        }
    }

    public SourceBuilder(FlowNode flowNode, WorkspaceManager workspaceManager, Path filePath) {
        this(flowNode, workspaceManager, filePath, null);
    }

    private Path resolvePath(Path inputPath, NodeKind node, LineRange lineRange, Boolean isNew) {
        if (Boolean.TRUE.equals(isNew) || lineRange == null) {
            String defaultFile;
            switch (node) {
                case NEW_CONNECTION: {
                    String string = CONNECTIONS_BAL;
                    break;
                }
                case DATA_MAPPER_DEFINITION: {
                    String string = DATA_MAPPINGS_BAL;
                    break;
                }
                case FUNCTION_DEFINITION: 
                case NP_FUNCTION: {
                    String string = FUNCTIONS_BAL;
                    break;
                }
                case AUTOMATION: {
                    String string = AUTOMATION_BAL;
                    break;
                }
                case AGENT: {
                    String string = AGENTS_BAL;
                    break;
                }
                default: {
                    String string = defaultFile = null;
                }
            }
            if (defaultFile == null) {
                if (lineRange == null) {
                    throw new IllegalArgumentException("Cannot determine the line range");
                }
                this.defaultRange = CommonUtils.toRange((LineRange)lineRange);
                return inputPath;
            }
            Path resolvedPath = this.workspaceManager.projectRoot(inputPath).resolve(defaultFile);
            try {
                this.workspaceManager.loadProject(inputPath);
                Document document = FileSystemUtils.getDocument(this.workspaceManager, resolvedPath);
                this.defaultRange = CommonUtils.toRange((LinePosition)document.syntaxTree().rootNode().lineRange().endLine());
            }
            catch (EventSyncException | WorkspaceDocumentException e) {
                throw new RuntimeException(e);
            }
            return resolvedPath;
        }
        this.defaultRange = CommonUtils.toRange((LineRange)lineRange);
        if (!inputPath.toString().endsWith(BALLERINA_FILE_SUFFIX)) {
            return inputPath.resolve(lineRange.fileName());
        }
        return inputPath;
    }

    public TokenBuilder token() {
        return this.tokenBuilder;
    }

    public SourceBuilder newVariable() {
        return this.newVariable("type");
    }

    public SourceBuilder newVariableWithInferredType() {
        Optional<Property> inferredParam;
        Optional<Property> optionalType = this.getProperty("type");
        Optional<Property> variable = this.getProperty("variable");
        if (optionalType.isEmpty() || variable.isEmpty()) {
            return this;
        }
        Property type = optionalType.get();
        String typeName = type.value().toString();
        if (this.flowNode.codedata().inferredReturnType() != null && (inferredParam = this.flowNode.properties().values().stream().filter(property -> property.codedata() != null && property.codedata().kind() != null && property.codedata().kind().equals(ParameterData.Kind.PARAM_FOR_TYPE_INFER.name())).findFirst()).isPresent()) {
            String returnType = this.flowNode.codedata().inferredReturnType();
            String inferredType = inferredParam.get().value().toString();
            String inferredTypeDef = inferredParam.get().metadata().label();
            typeName = returnType.replace(inferredTypeDef, inferredType);
        }
        this.tokenBuilder.expressionWithType(typeName, variable.get()).keyword(SyntaxKind.EQUAL_TOKEN);
        return this;
    }

    public SourceBuilder newVariable(String typeKey) {
        Optional<Property> type = this.getProperty(typeKey);
        Optional<Property> variable = this.getProperty("variable");
        if (type.isPresent() && variable.isPresent()) {
            this.tokenBuilder.expressionWithType(type.get(), variable.get()).keyword(SyntaxKind.EQUAL_TOKEN);
        }
        return this;
    }

    public SourceBuilder acceptImportWithVariableType() {
        Property type;
        Optional<Property> optionalType = this.getProperty("type");
        if (optionalType.isPresent() && (type = optionalType.get()).imports() != null && this.getProperty("checkError").map(property -> property.value().equals("false")).orElse(true).booleanValue()) {
            type.imports().values().forEach(moduleId -> {
                String[] importParts = moduleId.split("/");
                this.acceptImport(importParts[0], importParts[1].split(":")[0]);
            });
        }
        this.acceptImport();
        return this;
    }

    public Optional<Property> getProperty(String key) {
        Optional<Property> property = this.flowNode.getProperty(key);
        property.ifPresent(prop -> {
            Map<String, String> propImports = prop.imports();
            if (propImports != null) {
                propImports.values().forEach(propImport -> this.imports.add(propImport.split(":")[0]));
            }
        });
        return property;
    }

    public SourceBuilder acceptImport() {
        Codedata codedata = this.flowNode.codedata();
        String org = codedata.org();
        String module = codedata.module();
        return this.acceptImport(org, module);
    }

    public SourceBuilder addImport(String text) {
        this.imports.add(text);
        return this;
    }

    public SourceBuilder acceptImport(String org, String module) {
        return this.acceptImport(org, module, false);
    }

    public SourceBuilder acceptImport(String org, String module, boolean defaultNamespace) {
        if (org == null || module == null || org.equals("ballerina") && CommonUtil.PRE_DECLARED_LANG_LIBS.contains(module)) {
            return this;
        }
        try {
            this.workspaceManager.loadProject(this.filePath);
        }
        catch (EventSyncException | WorkspaceDocumentException e) {
            return this;
        }
        Object importSignature = CommonUtils.getImportStatement((String)org, (String)module, (String)module);
        if (defaultNamespace) {
            importSignature = (String)importSignature + " as _";
        }
        this.imports.add((String)importSignature);
        return this;
    }

    public Optional<String> getExpressionBodyText(String typeName, Map<String, String> imports) {
        String bodyText;
        SemanticModel semanticModel;
        Optional optionalType;
        PackageUtil.loadProject((WorkspaceManager)this.workspaceManager, (Path)this.filePath);
        Document document = FileSystemUtils.getDocument(this.workspaceManager, this.filePath);
        HashMap packageMap = new HashMap();
        if (imports != null) {
            imports.values().forEach(moduleId -> {
                ModuleInfo moduleInfo = ModuleInfo.from((String)moduleId);
                PackageUtil.pullModuleAndNotify((LSClientLogger)this.lsClientLogger, (ModuleInfo)moduleInfo).ifPresent(pkg -> packageMap.put(CommonUtils.getDefaultModulePrefix((String)pkg.packageName().value()), PackageUtil.getCompilation((Package)pkg).defaultModuleBLangPackage()));
            });
        }
        if ((optionalType = (semanticModel = FileSystemUtils.getSemanticModel(this.workspaceManager, this.filePath)).types().getType(document, typeName, packageMap)).isEmpty()) {
            return Optional.empty();
        }
        TypeSymbol typeSymbol = (TypeSymbol)optionalType.get();
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            TypeReferenceTypeSymbol typeDefinitionSymbol = (TypeReferenceTypeSymbol)typeSymbol;
            typeSymbol = typeDefinitionSymbol.typeDescriptor();
        }
        if (typeSymbol.typeKind() == TypeDescKind.RECORD) {
            String recordFields = RecordUtil.getFillAllRecordFieldInsertText((Map)((RecordTypeSymbol)typeSymbol).fieldDescriptors());
            bodyText = String.format("{%n%s%n}", recordFields);
        } else {
            bodyText = DefaultValueGeneratorUtil.getDefaultValueForType((TypeSymbol)typeSymbol);
        }
        return Optional.of(bodyText);
    }

    public SourceBuilder typedBindingPattern() {
        return this.typedBindingPattern("type");
    }

    public SourceBuilder typedBindingPattern(String typeKey) {
        Optional<Property> type = this.getProperty(typeKey);
        Optional<Property> variable = this.getProperty("variable");
        if (type.isPresent() && variable.isPresent()) {
            this.tokenBuilder.expressionWithType(type.get(), variable.get());
        }
        return this;
    }

    public SourceBuilder body(List<FlowNode> flowNodes) {
        this.tokenBuilder.openBrace();
        this.children(flowNodes);
        this.tokenBuilder.closeBrace();
        return this;
    }

    public SourceBuilder children(List<FlowNode> flowNodes) {
        for (FlowNode node : flowNodes) {
            SourceBuilder sourceBuilder = new SourceBuilder(node, this.workspaceManager, this.filePath, this.lsClientLogger);
            Map<Path, List<TextEdit>> textEdits = NodeBuilder.getNodeFromKind(node.codedata().node()).toSource(sourceBuilder);
            List<TextEdit> filePathTextEdits = textEdits.get(this.filePath);
            this.tokenBuilder.name(filePathTextEdits.get(filePathTextEdits.size() - 1).getNewText());
        }
        return this;
    }

    public SourceBuilder onFailure() {
        Optional<Branch> optOnFailureBranch = this.flowNode.getBranch("On Failure");
        if (optOnFailureBranch.isEmpty()) {
            return this;
        }
        Branch onFailureBranch = optOnFailureBranch.get();
        Optional<Property> ignoreProperty = onFailureBranch.getProperty("ignore");
        if (ignoreProperty.isPresent() && ignoreProperty.get().value().equals("true")) {
            return this;
        }
        this.tokenBuilder.keyword(SyntaxKind.ON_KEYWORD).keyword(SyntaxKind.FAIL_KEYWORD);
        Optional<Property> onErrorType = onFailureBranch.getProperty("errorType");
        Optional<Property> onErrorValue = onFailureBranch.getProperty("errorVariable");
        if (onErrorType.isPresent() && onErrorValue.isPresent()) {
            this.tokenBuilder.expressionWithType(onErrorType.get(), onErrorValue.get());
        }
        this.body(onFailureBranch.children());
        return this;
    }

    public SourceBuilder functionParameters(FlowNode nodeTemplate, Set<String> ignoredProperties) {
        return this.functionParameters(nodeTemplate, ignoredProperties, false);
    }

    public SourceBuilder functionParameters(FlowNode nodeTemplate, Set<String> ignoredProperties, boolean setFormat) {
        Map<String, Property> properties;
        this.tokenBuilder.keyword(SyntaxKind.OPEN_PAREN_TOKEN);
        if (setFormat) {
            this.tokenBuilder.name(System.lineSeparator());
        }
        LinkedHashSet keys = new LinkedHashSet((properties = nodeTemplate.properties()) != null ? properties.keySet() : Set.of());
        keys.removeAll(ignoredProperties);
        boolean firstParamAdded = false;
        boolean missedDefaultValue = false;
        for (String key : keys) {
            Optional<Property> property = this.getProperty(key);
            if (property.isEmpty()) continue;
            Property prop = property.get();
            String kind = prop.codedata().kind();
            boolean optional = prop.optional();
            if (kind.equals(ParameterData.Kind.PARAM_FOR_TYPE_INFER.name())) continue;
            if (firstParamAdded) {
                if (kind.equals(ParameterData.Kind.REST_PARAMETER.name())) {
                    if (this.isPropValueEmpty(prop) || ((List)prop.value()).isEmpty()) continue;
                    if (this.hasRestParamValues(prop)) {
                        this.tokenBuilder.keyword(SyntaxKind.COMMA_TOKEN);
                        this.addRestParamValues(prop);
                        continue;
                    }
                } else if (kind.equals(ParameterData.Kind.INCLUDED_RECORD_REST.name())) {
                    if (this.isPropValueEmpty(prop) || ((List)prop.value()).isEmpty()) continue;
                    if (this.hasRestParamValues(prop)) {
                        this.tokenBuilder.keyword(SyntaxKind.COMMA_TOKEN);
                        this.addIncludedRecordRestParamValues(prop);
                        continue;
                    }
                }
            }
            if (!optional && kind.equals(ParameterData.Kind.REQUIRED.name())) {
                if (firstParamAdded) {
                    this.tokenBuilder.keyword(SyntaxKind.COMMA_TOKEN);
                }
                this.tokenBuilder.param(prop);
            } else if (kind.equals(ParameterData.Kind.INCLUDED_RECORD.name())) {
                if (this.isPropValueEmpty(prop)) continue;
                if (firstParamAdded) {
                    this.tokenBuilder.keyword(SyntaxKind.COMMA_TOKEN);
                }
                this.tokenBuilder.param(prop);
            } else if (kind.equals(ParameterData.Kind.DEFAULTABLE.name())) {
                if (this.isPropValueEmpty(prop)) {
                    missedDefaultValue = true;
                    continue;
                }
                if (prop.placeholder().equals(prop.value())) continue;
                if (firstParamAdded) {
                    this.tokenBuilder.keyword(SyntaxKind.COMMA_TOKEN);
                }
                if (missedDefaultValue) {
                    this.tokenBuilder.name(prop.codedata().originalName()).whiteSpace().keyword(SyntaxKind.EQUAL_TOKEN).expression(prop);
                } else {
                    this.tokenBuilder.param(prop);
                }
            } else if (kind.equals(ParameterData.Kind.INCLUDED_FIELD.name())) {
                if (this.isPropValueEmpty(prop)) continue;
                if (firstParamAdded) {
                    this.tokenBuilder.keyword(SyntaxKind.COMMA_TOKEN);
                }
                this.tokenBuilder.name(prop.codedata().originalName()).whiteSpace().keyword(SyntaxKind.EQUAL_TOKEN).expression(prop);
            } else if (kind.equals(ParameterData.Kind.REST_PARAMETER.name())) {
                if (this.isPropValueEmpty(prop) || ((List)prop.value()).isEmpty()) continue;
                if (firstParamAdded) {
                    this.tokenBuilder.keyword(SyntaxKind.COMMA_TOKEN);
                }
                this.addRestParamValues(prop);
            } else if (kind.equals(ParameterData.Kind.INCLUDED_RECORD_REST.name())) {
                if (this.isPropValueEmpty(prop) || ((List)prop.value()).isEmpty()) continue;
                if (firstParamAdded) {
                    this.tokenBuilder.keyword(SyntaxKind.COMMA_TOKEN);
                }
                this.addIncludedRecordRestParamValues(prop);
            }
            firstParamAdded = true;
        }
        this.tokenBuilder.keyword(SyntaxKind.CLOSE_PAREN_TOKEN).endOfStatement();
        return this;
    }

    private boolean isPropValueEmpty(Property property) {
        return property.value() == null || property.optional() && property.value().toString().isEmpty();
    }

    private boolean hasRestParamValues(Property prop) {
        Object object = prop.value();
        if (object instanceof List) {
            List values = (List)object;
            return !values.isEmpty();
        }
        return false;
    }

    private void addRestParamValues(Property prop) {
        List values;
        Object object = prop.value();
        if (object instanceof List && !(values = (List)object).isEmpty()) {
            List<String> strValues = ((List)prop.value()).stream().map(Object::toString).toList();
            this.tokenBuilder.expression(String.join((CharSequence)", ", strValues));
        }
    }

    private void addIncludedRecordRestParamValues(Property prop) {
        List values;
        if (prop.value() instanceof List && !(values = (List)prop.value()).isEmpty()) {
            ArrayList result = new ArrayList();
            values.forEach(keyValuePair -> {
                String key = (String)keyValuePair.keySet().iterator().next();
                String value = keyValuePair.values().iterator().next().toString();
                result.add(key + " = " + value);
            });
            this.tokenBuilder.expression(String.join((CharSequence)", ", result));
        }
    }

    public SourceBuilder textEdit() {
        return this.textEdit(SourceKind.STATEMENT, this.filePath, this.defaultRange);
    }

    public SourceBuilder textEdit(SourceKind sourceKind) {
        return this.textEdit(sourceKind, this.filePath, this.defaultRange);
    }

    public SourceBuilder textEdit(SourceKind sourceKind, Path filePath, Range range) {
        String text = this.token().build(sourceKind);
        this.tokenBuilder = new TokenBuilder(this);
        List<TextEdit> textEdits = this.textEditsMap.get(filePath);
        if (textEdits == null) {
            textEdits = new ArrayList<TextEdit>();
        }
        textEdits.addFirst(new TextEdit(range, text));
        this.textEditsMap.put(filePath, textEdits);
        return this;
    }

    public SourceBuilder comment() {
        String comment = this.token().skipFormatting().build(SourceKind.STATEMENT);
        this.tokenBuilder = new TokenBuilder(this);
        List<TextEdit> textEdits = this.textEditsMap.get(this.filePath);
        if (textEdits == null) {
            textEdits = new ArrayList<TextEdit>();
        }
        textEdits.add(0, new TextEdit(CommonUtils.toRange((LineRange)this.flowNode.codedata().lineRange()), comment));
        this.textEditsMap.put(this.filePath, textEdits);
        return this;
    }

    public Map<Path, List<TextEdit>> build() {
        this.addImports();
        return this.textEditsMap;
    }

    private void addImports() {
        boolean isGenerated;
        String currentModuleName;
        try {
            this.workspaceManager.loadProject(this.filePath);
        }
        catch (EventSyncException | WorkspaceDocumentException e) {
            return;
        }
        Document document = FileSystemUtils.getDocument(this.workspaceManager, this.filePath);
        SyntaxTree syntaxTree = document.syntaxTree();
        LinePosition startLine = syntaxTree.rootNode().lineRange().startLine();
        Range startLineRange = CommonUtils.toRange((LinePosition)startLine);
        Optional currentModule = this.workspaceManager.module(this.filePath);
        if (currentModule.isPresent()) {
            ModuleDescriptor descriptor = ((Module)currentModule.get()).descriptor();
            currentModuleName = descriptor.name().toString();
            String currentModuleOrg = descriptor.org().value();
            this.imports.remove(currentModuleOrg + "/" + currentModuleName);
            isGenerated = Boolean.TRUE.equals(this.flowNode.codedata().isGenerated());
        } else {
            currentModuleName = "";
            isGenerated = false;
        }
        ModulePartNode rootNode = (ModulePartNode)syntaxTree.rootNode();
        for (ImportDeclarationNode existingImport : rootNode.imports()) {
            String moduleName = existingImport.moduleName().stream().map(Token::text).collect(Collectors.joining("."));
            String prefix = existingImport.orgName().map(org -> org.orgName().text() + "/").orElse("");
            this.imports.remove(prefix + moduleName);
        }
        for (String moduleImport : this.imports) {
            Object importPrefix = isGenerated ? currentModuleName + "." : "";
            this.tokenBuilder.keyword(SyntaxKind.IMPORT_KEYWORD).name((String)importPrefix + moduleImport).endOfStatement();
            this.textEdit(SourceKind.IMPORT, this.filePath, startLineRange);
        }
    }

    public static class TokenBuilder
    extends FacetedBuilder<SourceBuilder> {
        private boolean skipFormatting;
        private static final String WHITE_SPACE = " ";
        private static final FormattingTreeModifier treeModifier = new FormattingTreeModifier(FormattingOptions.builder().build(), (LineRange)null);
        private final StringBuilder sb = new StringBuilder();

        public TokenBuilder(SourceBuilder parentBuilder) {
            super(parentBuilder);
        }

        public TokenBuilder keyword(SyntaxKind keyword) {
            this.sb.append(keyword.stringValue()).append(WHITE_SPACE);
            return this;
        }

        public TokenBuilder name(String name) {
            this.sb.append(name);
            return this;
        }

        public TokenBuilder resourcePath(String path) {
            this.sb.append(path);
            return this;
        }

        public TokenBuilder name(Property property) {
            this.sb.append(property.toSourceCode());
            return this;
        }

        public TokenBuilder comment(String comment) {
            this.sb.append(comment);
            return this;
        }

        public TokenBuilder expression(Property property) {
            this.sb.append(property.toSourceCode());
            return this;
        }

        public TokenBuilder param(Property property) {
            Object source = property.toSourceCode();
            if (((String)source).startsWith("$")) {
                source = "'" + ((String)source).substring(1);
            }
            this.sb.append((String)source);
            return this;
        }

        public TokenBuilder expression(String exprAsStr) {
            this.sb.append(exprAsStr);
            return this;
        }

        public TokenBuilder expressionWithType(Property type, Property variable) {
            this.sb.append(type.toSourceCode()).append(WHITE_SPACE).append(variable.toSourceCode()).append(WHITE_SPACE);
            return this;
        }

        public TokenBuilder expressionWithType(String type, Property variable) {
            this.sb.append(type).append(WHITE_SPACE).append(variable.toSourceCode()).append(WHITE_SPACE);
            return this;
        }

        public TokenBuilder expressionWithType(Property property) {
            this.sb.append(property.valueType()).append(WHITE_SPACE).append(property.toSourceCode());
            return this;
        }

        public TokenBuilder whiteSpace() {
            this.sb.append(WHITE_SPACE);
            return this;
        }

        public TokenBuilder openBrace() {
            this.sb.append(SyntaxKind.OPEN_BRACE_TOKEN.stringValue()).append(System.lineSeparator());
            return this;
        }

        public TokenBuilder equal() {
            this.sb.append(WHITE_SPACE).append(SyntaxKind.EQUAL_TOKEN.stringValue()).append(WHITE_SPACE);
            return this;
        }

        public TokenBuilder semicolon() {
            this.sb.append(SyntaxKind.SEMICOLON_TOKEN.stringValue()).append(System.lineSeparator());
            return this;
        }

        public TokenBuilder closeBrace() {
            this.sb.append(WHITE_SPACE).append(SyntaxKind.CLOSE_BRACE_TOKEN.stringValue()).append(WHITE_SPACE);
            return this;
        }

        public TokenBuilder openParen() {
            this.sb.append(SyntaxKind.OPEN_PAREN_TOKEN.stringValue());
            return this;
        }

        public TokenBuilder closeParen() {
            this.sb.append(SyntaxKind.CLOSE_PAREN_TOKEN.stringValue());
            return this;
        }

        public TokenBuilder endOfStatement() {
            this.sb.append(SyntaxKind.SEMICOLON_TOKEN.stringValue()).append(System.lineSeparator());
            return this;
        }

        public TokenBuilder skipFormatting() {
            this.skipFormatting = true;
            return this;
        }

        public TokenBuilder descriptionDoc(String description) {
            this.sb.append(SyntaxKind.HASH_TOKEN.stringValue()).append(WHITE_SPACE);
            this.appendDescription(description.split(System.lineSeparator()));
            if (!description.endsWith(System.lineSeparator())) {
                this.sb.append(System.lineSeparator());
            }
            return this;
        }

        public TokenBuilder parameterDoc(String paramName, String description) {
            if (description != null && !description.isEmpty()) {
                this.sb.append(SyntaxKind.HASH_TOKEN.stringValue()).append(WHITE_SPACE).append(SyntaxKind.PLUS_TOKEN.stringValue()).append(WHITE_SPACE).append(paramName).append(WHITE_SPACE).append("-").append(WHITE_SPACE);
                this.appendDescription(description.split(System.lineSeparator()));
                if (!description.endsWith(System.lineSeparator())) {
                    this.sb.append(System.lineSeparator());
                }
            }
            return this;
        }

        public TokenBuilder returnDoc(String returnDescription) {
            if (returnDescription != null && !returnDescription.isEmpty()) {
                this.sb.append(SyntaxKind.HASH_TOKEN.stringValue()).append(WHITE_SPACE).append(SyntaxKind.PLUS_TOKEN.stringValue()).append(WHITE_SPACE).append(SyntaxKind.RETURN_KEYWORD.stringValue()).append(WHITE_SPACE).append("-").append(WHITE_SPACE);
                this.appendDescription(returnDescription.split(System.lineSeparator()));
                if (!returnDescription.endsWith(System.lineSeparator())) {
                    this.sb.append(System.lineSeparator());
                }
            }
            return this;
        }

        private void appendDescription(String[] descLines) {
            this.sb.append(descLines[0]);
            for (int i = 1; i < descLines.length; ++i) {
                this.sb.append(System.lineSeparator());
                this.sb.append(SyntaxKind.HASH_TOKEN.stringValue()).append(WHITE_SPACE).append(descLines[i]);
            }
        }

        public String build(SourceKind kind) {
            String outputStr = this.sb.toString();
            if (this.skipFormatting) {
                return outputStr;
            }
            ModuleMemberDeclarationNode parsedNode = switch (kind.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> NodeParser.parseModuleMemberDeclaration((String)outputStr);
                case 1 -> NodeParser.parseStatement((String)outputStr);
                case 2 -> NodeParser.parseExpression((String)outputStr);
                case 3 -> NodeParser.parseImportDeclaration((String)outputStr);
            };
            return ((Node)parsedNode.apply((NodeTransformer)treeModifier)).toSourceCode().strip();
        }
    }

    public static enum SourceKind {
        DECLARATION,
        STATEMENT,
        EXPRESSION,
        IMPORT;

    }
}

