/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import com.google.gson.Gson;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.FunctionDefinitionBuilder;
import io.ballerina.tools.text.LineRange;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.model.types.TypeKind;
import org.eclipse.lsp4j.TextEdit;

public class AutomationBuilder
extends FunctionDefinitionBuilder {
    public static final String LABEL = "Automation";
    public static final String DESCRIPTION = "Define an automation";
    public static final String MAIN_FUNCTION_NAME = "main";
    public static final String PARAMETERS_LABEL = "Startup Parameters";
    public static final String PARAMETERS_DOC = "Define the parameters to be passed to the automation at startup";
    public static final String RETURN_ERROR_KEY = "returnError";
    public static final String RETURN_ERROR_LABEL = "Return Error";
    public static final String RETURN_ERROR_DOC = "Indicate if the automation should exit with error";
    private static final String BALLERINA_LOG_MODULE = "log";
    private static final String DEFAULT_BODY = "do {\n} on fail error e {\n  log:printError(\"Error occurred\", 'error=e);\n   return e;\n}";
    private static final List<String> TYPE_CONSTRAINT = List.of(TypeKind.STRING.typeName(), TypeKind.INT.typeName(), TypeKind.FLOAT.typeName(), TypeKind.DECIMAL.typeName(), TypeKind.BYTE.typeName());
    private static final Gson gson = new Gson();

    public static Property getParameterSchema() {
        return ParameterSchemaHolder.PARAMETER_SCHEMA;
    }

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.AUTOMATION);
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        AutomationBuilder.sendMandatoryProperties(this);
        AutomationBuilder.setOptionalProperties(this, true);
    }

    public static void sendMandatoryProperties(NodeBuilder nodeBuilder) {
        ((FormBuilder)((Property.Builder)nodeBuilder.properties().custom().metadata().label("Name").description("Name of the function").stepOut()).value(MAIN_FUNCTION_NAME).type(Property.ValueType.IDENTIFIER).typeConstraint("Global").hidden().stepOut()).addProperty("functionName");
        nodeBuilder.properties().nestedProperty();
    }

    public static void setProperty(FormBuilder<?> formBuilder, String type, String name, Token token) {
        formBuilder.parameter(type, name, token, Property.ValueType.SINGLE_SELECT, TYPE_CONSTRAINT);
    }

    public static void setOptionalProperties(NodeBuilder nodeBuilder, boolean returnError) {
        nodeBuilder.properties().endNestedProperty(Property.ValueType.REPEATABLE_PROPERTY, "parameters", PARAMETERS_LABEL, PARAMETERS_DOC, AutomationBuilder.getParameterSchema(), true, true);
        ((FormBuilder)((Property.Builder)nodeBuilder.properties().custom().metadata().label(RETURN_ERROR_LABEL).description(RETURN_ERROR_DOC).stepOut()).value(returnError).editable(true).type(Property.ValueType.FLAG).advanced(true).stepOut()).addProperty(RETURN_ERROR_KEY);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        LineRange lineRange;
        boolean hasReturnError;
        Object object;
        sourceBuilder.token().keyword(SyntaxKind.PUBLIC_KEYWORD).keyword(SyntaxKind.FUNCTION_KEYWORD).name(MAIN_FUNCTION_NAME).keyword(SyntaxKind.OPEN_PAREN_TOKEN);
        Optional<Property> parameters = sourceBuilder.getProperty("parameters");
        if (parameters.isPresent() && (object = parameters.get().value()) instanceof Map) {
            Map paramMap = (Map)object;
            ArrayList<CallSite> paramList = new ArrayList<CallSite>();
            for (Object obj : paramMap.values()) {
                Property paramProperty = (Property)gson.fromJson(gson.toJsonTree(obj), Property.class);
                Object object2 = paramProperty.value();
                if (!(object2 instanceof Map)) continue;
                Map paramData = (Map)object2;
                Map paramProperties = (Map)gson.fromJson(gson.toJsonTree((Object)paramData), FormBuilder.NODE_PROPERTIES_TYPE);
                String paramType = ((Property)paramProperties.get("type")).value().toString();
                String paramName = ((Property)paramProperties.get("variable")).value().toString();
                paramList.add((CallSite)((Object)(paramType + " " + paramName)));
            }
            sourceBuilder.token().name(String.join((CharSequence)", ", paramList));
        }
        sourceBuilder.token().keyword(SyntaxKind.CLOSE_PAREN_TOKEN);
        Optional<Property> returnError = sourceBuilder.getProperty(RETURN_ERROR_KEY);
        boolean bl = hasReturnError = returnError.isPresent() && returnError.get().value().equals(true);
        if (hasReturnError) {
            sourceBuilder.token().keyword(SyntaxKind.RETURNS_KEYWORD).name("error?");
        }
        if ((lineRange = sourceBuilder.flowNode.codedata().lineRange()) == null) {
            sourceBuilder.token().openBrace();
            if (hasReturnError) {
                sourceBuilder.token().name(DEFAULT_BODY);
                sourceBuilder.acceptImport("ballerina", BALLERINA_LOG_MODULE);
            }
            ((SourceBuilder)sourceBuilder.token().closeBrace().stepOut()).textEdit(SourceBuilder.SourceKind.DECLARATION);
        } else {
            ((SourceBuilder)sourceBuilder.token().skipFormatting().stepOut()).textEdit();
        }
        return sourceBuilder.build();
    }

    private static class ParameterSchemaHolder {
        private static final Property PARAMETER_SCHEMA = ParameterSchemaHolder.initParameterSchema();

        private ParameterSchemaHolder() {
        }

        private static Property initParameterSchema() {
            FormBuilder<Object> formBuilder = new FormBuilder<Object>(null, null, null, null);
            AutomationBuilder.setProperty(formBuilder, "", "", null);
            formBuilder.parameter("", "", null, Property.ValueType.SINGLE_SELECT, TYPE_CONSTRAINT);
            Map<String, Property> nodeProperties = formBuilder.build();
            return nodeProperties.get("");
        }
    }
}

