/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.TextEdit;

public class CommentBuilder
extends NodeBuilder {
    public static final String LABEL = "Comment";
    public static final String DESCRIPTION = "Comment of a node";
    private static final String DOUBLE_SLASH = "// ";
    private static final String NEW_LINE = System.lineSeparator();

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL);
        this.codedata().node(NodeKind.COMMENT);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Optional<Property> property = sourceBuilder.getProperty("comment");
        if (property.isEmpty()) {
            throw new IllegalStateException("Comment must be defined for a comment node");
        }
        String formattedComment = Arrays.stream(property.get().toSourceCode().split("\n")).map(line -> DOUBLE_SLASH + line + NEW_LINE).collect(Collectors.joining());
        return ((SourceBuilder)sourceBuilder.token().name(NEW_LINE).name(formattedComment).stepOut()).comment().build();
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.properties().comment("");
    }
}

