/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.Branch;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class ErrorHandlerBuilder
extends NodeBuilder {
    public static final String LABEL = "ErrorHandler";
    public static final String DESCRIPTION = "Catch and handle errors";
    public static final String ERROR_HANDLER_BODY = "Body";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.ERROR_HANDLER);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Optional<Branch> body = sourceBuilder.flowNode.getBranch(ERROR_HANDLER_BODY);
        ((SourceBuilder)sourceBuilder.token().keyword(SyntaxKind.DO_KEYWORD).stepOut()).body(body.isPresent() ? body.get().children() : Collections.emptyList());
        sourceBuilder.onFailure();
        return sourceBuilder.textEdit().build();
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.branches = List.of(Branch.DEFAULT_BODY_BRANCH, Branch.getDefaultOnFailBranch(false));
    }
}

