/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import com.google.gson.Gson;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import io.ballerina.tools.text.LineRange;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class FunctionDefinitionBuilder
extends NodeBuilder {
    public static final String LABEL = "Function Definition";
    public static final String DESCRIPTION = "Define a function";
    public static final String FUNCTION_NAME_LABEL = "Name";
    public static final String ANNOTATIONS_LABEL = "Annotations";
    public static final String FUNCTION_NAME_DOC = "Name of the function";
    public static final String ANNOTATION_DOC = "Annotations of the function";
    public static final String PARAMETERS_LABEL = "Parameters";
    public static final String PARAMETERS_DOC = "Function parameters";
    public static final String METADATA_RETURN_KEY = "return";
    public static final String METADATA_PARAMETERS_KEY = "parameters";
    private static final Gson gson = new Gson();

    public static Property getParameterSchema() {
        return ParameterSchemaHolder.PARAMETER_SCHEMA;
    }

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.FUNCTION_DEFINITION);
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.properties().functionNameTemplate("function", context.getAllVisibleSymbolNames());
        FunctionDefinitionBuilder.setMandatoryProperties(this, null, "", "");
        FunctionDefinitionBuilder.setOptionalProperties(this);
    }

    public static void setMandatoryProperties(NodeBuilder nodeBuilder, String returnType, String description, String returnDescription) {
        nodeBuilder.properties().functionDescription(description).returnType(returnType, null, true).returnDescription(returnDescription).nestedProperty();
    }

    public static void setProperty(FormBuilder<?> formBuilder, String type, String name, String description, Token token) {
        formBuilder.parameterWithDescription(type, name, token, Property.ValueType.TYPE, null, description);
    }

    public static void setOptionalProperties(NodeBuilder nodeBuilder) {
        nodeBuilder.properties().endNestedProperty(Property.ValueType.REPEATABLE_PROPERTY, METADATA_PARAMETERS_KEY, PARAMETERS_LABEL, PARAMETERS_DOC, FunctionDefinitionBuilder.getParameterSchema(), true, false);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        LineRange lineRange;
        Optional<Property> isolatedProperty;
        Optional<Property> annotationsProperty;
        Optional<Property> funcNameProperty;
        Object object;
        Optional<Property> optDescription = sourceBuilder.getProperty("functionNameDescription");
        String description = "";
        if (optDescription.isPresent()) {
            description = optDescription.get().value().toString();
        }
        Optional<Property> parameters = sourceBuilder.getProperty(METADATA_PARAMETERS_KEY);
        String params = "";
        HashMap<String, String> paramsDesc = new HashMap<String, String>();
        if (parameters.isPresent() && (object = parameters.get().value()) instanceof Map) {
            Map paramMap = (Map)object;
            ArrayList<CallSite> paramList = new ArrayList<CallSite>();
            for (Object obj : paramMap.values()) {
                String paramDescription2;
                Property property;
                Property paramProperty = (Property)gson.fromJson(gson.toJsonTree(obj), Property.class);
                Object object2 = paramProperty.value();
                if (!(object2 instanceof Map)) continue;
                Map paramData = (Map)object2;
                Map paramProperties = (Map)gson.fromJson(gson.toJsonTree((Object)paramData), FormBuilder.NODE_PROPERTIES_TYPE);
                String paramType = ((Property)paramProperties.get("type")).value().toString();
                String paramName2 = ((Property)paramProperties.get("variable")).value().toString();
                paramList.add((CallSite)((Object)(paramType + " " + paramName2)));
                if (!optDescription.isPresent() || (property = (Property)paramProperties.get("parameterDescription")) == null || (paramDescription2 = property.value().toString()).isEmpty()) continue;
                paramsDesc.put(paramName2, paramDescription2);
            }
            params = String.join((CharSequence)", ", paramList);
        }
        Optional<Property> optReturnDescription = sourceBuilder.getProperty("typeDescription");
        String returnDescription = "";
        if (optReturnDescription.isPresent()) {
            returnDescription = optReturnDescription.get().value().toString();
        }
        if ((funcNameProperty = sourceBuilder.getProperty("functionName")).isEmpty()) {
            throw new IllegalStateException("Function name is not present");
        }
        String funcName = funcNameProperty.get().value().toString();
        if (!description.isEmpty()) {
            sourceBuilder.token().descriptionDoc(description);
        }
        if (!paramsDesc.isEmpty() || !returnDescription.isEmpty()) {
            if (description.isEmpty()) {
                sourceBuilder.token().descriptionDoc(funcName + " description");
            }
            paramsDesc.forEach((paramName, paramDescription) -> sourceBuilder.token().parameterDoc((String)paramName, (String)paramDescription));
            if (!returnDescription.isEmpty()) {
                sourceBuilder.token().returnDoc(returnDescription);
            }
        }
        if ((annotationsProperty = sourceBuilder.getProperty("annotations")).isPresent()) {
            sourceBuilder.token().name(annotationsProperty.get().toSourceCode());
        }
        if ((isolatedProperty = sourceBuilder.getProperty("isIsolated")).isPresent()) {
            sourceBuilder.token().keyword(SyntaxKind.ISOLATED_KEYWORD);
        }
        sourceBuilder.token().keyword(SyntaxKind.FUNCTION_KEYWORD);
        sourceBuilder.token().name(funcName).keyword(SyntaxKind.OPEN_PAREN_TOKEN);
        if (!params.isEmpty()) {
            sourceBuilder.token().name(params);
        }
        sourceBuilder.token().keyword(SyntaxKind.CLOSE_PAREN_TOKEN);
        Optional<Property> returnType = sourceBuilder.getProperty("type");
        if (returnType.isPresent() && !returnType.get().value().toString().isEmpty()) {
            sourceBuilder.token().keyword(SyntaxKind.RETURNS_KEYWORD).name(returnType.get().value().toString());
        }
        if ((lineRange = sourceBuilder.flowNode.codedata().lineRange()) == null) {
            ((SourceBuilder)sourceBuilder.token().openBrace().closeBrace().stepOut()).textEdit(SourceBuilder.SourceKind.DECLARATION).acceptImport();
        } else {
            ((SourceBuilder)sourceBuilder.token().skipFormatting().stepOut()).textEdit();
        }
        return sourceBuilder.build();
    }

    private static class ParameterSchemaHolder {
        private static final Property PARAMETER_SCHEMA = ParameterSchemaHolder.initParameterSchema();

        private ParameterSchemaHolder() {
        }

        private static Property initParameterSchema() {
            FormBuilder<Object> formBuilder = new FormBuilder<Object>(null, null, null, null);
            FunctionDefinitionBuilder.setProperty(formBuilder, "", "", "", null);
            Map<String, Property> nodeProperties = formBuilder.build();
            return nodeProperties.get("");
        }
    }
}

