/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.Branch;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.TextEdit;

public class MatchBuilder
extends NodeBuilder {
    public static final String LABEL = "Match";
    public static final String DESCRIPTION = "Switches the data flow based on the value of an expression.";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.MATCH);
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.properties().condition(null);
        Branch.Builder defaultCaseBuilder = (Branch.Builder)((Branch.Builder)new Branch.Builder().codedata().node(NodeKind.CONDITIONAL).stepOut()).label("case").kind(Branch.BranchKind.BLOCK).repeatable(Branch.Repeatable.ONE_OR_MORE).properties().patterns((NodeList<Node>)NodeFactory.createEmptyNodeList()).stepOut();
        this.branches = List.of(defaultCaseBuilder.build(), Branch.getDefaultOnFailBranch(true));
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Optional<Property> condition = sourceBuilder.getProperty("condition");
        if (condition.isEmpty()) {
            throw new IllegalStateException("Match node does not have a condition");
        }
        ((SourceBuilder)sourceBuilder.token().keyword(SyntaxKind.MATCH_KEYWORD).expression(condition.get()).stepOut()).token().openBrace();
        for (Branch branch : sourceBuilder.flowNode.branches()) {
            Optional<Property> patterns = branch.getProperty("patterns");
            if (patterns.isEmpty()) continue;
            List<Property> patternsList = patterns.get().valueAsType(Property.LIST_PROPERTY_TYPE_TOKEN);
            String joinedPatterns = patternsList.stream().map(Property::toSourceCode).collect(Collectors.joining("|"));
            sourceBuilder.token().name(joinedPatterns);
            Optional<Property> guardProperty = branch.getProperty("guard");
            guardProperty.ifPresent(property -> sourceBuilder.token().keyword(SyntaxKind.IF_KEYWORD).whiteSpace().expression((Property)property));
            sourceBuilder.token().keyword(SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN).openBrace();
            sourceBuilder.children(branch.children());
            sourceBuilder.token().closeBrace();
        }
        sourceBuilder.token().closeBrace();
        sourceBuilder.onFailure();
        return sourceBuilder.textEdit().build();
    }
}

