/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import com.google.gson.Gson;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.FunctionDefinitionBuilder;
import io.ballerina.modelgenerator.commons.FunctionData;
import io.ballerina.modelgenerator.commons.FunctionDataBuilder;
import io.ballerina.modelgenerator.commons.ModuleInfo;
import io.ballerina.modelgenerator.commons.ParameterData;
import io.ballerina.tools.text.LineRange;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class NPFunctionDefinitionBuilder
extends FunctionDefinitionBuilder {
    public static final String LABEL = "Natural Function";
    public static final String DESCRIPTION = "Define a natural function";
    public static final String NATURAL_FUNCTION_PREFIX = "naturalFunction";
    public static final String NATURAL_FUNCTION_NAME_DESCRIPTION = "Name of the natural function";
    public static final String NATURAL_FUNCTION_NAME_LABEL = "Name";
    public static final String PARAMETERS_LABEL = "Parameters";
    public static final String PARAMETERS_DOC = "Function parameters";
    private static final String BALLERINAX_ORG = "ballerinax";
    private static final String NP_PACKAGE = "np";
    private static final String CALL_LLM_FUNCTION = "callLlm";
    private static final String NP_NATURAL_FUNCTION_BODY = "@np:NaturalFunction external";
    private static final Gson gson = new Gson();

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.NP_FUNCTION_DEFINITION).org(BALLERINAX_ORG).module(NP_PACKAGE);
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        Codedata codedata = context.codedata();
        FunctionDataBuilder functionDataBuilder = new FunctionDataBuilder().parentSymbolType(codedata.object()).name(CALL_LLM_FUNCTION).moduleInfo(new ModuleInfo(BALLERINAX_ORG, NP_PACKAGE, NP_PACKAGE, null)).lsClientLogger(context.lsClientLogger()).functionResultKind(FunctionData.Kind.FUNCTION).userModuleInfo(this.moduleInfo);
        functionDataBuilder.build();
        this.properties().functionNameTemplate(NATURAL_FUNCTION_PREFIX, context.getAllVisibleSymbolNames(), NATURAL_FUNCTION_NAME_LABEL, NATURAL_FUNCTION_NAME_DESCRIPTION);
        NPFunctionDefinitionBuilder.setMandatoryProperties(this, null);
        NPFunctionDefinitionBuilder.endOptionalProperties(this);
        ((FormBuilder)((Property.Builder)((Property.Builder)this.properties().custom().metadata().label("Prompt").description("Prompt for the function").stepOut()).codedata().kind(ParameterData.Kind.REQUIRED.name()).stepOut()).placeholder("").value("``").typeConstraint("np:Prompt").editable().hidden().type(Property.ValueType.RAW_TEMPLATE).stepOut()).addProperty("prompt");
        ((FormBuilder)((Property.Builder)this.properties().custom().metadata().label("Enable Model Context").description("Allow specifying Large Language Model (LLM) choice").stepOut()).editable().value(false).optional(true).advanced(true).type(Property.ValueType.FLAG).stepOut()).addProperty("enableModelContext");
    }

    public static void setMandatoryProperties(NodeBuilder nodeBuilder, String returnType) {
        nodeBuilder.properties().returnType(returnType, null, true).nestedProperty();
    }

    public static void endOptionalProperties(NodeBuilder nodeBuilder) {
        nodeBuilder.properties().endNestedProperty(Property.ValueType.REPEATABLE_PROPERTY, "parameters", PARAMETERS_LABEL, PARAMETERS_DOC, NPFunctionDefinitionBuilder.getParameterSchema(), true, false);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Object object;
        Optional<Property> parameters;
        sourceBuilder.token().keyword(SyntaxKind.FUNCTION_KEYWORD);
        FlowNode flowNode = sourceBuilder.flowNode;
        Optional<Property> property = sourceBuilder.getProperty("functionName");
        if (property.isEmpty()) {
            throw new IllegalStateException("Function name is not present");
        }
        sourceBuilder.token().name(property.get().value().toString()).keyword(SyntaxKind.OPEN_PAREN_TOKEN);
        Optional<Property> isModelContextEnabled = sourceBuilder.getProperty("enableModelContext");
        if (isModelContextEnabled.isPresent() && ((Boolean)isModelContextEnabled.get().value()).booleanValue()) {
            sourceBuilder.token().name("np:Context context");
            sourceBuilder.token().keyword(SyntaxKind.COMMA_TOKEN);
        }
        if ((parameters = sourceBuilder.getProperty("parameters")).isPresent() && (object = parameters.get().value()) instanceof Map) {
            Map paramMap = (Map)object;
            ArrayList<CallSite> paramList = new ArrayList<CallSite>();
            for (Object obj : paramMap.values()) {
                Property paramProperty = (Property)gson.fromJson(gson.toJsonTree(obj), Property.class);
                Object object2 = paramProperty.value();
                if (!(object2 instanceof Map)) continue;
                Map paramData = (Map)object2;
                Map paramProperties = (Map)gson.fromJson(gson.toJsonTree((Object)paramData), FormBuilder.NODE_PROPERTIES_TYPE);
                String paramType = ((Property)paramProperties.get("type")).value().toString();
                String paramName = ((Property)paramProperties.get("variable")).value().toString();
                paramList.add((CallSite)((Object)(paramType + " " + paramName)));
            }
            sourceBuilder.token().name(String.join((CharSequence)", ", paramList));
            if (!paramList.isEmpty()) {
                sourceBuilder.token().keyword(SyntaxKind.COMMA_TOKEN);
            }
        }
        Optional<Property> promptProperty = sourceBuilder.getProperty("prompt");
        String defaultValue = promptProperty.map(value -> " = " + value.value().toString()).orElse("");
        sourceBuilder.token().name("np:Prompt prompt" + defaultValue);
        sourceBuilder.token().keyword(SyntaxKind.CLOSE_PAREN_TOKEN);
        Optional<Property> returnType = sourceBuilder.getProperty("type");
        if (returnType.isPresent() && !returnType.get().value().toString().isEmpty()) {
            if (returnType.get().value().toString().contains("error")) {
                sourceBuilder.token().keyword(SyntaxKind.RETURNS_KEYWORD).name(returnType.get().value().toString());
            } else {
                sourceBuilder.token().keyword(SyntaxKind.RETURNS_KEYWORD).name(String.valueOf(returnType.get().value()) + "|error");
            }
        } else {
            sourceBuilder.token().keyword(SyntaxKind.RETURNS_KEYWORD).name("error?");
        }
        LineRange lineRange = flowNode.codedata().lineRange();
        if (lineRange == null) {
            ((SourceBuilder)sourceBuilder.token().equal().name(NP_NATURAL_FUNCTION_BODY).semicolon().skipFormatting().stepOut()).textEdit(SourceBuilder.SourceKind.DECLARATION).acceptImport();
        } else {
            ((SourceBuilder)sourceBuilder.token().skipFormatting().stepOut()).textEdit();
        }
        return sourceBuilder.build();
    }
}

